/**
 * Copyright ASCFSSTO ( http://wonderfl.net/user/ASCFSSTO )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aF5U
 */

2007年06月29日Arduino
Flashとセンサーをつなぐ（mac）
ここと同じもので、mac上でも動かしてみた。

ファイルをダウンロード zip

設定方法
1.ダウンロードしたフォルダのserproxy-mac/serproxy.cfgファイルに、
シリアルUSBポートのの設定を書き込む。
例：serial_device1=/dev/cu.usbserial-A4001d32
設定の調べ方は、パソコンにarduinoを接続させて、Processingのlist()コマンドでポートの一覧を表示させる。リストの中から/dev/cu.usbserial-から始まるものを選び、/dev/cu.usbserial-A4001d32の部分を自分の環境に置き換える

2.serproxy-macフォルダのserproxyを起動する
（serproxyは、シリアル通信とxmlSocketをつなぐ変換するアプリケーション）

3.flashで、comポートは、5331にしてパブリッシュする

うまく、つながれば、グラフが描けるとおもいます。


Arduinoのwindows用サンプルは、serproxyを起動すれば、
windowsと同じように動きます。

17:26 | direct link 
2007年06月20日工作
GPSをつないでみる
小型ＧＰＳモジュールを使ってみる。



高感度小型ＧＰＳモジュール（３．３Ｖ～５Ｖ） 

３０ｍｍのサイズの中にアンテナや、LSIが収まっている。
3.3Vでデータを送ってくるので、
ＵＳＢ→シリアル変換モジュールキット「ＦＴ２３２ＲＸ」

も購入して、3.3Vで、USB接続できる環境も作った

ＧＰＳのデータは、1秒間隔で、
NMEA-0183フォーマット
で送られてくる。

このモジュールは、室内では、衛星の電波が受信できないらしく、
野外に出て、受信できた。
受信したデータは、以下のようなものだった。

$GPGSA,A,3,11,19,25,27,,,,,,,,,08.6,04.1,07.5*01
$GPGSV,2,1,07,11,57,230,40,16,08,130,00,19,60,029,45,25,35,236,39*7F
$GPGSV,2,2,07,27,37,266,38,01,,,29,08,,,37,,,,*40
$GPRMC,150947,A,3541.1627,N,13943.7758,E,002.7,235.5,170607,,,A*7D
$GPGGA,150948,3541.1627,N,13943.7758,E,1,04,04.1,00072.5,M,039.1,M,,*49
01:09 | direct link 
Arduino
Flashで、温度センサーを使う
今回は、LM35温度センサICをつかう。
 

 

LM35の特徴は、
温度係数はリニアで＋ 10.0mV/ ℃
気温、28度のとき、28X0.01=0.28Vになる。
数値が細かいので、オペアンプで値を増幅する必要がある。 

通常のオペアンプは、5V電源を使ったとき、出力が最大4Vになるが、
今回のオペアンプは、Rail to Rail機能のあるLMC6032を使って、
最大5Vまで出力させる。
 

増幅率は、2つの抵抗の比率で変えることができる。
OUT＝IN×(1＋R1/R2)
 

今回は、気温40度程度まで計れればいいので、
5/(40X0.01) = 12.5倍程度の増幅率でいいことになる。
手元にある部に品で、R1=10kΩ、R2=1kΩを選び、11倍の増幅率になるようにした。 

Arduinoのソースはここと同じ 

Flashのソース
受信して、少数を表示できるように計算した。 

import Arduino;

// 環境に合わせて、ポートを設定する。
// COM1:5331、COM2:5332、COM3:5333、COM4:5334、COM5:5335、COM6:5336
var port:Number = 5333;

var arduino:Arduino = new Arduino(port);

listenObj = new Object();

// データを受信
listenObj.onReceiveData = function(evtObj:Object){
    var msg = evtObj.data;
    var temperature = Math.floor(Number(msg)*5/(1024*11*0.01)*10);    // 少数計算のため10をかけている
    temperature /= 10;                                // 後から、10を割って小数一桁を計算する
    box.text = temperature ;        // テキストボックスに表示
}

// リスナー登録
arduino.addEventListener("onReceiveData", listenObj);
00:26 | direct link 
2007年06月17日Arduino
WiPort─ネットワークで、基盤にアクセスする（windows）
無線LANで、パソコンから基盤にアクセスできるWiPortを使ってみる。

WiPortは、小型で無線LANに接続できる小型ディバイス

無線LAN越しに基盤と、パソコンをシリアル接続で通信できます。


用意するもの
WiPort
基盤コネクタ
3.3Vレギュレータ
ADM3202AN（RSS232C<->TTL変換）


設定方法
1.若松通商で売っている基盤に、コネクタを半田付け後、WiPortと接続させる。

2.WiPortの設定を、シリアル接続で変更する。

2-1.WiPortのシリアルを、ADM3202ANで変換して、パソコンのシリアルと接続する。
WiPortのシリアルは2つあるが、つなぐのは16（TXD0）と17（RXD0）。
2-2.3.3Vの電源に2（Power）、11,12,23,24（GND）を接続。
2-3.シリアルの設定は、9600bps , 8ビット , パリなし , ストップビット1 , フロー制御なし
2-4.WiPortの電源を入れて、1秒以内にxxxを入力する。
2-5.うまくいくと、下の画面が表示される。

2-6.その後、4秒以内にEnterを押すと設定が表示される。

2-7.IPアドレスや無線LAN環境の設定をします。（1と4を設定しました）
詳細はここを参照

3.設定がうまくできると、ブラウザーからWiPortにアクセスができるようになります。


4.パソコンでシリアル接続できるように、Com Port Redirectorをインストールする。

5.Com Port Redirectorで、WiPortのアドレスと、
パソコンのシリアルポートを関連付けする。
詳細はこれを参照。

6.WiPortからADM3202ANをはずし、Arduinoと、接続する。
Arduino TX -> WiPort RXD0
Arduino RX -> WiPort TXD0

7.WiPortの電源を入れて、パソコンでシリアル通信をすれば、ネットワーク経由でアクセスできることが確認できる。

22:17 | direct link 
2007年06月14日Arduino
Bluetoothで、Flashに接続するスイッチを作る
今までは、USBケーブルでパソコンに接続していたが、
ワイヤレス通信ができるBluetoothで、パソコン上のFlashに接続させる。

今回は、トグルスイッチの変わりにフットスイッチで、
ワイヤレスにFlashをコントロールできるものを作った。

使用するパーツ
Bluetooth

電池で起動するときは、ジャンパーピンをEXTに切り替える。




Bluetoothの接続方法は、
Arduino基盤のRX→BluetoothのTX-O
Arduino基盤のTX→BluetoothのRX-I
に接続する。
それから、PWRとGNDを接続する。


電気が通ると、Bluetoothの緑色のLEDが点滅する。


パソコンとの接続後は、赤く点灯する。


Flashとの接続は、Flashで電子工作と同じです。

00:32 | direct link 
2007年06月13日Arduino
フォトインタラプタを使う2

前回フォトインタラプタを使いましたが、緩やかに、HIGHとLOWが変化して、
高速で変化するときに、対応ができませんでした。

今回は、論理回路、74HC14を使って、HIGHとLOWをはっきり出力させます。

74HC14には2つの機能があります。
1.論理反転・・・HIGHをLOW、LOWをHIGHに変換する。
2.ヒステシス・・・入力時の立ち上がりと、立下りで、HIGHとLOWの切り替え値を変え、ノイズの影響を受けにくくする。

データシートから、しきい値は
HIGHのとき2.7V
LOWのとき1.6V
となっている。

74HC14は、使わない入力はGNDに接続しておく。


16:46 | direct link 
2007年06月12日Arduino
フォトインタラプタを使う

フォトインタラプタ ＲＰＩ−３５２

発光部の最大電流が、50mA。
発光部のダイオードにつなぐ、抵抗を計算すると、
5V/0.05=100Ω
となる。
100Ω以上なら問題ないので、330Ωをつないだ


ソースは、スイッチと同じ。

16:41 | direct link 
2007年06月11日Arduino
Flashからモータを動かす
モータを基盤とは別の外部電源を使って、動かしてみる。
 

ソースをダウンロード 

使う部品
モータドライバ TA7291P （カタログ）
マブチモータ　FA-130RA 


モータドライバは、外部電源を使えるだけでなく、
モータの回転方向と速度を調整してくれる。 

ピンは、左から以下の機能がある。 

1. GND
2. モーターに接続
3. 接続しない
4. 速度調整のためのPWM（今回は9に接続）
5. モータ回転方向,停止制御 （今回は5に接続）
6. モータ回転方向,停止制御（今回は6に接続）
7. 5V
8. モーター電源（今回は、ACアダプターの5Vに接続）
9. 接続しない
10. モーターに接続 

arduinoのソース（サーボを流用） 

int motorPin1 = 5;            // モータ入力ピン
int motorPin2 = 6;            // モータ入力ピン
int speedPin = 9;             // 速度調整ピン

int keta, sum;                // データ受信用
int pulse = 0;               // PWMのHIGHの値
char cwFlg = 'c';             // モータ回転方向

const int KETAMAX = 4;        // 受信桁数
 
void setup() {
  pinMode(motorPin1, OUTPUT);
  pinMode(motorPin2, OUTPUT);
  pinMode(speedPin, OUTPUT);
  Serial.begin(9600);
}

void loop() {
  if(Serial.available()>0){       // データが来た
    int val = Serial.read();
    if(val == 'c' || val == 'n'){ // データのはじめ
      cwFlg = val;                // 回転方向
      iniKeta();
    }else{                  // 数値データ
      val -= 48;            // アスキー→数値に変換
      for(int i=1; i < keta; i++){  // 桁数を計算
        val *= 10;
      }
      sum += val;
      keta --;
      if(keta == 0){        // すべてのデータ受信終了
        pulse = constrain(sum, 0, 10000);  // オーバーフローする値を切り捨て
      }
    }
  }
  
  if(pulse == 0){           // モーター停止
    digitalWrite(motorPin1, LOW);
    digitalWrite(motorPin2, LOW);
  }else if(cwFlg == 'c'){   // 時計回転
    digitalWrite(motorPin1, HIGH);
    digitalWrite(motorPin2, LOW);
  }else{                    // 反時計回転
    digitalWrite(motorPin1, LOW);
    digitalWrite(motorPin2, HIGH);
  }
  
  // PWMで出力調整
  digitalWrite(speedPin, HIGH);
  delayMicroseconds(pulse);
  digitalWrite(speedPin, LOW);
  delay(10);
}

// 最初の桁に戻る
void iniKeta(){
  keta = KETAMAX;
  sum = 0;
}
サーボと違うところは、データの最初で、モータの回転方向を決めている。 
if(val == 'c' || val == 'n'){ // データのはじめ
  cwFlg = val;                // 回転方向
モータードライバーの8番ピンは、5V以上必要なので、乾電池で動かすときは、注意する必要がある。 

20:44 | direct link 
2007年06月08日Arduino
ロータリーエンコーダを使う
ロータリーエンコーダーは、回転から距離を図るセンサー。
今回使ったのは、OME-100-2MCA(105-015-00)
価格は高いが、2相出力するので、回転方向がわかる。 

まずは、回転を計測する
 
入力には、プルアップが必要で、10kΩを試した。
 

arduinoのソース 
volatile int count;
int backCount = 0;

void setup()
{
  count = 0;
  attachInterrupt(0, blink, RISING);
  Serial.begin(9600);
}

void loop()
{
  delay(100);
  int val = count - backCount;
  Serial.println(val);
  backCount = count;
}

void blink()
{
  count++;
}
ロータリーエンコーダーは回転させると、HIGHとLOWのパルスを送り出してくる。 HIGHに変わった瞬間を知るには、attachInterrupt関数を使う。 
attachInterrupt(0, blink, RISING);
attachInterruptは割り込み処理の関数で、変化があるとループ処理を一時停止して、上の場合だと、blink関数を呼び出す。 1つめの引数は、ポート番号。0,1がDigital 2,3に対応している。それと、割り込み処理の中で使う変数は、宣言時にvolatileをつける必要がある。 
2相出力で回転方向を計測
 

volatile int count;
int backCount = 0;
int inPutPin = 4;                     // Signal B

void setup()
{
  count = 0;
  attachInterrupt(0, blink, RISING);
  pinMode(inPutPin, INPUT);
  Serial.begin(9600);
}

void loop()
{
  delay(100);
  int val = count - backCount;
  Serial.println(val);
  backCount = count;
}

void blink()
{
  if(digitalRead(inPutPin) == HIGH){  // 逆回転
    count--;
  }else{
    count++;
  }
}
回転方向を知るために、Signal Bを、Dital 4ポートにつなぎ、
HIGHの時、逆回転、LOWの時、正回転になるので、countを引いたり足したりして、回転を計算している。 

if(digitalRead(inPutPin) == HIGH){  // 逆回転
  count--;
}else{
  count++;
}
16:20 | direct link 
2007年06月07日Arduino
圧電振動ジャイロをつかう
圧電振動ジャイロ　ＧＷＳ　ＰＧ-０３をつかってみる。


ラジコン飛行機などに使われるジャイロで、軸方向の回転を計測する。


デジタル出力なので、簡単にアナログ入力するには、回路の変更が必要になる。
改造は、このサイトを参考にさせてもらった。


1.アナログ線をPWM入力線にジャンパするため、線をつなげる
2.PWM入力線へ繋がっているラインをきる

この2つの処理で、アナログ入力が可能になる。


12:24 | direct link 
Arduino
Flashからサーボを動かす
前回の数値を送る仕組みを利用して、Flashからサーボをコントロールしてみる。 

 

ソースダウンロード 

今回使ったサーボは、RB90。
小型で、値段が手ごろ 

サーボーは、PWMというパルスで、コントロールする。
20msの間に、0.5～2msのハイの間隔で、サーボの角度を指定する。

arduinoでPWMが使えるポートは、PWMと基盤に書いてある。
少し古いものだと、9～11の3ポートだけだったか、最近のものは、3,5,6も使えるようになっている。 

arduinoソース 
int sum;
const int KETAMAX = 4;        // 桁数
int keta;

int servoPin = 9;
int pulse = 1000;

void setup()
{
  pinMode(servoPin, OUTPUT);
  Serial.begin(9600);
  iniKeta();
}

void loop () {
  // データが来た
  if(Serial.available()>0){
    int val = Serial.read();
    if(val == 's'){          // データのはじめ
      iniKeta();
    }else{                  // 数値データ
      val -= 48;            // アスキー→数値に変換
      for(int i=1; i < keta; i++){  // 桁数を計算
        val *= 10;
      }
      sum += val;
      keta --;
      if(keta == 0){        // すべてのデータ受信終了
        pulse = constrain(sum, 500, 2450);  // オーバーフローする値を切り捨て
      }
    }
  }
  moveServo();
}

// サーボを動かす
void moveServo()
{
  digitalWrite(servoPin, HIGH);
  delayMicroseconds(pulse);
  digitalWrite(servoPin, LOW);
  delay(18);
}

// 最初の桁に戻る
void iniKeta(){
  keta = KETAMAX;
  sum = 0;
}
基本的には、前回と同じ。
違うところは、moveServo()で
ハイにあげて、pulseの時間を待った後、
ローに入れるという単純な仕組みで、PWMを生成している。 

void moveServo()
{
  digitalWrite(servoPin, HIGH);
  delayMicroseconds(pulse);
  digitalWrite(servoPin, LOW);
  delay(18);
}
Flashのソース
フレームレート10で動作確認、早くしすぎるとサーボが遅くなる。 

import Arduino;

var pwm;                        // パルス値
var changFlg = false;        // 値が変わったか

// 環境に合わせて、ポートを設定する。
// COM1:5331、COM2:5332、COM3:5333、COM4:5334、COM5:5335、COM6:5336
var port:Number = 5334;

var arduino:Arduino = new Arduino(port);

// arduinoに送信
function sendData(data){
    arduino.send(data);
}

// スライダー設定
slider.setValue(0);
slider.setChangeHandler("onChangeScroll", this);

// スクロールバーの値が変わった
function  onChangeScroll(){
    var val = Math.round(slider.getValue());
    val *= 3;
    val += 500;
    var msg = "s";
    if(val < 10){
        msg += "000" + val;
    }else if(val < 100){
        msg += "00" + val;
    }else if(val < 1000){
        msg += "0" + val;
    }else{
        msg +=  val;
    }
    changFlg = true;
    txt.text = val;
    _root.pwm = msg;
}

// データが変わったときに送ると、送りすぎになるので、
// フレームレートごとに値が変化したときだけ送信
onEnterFrame = function(){
    if(pwm != undefined && changFlg){
        sendData(pwm);
        changFlg = false;
    }
}
05:01 | direct link 
Arduino
arduinoに数値を送る
Flash8のaction script2では、バイナリが使えず、文字しか送れないので、
数字を送れるか試してみた。 

以下arduinoのソース 
int sum;
const int KETAMAX = 4;        // 桁数
int keta;

void setup() {
  Serial.begin(9600);
  iniKeta();
}

void loop () {
  // データが来た
  if(Serial.available()>0){
    int val = Serial.read();
    if(val == 's'){          // データのはじめ
      iniKeta();
    }else{                  // 数値データ
      val -= 48;            // アスキー→数値に変換
      for(int i=1; i < keta; i++){  // 桁数を計算
        val *= 10;
      }
      sum += val;
      keta --;
      if(keta == 0){        // すべてのデータ受信終了
        Serial.println(sum);
      }
    }
  }
}

// 最初の桁に戻る
void iniKeta(){
  keta = KETAMAX;
  sum = 0;
}
動作はシリアルで確認、
sの文字の後、4桁の数字を返すのを確認
 

01:54 | direct link 
2007年06月06日Arduino
角速度ジャイロを使う
角速度ジャイロHS-EG3を使ってみる。




推奨回路どうり作れば動く。
赤丸の抵抗値の書いていない部分で、角速度のレンジを調整する。


23:27 | direct link 
Arduino
Flashに3軸加速度センサーをつなぐ
今回は、3軸加速度センサーＫＸＭ５２−１０５０を使います。
 

ソースのダウンロード 

今までのセンサーと違い、Flashに送る値が3つに増えるので、
最初のデータを送信する前にstartの文字を送ることにした。 

void setup() {
  Serial.begin(9600);
}

void loop() {
  sendStringToFlash("start");
  for(int i=0; i<3; i++){
    int val = analogRead(i);
    sendNumToFlash(val);
  }
  delay(100);
}

// Flashに対して、数値を送信する
void sendNumToFlash (int n) {
  Serial.print(n);
  printByte(0);
}

// Flashに対して、文字列を送信する
void sendStringToFlash (char *s) {
  while (*s) {
    printByte(*s++);
  }
  printByte(0);
}
Flashでも、グラフをつくってみることにした。
 

import flash.display.BitmapData;
import flash.geom.Rectangle;
//------------------
import Arduino;

//------------------ グラフパラメータ
var dataCount = 0;                // x,y,zどのデータか
var back_data = new Array();    // 前のデータ
for(var i=0; i<3; i++) back_data[i] = 0;
var coMap = new Array();        // 線の色
coMap[0] = 0xFF0000;
coMap[1] = 0x00FF00;
coMap[2] = 0x0000FF;

//------------------ Arduino
// 環境に合わせて、ポートを設定する。
// COM1:5331、COM2:5332、COM3:5333、COM4:5334、COM5:5335、COM6:5336
var port:Number = 5334;
var arduino:Arduino = new Arduino(port);
listenObj = new Object();

// データを受信
listenObj.onReceiveData = function(evtObj:Object){
    var msg = evtObj.data;
    if(msg == "start"){                // データの始まり
        dataCount = 0;
    }else{                                    // 数値のデータ
        var val = Number(msg)/2;    // 値が大きいので、2で割る
        // グラフ作成
        drawGraf(dataCount, val);
        dataCount ++;
    }
}

// リスナー登録
arduino.addEventListener("onReceiveData", listenObj);

// -----------------------グラフ

var myBitmapData:BitmapData = new BitmapData(750, 512, false, 0xFFFFFF);
var mc_2:MovieClip = this.createEmptyMovieClip("mc2", this.getNextHighestDepth());
mc_2._x = -1;                                // 見えない位置で作画させるため、x座標を-1に

mc_1.attachBitmap(myBitmapData, this.getNextHighestDepth());

function drawGraf(no, n){
    drawLine(Math.floor(512 - back_data[no]), Math.floor(512 - n), coMap[no]);
    back_data[no] = n;                // データバックアップ
    
    if(no >= 2){                            // グラフをビットマップに作画
        myBitmapData.draw(mc_2);
        mc_2.clear();
        myBitmapData.scroll(1, 0);
        myBitmapData.fillRect(new Rectangle(0, 0, 1, 512), 0xffffff);
    }
}

// 線を引く
function drawLine(y0, y1, color){
    mc_2.lineStyle(1, color);
    mc_2.moveTo(0, y0);
    mc_2.lineTo(1, y1);
}
16:45 | direct link 
Arduino
曲げセンサー
曲げると抵抗値が変わる、曲げセンサーを使ってみる。

端子は2本しかなく、曲げることによって抵抗値が、10kΩ～30kΩに変わる。
そのまま、Analog inにつないでも、電圧の変化がおきないので、数値は変わらない。
そこで、別の抵抗と直列につないで、抵抗値の変化を、
電圧の変化に反映させることで、Analog inで読み取る値を変える。


今回もソースは、前回と同じ。

光センサーのCDSもこれと同じ回路で計測ができる。


14:21 | direct link 
Arduino
Flashで距離センサーを扱う
前回は、センサーといっても抵抗だったので、
今回は距離センサーを使います。

赤外線距離センサモジュールGP2D12


回路のつなぎ方は、
センサー向かって、

右が5V
真ん中がGnd
左が、Analog in 2

につなぐだけです。


ソースは、前回と同じ。

同じように、3本足で簡単に使えるセンサーとしては、
MPモーションセンサなどがある。

03:26 | direct link 
2007年06月05日Arduino
Flashとセンサーをつなぐ（windows）
センサーといっても、扱いやすい可変抵抗でやってみる。
 

ソースのダウンロード 

必要なの物
・arduino
・ブレッドボード
・ブレットボード用ジャンプワイヤー（自作でもよい）
・可変抵抗（適当なものでよい） 

回路は、5VとGndを可変抵抗の端につないで、
入力用のAnalog in2ポートを、可変抵抗の真ん中の端子に接続するだけでよい。 

arduinoソース 

int potPin = 2;

void setup() {
  Serial.begin(9600);
}

void loop() {
  int val = analogRead(potPin);
  sendNumToFlash(val);
  delay(50);
}

// Flashに対して、数値を送信する
void sendNumToFlash (int n) {
  Serial.print(n);
  printByte(0);
}
アナログをデジタルに変換するのに、
analogRead()関数をつかう
その後、sendNumToFlash()でFlashに数値を送る。
sendNumToFlash()では、xmlSocket送信なので、数値の後に 

printByte(0);
をつける必要がある。 

Flash上では、onReceiveDataで数値を受け取ればよいだけ。
以下Flashのソース 

import Arduino;

// 環境に合わせて、ポートを設定する。
// COM1:5331、COM2:5332、COM3:5333、COM4:5334、COM5:5335、COM6:5336
var port:Number = 5334;

var arduino:Arduino = new Arduino(port);

listenObj = new Object();

// データを受信
listenObj.onReceiveData = function(evtObj:Object){
    var msg = evtObj.data
    trace(msg)
}

// リスナー登録
arduino.addEventListener("onReceiveData", listenObj);
可変抵抗を回せば、Flashで値の変化が読み取れる。


16:42 | direct link 
2007年06月04日Arduino
Flashで電子工作（windows）
Flashは、シリアル通信がサポートされていないので、
通常は外部の基盤と接続できません。
そこで、FlashはxmlSocketでserproxy.exeに対してメッセージを送り、
serproxy.exeはシリアル通信でarduino基盤に接続させます。 

Flashでボタンを押すとLEDが点灯して、
スイッチを押すとFlashで表示が変わるものを作ります。

ソースのダウンロード 

用意するものと、回路はここと同じ。 

接続手順
1.arduino基盤に、flas_and_arduinoフォルダのソースを書き込む
2.serproxyフォルダのserproxy.exeを起動
3.Flashのソースでは、環境に合わせて、ポート番号を変える必要がある。
flashフォルダのarduino.flaを開き、5行目を変更する。
テストした環境では、COM4に接続するので、上の例では、5334にしてある。 

var port:Number = 5334;
4.Flashを起動する。
5.Flash上の「LEDボタン」を押せば、LEDが点灯、
基盤のスイッチを押せば、Flashの表示が変わる。 

ソース解説
■arduinoソース 
int lastSwitchState = 0;    // スイッチの状態
int inPutPin = 2;           // スイッチ用のピン
int ledPin = 13;            // ledに使うピン

void setup() {
  Serial.begin(9600);
  pinMode(inPutPin, INPUT);
  pinMode(ledPin, OUTPUT);
}

void loop () {
  // スイッチ
  int switchState = digitalRead(inPutPin);
  // スイッチの状態が変わった
  if (switchState != lastSwitchState) {
    if (switchState == HIGH){
      sendStringToFlash("on");
    }
    else {
      sendStringToFlash("off");
    }
    // スイッチの現在の状態をバックアップ
    lastSwitchState = switchState;
  }
  
  // LED
  // シリアルのからデータがきているか
   if(Serial.available() > 0) {
    int flashCommand = Serial.read();
    flashCommand -= 48;    // アスキーデータを数値に変換
    if(flashCommand == 0){
      digitalWrite(ledPin, LOW); 
    }else if(flashCommand == 1){
      digitalWrite(ledPin, HIGH); 
    }
  }
  
  delay(50);
}

// Flashに対して、文字列を送信する
void sendStringToFlash (char *s) {
  while (*s) {
    printByte(*s++);
  }
  printByte(0);
}
Flashにデータを送るには、最後に定義してあるsendStringToFlash関数を使う。
文字を引数にすると、xmlSocketデータを送信する。
ボタンが押されると、"on"を送信するようにした。 

Flashから、データが来たか知るには、Serial.available()で判定する。
アスキーコードで送ってくるので、-48を引いて数字に変換する。 

flashCommand -= 48;
送られてきたデータが、0のときはLEDを消す。 

if(flashCommand == 0){
    digitalWrite(ledPin, LOW); 
}
■Flashのソース 
import Arduino;

// 環境に合わせて、ポートを設定する。
// COM1:5331、COM2:5332、COM3:5333、COM4:5334、COM5:5335、COM6:5336
var port:Number = 5334;

var arduino:Arduino = new Arduino(port);

listenObj = new Object();

// データを受信
listenObj.onReceiveData = function(evtObj:Object){
    var msg = evtObj.data
    if (msg == "on") {
        _root.showMc.onFunc();
    }
    else if (msg == "off") {
        _root.showMc.offFunc();
    }
}

// リスナー登録
arduino.addEventListener("onReceiveData", listenObj);

// arduinoに送信
function sendData(data){
    arduino.send(data);
}
Flashをパブリッシュしたときには、接続ができるのだが、swfファイルからだと、serproxyに接続ができなかった。とりあえず、スタンドアローンexeで接続が確認できた。 

18:55 | direct link 
Arduino
スイッチで入力をする
スイッチを押すと、LEDが点灯するものを作る。

必要なの物
・arduino
・ブレッドボード
・LED
・ブレットボード用ジャンプワイヤー（自作でもよい）
・スイッチ（今回はタクトスイッチにした）
・抵抗（数百Ωから数kΩ程度。今回は、220Ω） 

写真のように回路を作る。
 

回路について
LEDは、前回と同じようにポートの13にさす。
スイッチを押すと、ポート2がHIGHになるように設定。
ポート２とスイッチと5Vをつなげば、いいように思うが、
スイッチを押していないときは、HIGHかLOWどちの状態になるかわからなくなる。
そこで、Gndにつないだ抵抗を、スイッチとつなげることで、
プルダウンさせて、押していないときは、LOWになるようにする。 

以下は、arduinoのソース 
int ledPin = 13;                      // ledピン
int inPutPin = 2;                     // スイッチ

void setup() {
  pinMode(ledPin, OUTPUT);            // 出力に設定
  pinMode(inPutPin, INPUT);           // 入力に設定
}

void loop(){
  int val = digitalRead(inPutPin);    // ボタンの状態
  
  if (val == HIGH) {                  // ボタンを押したとき
    digitalWrite(ledPin, HIGH);       // LEDが点灯する
  } else {
    digitalWrite(ledPin, LOW);
  }
}
arduinoのソースについて 

はじめに、変数の定義を行います。
ここでは、ピンの設定をしています。 

int ledPin = 13;                      // ledピン
int inPutPin = 2;                     // スイッチ
setup()の中では、基盤の初期設定をします。
ここでは、ポートの出力の設定をしています。 

void setup() {
  pinMode(ledPin, OUTPUT);            // 出力に設定
  pinMode(inPutPin, INPUT);           // 入力に設定
}
loop()の中では、基盤の動作処理を書きます。
digitalRead(ポート番号)で、ボタンの状態を読み込んだ後、
if文でボタンの状態をdigitalWriteコマンドで、LEDに反映させています。 

void loop(){
  int val = digitalRead(inPutPin);    // ボタンの状態
  
  if (val == HIGH) {                  // ボタンを押したとき
    digitalWrite(ledPin, HIGH);       // LEDが点灯する
  } else {
    digitalWrite(ledPin, LOW);
  }
}
16:33 | direct link 
2007年06月01日Processing
ProcessingとFlash
ProcessingとFlashで同じ機能を実装して、
それぞれ比較しました。 

1|矩形を動かす
■Flash 

// 初期化
mc._x = 0;

// 繰り返し処理
onEnterFrame = function(){
    mc._x ++;
}
■Processing 
// 初期化
int X = 0;
void setup(){
  size(200, 200);
  background(255); 
  frameRate(25);
}

// 繰り返し処理
void draw(){
  background(255); 
  fill(0);
  rect(X++, height/2, 10, 10);
}
2|ボタンを作る
■Flash 

// マウスが押された
mc.onPress = function(){
    trace("press");
}

// マウスが押された
mc.onRollOver = function(){
    trace("over");
}
