/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aEsu
 */

// forked from dfrm's Math and Physics Pt1
// forked from dfrm's Math & Physics Sample



package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.text.TextField;
    import flash.geom.Point;
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="90")] 


    public class FlashTest extends Sprite 
    {
        private const WIDTH:Number = stage.stageWidth/2;
        private var ball:Sprite;
        private var ballstatic:Sprite;       
        private var _obj:Array = [];
        private var _color:Array = [ 0xFF0000,0x00FF00,0x0000FF ];
        private var rollovered:Boolean;
        private var clicked:Boolean;
        private var sc:Number;
        private var point:Point = new Point();
        
        public function FlashTest() 
        {
            var stats:Stats = new Stats();
            drawBallStatic(_color[Math.round(Math.random()*2)],20,WIDTH,10);
            
            for(var i:uint=0; i<10; i++)
            {
                drawBall(_color[Math.round(Math.random()*2)],0,0,10+i*3);                
                // tracer("obj:"+_obj[i],0,15*i);
            }
            
            stage.addEventListener(Event.ENTER_FRAME, _onEnterFrame);
            stage.addChild( stats );
        }
        
        private function _onRollOut(e:MouseEvent):void {
            rollovered = false;
        }
        
        private function _onRollOver(e:MouseEvent):void {
            rollovered = true;
        }
        
        private function _onEnterFrame(e:Event):void {
            for(var i:uint=0; i<_obj.length; i++){
            
            if(rollovered) {
                if(i==0) {
                    point.x = ballstatic.x+30;
                    point.y = WIDTH/2;
                } else {
                    point.x = _obj[i-1].x + (30+i*3);
                    point.y = _obj[i-1].y;
                }
            } else {
                if(i==0){
                    point.x = mouseX;
                    point.y = mouseY;
                } else {
                    point.x = _obj[i-1].x;
                    point.y = _obj[i-1].y;
                }
            }
                
            _obj[i].x += (point.x - _obj[i].x)/8;
            _obj[i].y += (point.y - _obj[i].y)/8;
            }
        }
        
        private function drawBall(cols:uint,x:Number,y:Number,r:Number):void {
            ball = new Sprite();
            ball.graphics.beginFill(cols,1);
            ball.graphics.drawCircle(x,y,r);
            ball.graphics.endFill();
            ball.blendMode = BlendMode.ADD;
            ball.mouseEnabled = false;
            addChild(ball);
            
            _obj.push(ball);
        }
        
        private function drawBallStatic(cols:uint,x:Number,y:Number,r:Number):void {
            ballstatic = new Sprite();
            ballstatic.graphics.beginFill(cols,1);
            ballstatic.graphics.drawCircle(x,y,r);
            ballstatic.graphics.endFill();
            ballstatic.buttonMode = true;
            addChild(ballstatic);
            
            tracer("<= MouseOver",40,y-10);
            
            ballstatic.addEventListener(MouseEvent.ROLL_OUT, _onRollOut);
            ballstatic.addEventListener(MouseEvent.ROLL_OVER, _onRollOver);
        }
        
        private function tracer(_text:String,_x:Number,_y:Number):void{
            var tf:TextField = new TextField();
            tf.text = _text;
            tf.autoSize = "left";
            tf.mouseEnabled = false;
            tf.x = _x;
            tf.y = _y;
            addChild(tf);
        }
    }
}