/**
 * Copyright soundkitchen ( http://wonderfl.net/user/soundkitchen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aERv
 */

// 1日1Wonderfl 8/30日目
/**
 *  Reflection やってみたよ
 *
 *  覚えておく事:
 *      - reflect となる DisplayObject の cacheAsBitmap は true に
 *      - reflect の mask となる DisplayObject も cacheAsBitmap は true に
 *          - 上の２つが見たされてないとフェードしない
 */
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.GradientType;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Matrix;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xffffff)]

    public class Main extends Sprite
    {
        private var container:Sprite;

        /**
         *  コンストラクタ
         */
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, initialize);
        }

        /**
         *  メインロジック!!
         */
        private function initialize(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);

            var W:Number, H:Number,
                g:Graphics,
                mtx:Matrix,
                bmd:BitmapData,
                original:Bitmap,
                reflect:Bitmap,
                maskShape:Shape;

            //  stage の幅と高さを int にして保持
            W = stage.stageWidth >> 0;
            H = stage.stageHeight >> 0;

            container = new Sprite();
            bmd = createCloud(120, 160);

            //  オリジナルデータとして Bitmap を作る
            original = container.addChild(new Bitmap(bmd)) as Bitmap;

            //  反射用データとして Bitmap を作る
            reflect = container.addChild(new Bitmap(bmd)) as Bitmap;
            //  逆さむきにする
            reflect.scaleY = original.scaleY * -1;
            //  x と y を調節
            //  y はひっくり返ってる事も考慮する
            reflect.x = original.x;
            reflect.y = original.height + reflect.height;
            //  ココ重要
            //  これしないとフェードしない
            reflect.cacheAsBitmap = true;

            //  マスク用の Shape を作成
            maskShape = container.addChild(new Shape()) as Shape;
            //  x と y を調節
            //  マスク用のデータなので reflect なデータとカブるようにする
            maskShape.x = reflect.x;
            maskShape.y = original.height;
            //  ココ重要
            //  これしないとフェードしない
            maskShape.cacheAsBitmap = true;
            //  マスクとして設定
            reflect.mask = maskShape;

            //  Graphics を変数に特攻む
            g = maskShape.graphics;
            //  Gradient 用の Matrix 作る
            mtx = new Matrix();
            //  幅と高さを reflect と合わせて縦方向に設定
            //  Math.PI / 2 は 90 度だよ
            mtx.createGradientBox(reflect.width, reflect.height, Math.PI / 2);
            //  グラデーションな塗り
            g.beginGradientFill(
                GradientType.LINEAR,
                [0x00, 0x00],
                [.75, 0],
                [0, 255>>1],
                mtx
            );
            //  幅と高さを reflect に合わせて四角を書く
            g.drawRect(0, 0, reflect.width, reflect.height);
            //  おえかきおしまい
            g.endFill();

            //  コンテナの位置をセンターに設定
            container.x = (W - original.width) >> 1;
            container.y = (H - original.height) >> 1;
            //  ドキュメントクラスに特攻む
            addChild(container);
        }

        /**
         *  指定された幅・高さに合わせて、ぺろりんのいずな BitmapData 作る
         */
        private function createCloud(width:Number, height:Number):BitmapData
        {
            var bmd:BitmapData;

            bmd = new BitmapData(width, height);
            bmd.perlinNoise(
                width >> 3,                 //  baseX
                height >> 3,                //  baseY
                8,                          //  numOctaves
                (Math.random() * 100) >> 0, //  randomSeed
                true,                       //  stitch
                true,                       //  fractalNoise
                BitmapDataChannel.RED,      //  channelOptions
                false                       //  grayScale
            );
            return bmd;
        }
    }
}

