/**
 * Copyright Fumio ( http://wonderfl.net/user/Fumio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aDhA
 */

package {
	import flash.display.Sprite;
	import flash.utils.getTimer;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flashx.textLayout.formats.TextAlign;
	[SWF(width = "240",height = "180")]
	public class IteratingElements extends Sprite {
		private const AMOUNT:uint = 10000000;
		private var started:uint;
		private var my_txt:TextField = new TextField();
		private var label_txt:TextField = new TextField();
		private var my_fmt:TextFormat = new TextFormat();
		private var test_array:Array = [];
		private var testVector:Vector.<uint >  = new Vector.<uint > (AMOUNT);
		public function IteratingElements() {
			// Creating a TextField for display
			createTextField();
			// iterating the Array and Vector to get stable result
			test();
			// Starting test
			useMemberArray();
			useLocalArray();
			useMemberVector();
			useLocalVector();
		}
		private function test():void {
			for (var i:uint = 0; i < AMOUNT; i++) {
				test_array[i] = i;
				testVector[i] = i;
			}
			test_array.length = 0;
			testVector.length = 0;
		}
		private function useMemberArray():void {
			test_array.length = 0;
			started = getTimer();
			for (var i:uint = 0; i < AMOUNT; i++) {
				test_array[i] = i;
			}
			for (var j:uint = 0; j < AMOUNT; j++) {
				var temp:uint = test_array[j];
			}
			xTrace(getTimer() - started);
		}
		private function useLocalArray():void {
			test_array.length = 0;
			started = getTimer();
			var _array:Array = test_array;
			var nAmount:uint = AMOUNT;
			for (var i:uint = 0; i < nAmount; i++) {
				_array[i] = i;
			}
			for (var j:uint = 0; j < nAmount; j++) {
				var temp:uint = _array[j];
			}
			xTrace(getTimer() - started);
		}
		private function useMemberVector():void {
			testVector.length = 0;
			started = getTimer();
			for (var i:uint = 0; i < AMOUNT; i++) {
				testVector[i] = i;
			}
			for (var j:uint = 0; j < AMOUNT; j++) {
				var temp:uint = testVector[j];
			}
			xTrace(getTimer() - started);
		}
		private function useLocalVector():void {
			testVector.length = 0;
			started = getTimer();
			var myVector:Vector.<uint >  = testVector;
			var nAmount:uint = AMOUNT;
			for (var i:uint = 0; i < nAmount; i++) {
				myVector[i] = i;
			}
			for (var j:uint = 0; j < nAmount; j++) {
				var temp:uint = myVector[j];
			}
			xTrace(getTimer() - started);
		}
		private function createTextField():void {
			addChild(my_txt);
			addChild(label_txt);
			my_txt.x +=  70;
			my_txt.autoSize = TextFieldAutoSize.RIGHT;
			my_fmt.align = TextAlign.RIGHT;
			my_txt.defaultTextFormat = my_fmt;
			label_txt.autoSize = TextFieldAutoSize.LEFT;
			label_txt.text = "Array in a member property:\nArray in a local variable:\nVector in a member property:\nVector in a local variable:";
		}
		private function xTrace(n:int):void {
			my_txt.appendText(String(n) + "\n");
		}
	}
}