/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aDZr
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.ByteArray;

    [SWF(width = '465', height = '465')]
    public class Sm0ke2 extends Sprite {
        private const MASKS : String = '$MOKE†††';
        private const P_NUM : int = 111111;
        /* */
        private var ppp : Particle = new Particle();
        private var bmd : BitmapData;
        private var buf : Vector.<uint>;
        private var fmap : BitmapData;
        private var mmap : BitmapData;
        private var mba : ByteArray;
        private var fba : ByteArray;
        private var tf : TextField;
        private var dstp : Point;
        private var mtx : Matrix;
        private var seed : int;
        private var mskCnt : uint;
        private var fcnt : int;
        private var boost : Number;

        function Sm0ke2()//
        {
            stage.stageFocusRect = tabChildren = tabEnabled = mouseChildren = mouseEnabled = false;
            stage.scaleMode = 'noScale';
            stage.align = 'TL';
            stage.quality = 'low';
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            var bm : Bitmap = new Bitmap(bmd = new BitmapData(512, 512, false));
            bm.x = bm.y = (465 - 512) / 2;
            bm.opaqueBackground = 0x0;
            addChild(bm);

            buf = new Vector.<uint>(bmd.width * bmd.height, true);

            fmap = new BitmapData(256, 256, false);
            mmap = new BitmapData(256, 256, false);

            var p : Particle = ppp = new Particle();
            var n : uint = P_NUM;

            while (n-- != 0)//
            {
                p.x = Math.random() * 512;
                p.y = Math.random() * 512;
                p.vx = 0.0;
                p.vy = 0.0;

                p = p.next = new Particle();
            }

            tf = new TextField();
            tf.defaultTextFormat = new TextFormat('_sans', 200, 0xFFFFFF, true);
            tf.autoSize = TextFieldAutoSize.LEFT;

            mtx = new Matrix();
            dstp = new Point();

            seed = (int.MAX_VALUE * Math.random()) >> 0;
            boost = 0.0;

            stage.addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void//
        {
            fcnt++;

            if ((fcnt & 255) == 1)//
            {
                boost = 0.75;

                seed = (((seed & 1) - 1) & 0xF00FC7C8) ^ (seed >> 1);
                fmap.perlinNoise(32, 32, 8, seed, false, true, 3, false);

                fba = fmap.getPixels(fmap.rect);

                tf.text = MASKS.charAt(mskCnt & 7);
                mtx.tx = (256 - tf.width) / 2;
                mtx.ty = ((256 - tf.height) / 2) + ((tf.text != '†') ? 0 : -16);

                mmap.fillRect(mmap.rect, 0x0);
                mmap.draw(tf, mtx);

                mba = mmap.getPixels(mmap.rect);

                mskCnt++;
            }

            var i : uint = buf.length - (fcnt & 1);

            while (i > 1)//
            {
                i--;
                i--;

                buf[i] = 0x474648;
            }

            if (boost > 0.1) boost *= 0.99;

            var pcnt : int = 0;
            var p : Particle = ppp;

            while (p != null)//
            {
                pcnt++;

                i = (((p.y >> 1) << 8) + (p.x >> 1)) << 2;

                if (pcnt & 1)//
                {
                    p.vx += (fba[i + 1] - 128) * (0.0033 * (boost + 1));
                    p.vy += (fba[i + 2] - 128) * (0.0033 * (boost + 1));

                    if (mba[i + 1] > 128)//
                    {
                        p.vx *= 0.22 * (boost + 1);
                        p.vy *= 0.22 * (boost + 1);
                    }

                    p.x += p.vx;
                    p.y += p.vy;

                    if (p.x < 0) p.x = 511;
                    else if (p.x > 511) p.x = 1;

                    if (p.y < 0) p.y = 511;
                    else if (p.y > 511) p.y = 1;

                    i = (p.x & 511) + ((p.y & 511) << 9);

                    var c : uint = buf[i];

                    c -= 0x1F1E1D;
                    if (c > 0xEEEEEE) c = 0x111111;
                }// 
                else//
                {
                    p.vx += (fba[i + 1] - 128) * (0.00051 * (boost + 1));
                    p.vy += (fba[i + 2] - 128) * (0.00051 * (boost + 1));

                    if (mba[i + 1] < 128)//
                    {
                        p.vx *= 0.66 * (boost + 1);
                        p.vy *= 0.66 * (boost + 1);
                    }

                    p.x -= p.vx;
                    p.y -= p.vy;

                    if (p.x < 0) p.x = 511;
                    else if (p.x > 511) p.x = 1;

                    if (p.y < 0) p.y = 511;
                    else if (p.y > 511) p.y = 1;

                    i = (p.x & 511) + ((p.y & 511) << 9);

                    c = buf[i];

                    c += 0x1F1D1B;
                    if (c > 0xCCCCCC) c = 0xCCCCCC;
                }

                buf[i] = c;

                // - - - >

                p = p.next;
            }

            bmd.setVector(bmd.rect, buf);
        }
    }
}

class Particle {
    public var next : Particle;
    public var x : Number;
    public var y : Number;
    public var vx : Number;
    public var vy : Number;
}