/**
 * Copyright dacyou ( http://wonderfl.net/user/dacyou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aDTu
 */

//型などを極力省いた方が簡潔ですきなのですが、Warningが大量にでてしまいます。。。

package {
import flash.display.Sprite

[SWF(width=465, height=465, frameRate=30, backgroundColor=0x000000)]
public class BallTest extends Sprite {
	function BallTest() {
		Area.setParent( this )
		
		new Velocity( new Area(0,0,230,230) )
		new Gravity( 2, new Area(235,0,230,230) )
		new Easing( 0.1, new Area(0,235,230,230) )
		new Spring( 0.2, 0.8, new Area(235,235,230,230) )
	}
}

}//end package

import flash.display.Sprite
import flash.events.Event
import flash.text.TextField

/////////////////////////////////////////////////////////////////////
class Ball extends Sprite {
	var _radius
	var _vx, _vy
	var _area
	var _areaWidth, _areaHeight
	
	//=====================================================
	function _move( e ) {
		_checkCollision()
	}
	
	//=====================================================
	function _checkCollision() {
		_checkWall( 0, 0, _areaWidth, _areaHeight )
	}
	
	//-----------------------------------------------------
	function _checkWall( left, top, right, bottom ) {
		if ( x - _radius < left ) {
			x = left + _radius
			_vx = -_vx
		}
		else if ( right < x + _radius ) {
			x = right - _radius
			_vx = -_vx
		}
		
		if ( y - _radius < top ) {
			y = top + _radius
			_vy = -_vy
		}
		else if ( bottom < y + _radius ) {
			y = bottom - _radius
			_vy = -_vy
		}
	}
	
	//=====================================================
	function _draw( color ) {
		graphics.beginFill( color )
		graphics.drawCircle( 0, 0, _radius )
	}
	
	//=====================================================
	function Ball( area :Area, radius = 10, color = 0xffffff ) {
		_radius = radius
		_vx = _vy = 0
		
		_area = area
		_areaWidth = area.width
		_areaHeight = area.height
		area.addChild( this )
		area.title( this )
		
		_draw( color )
		addEventListener( Event.ENTER_FRAME, _move )
	}	
}

/////////////////////////////////////////////////////////////////////
class Velocity extends Ball {
	
	//=====================================================
	override function _move( e ) {
		x += _vx
		y += _vy
		
		_checkCollision()
	}
	
	//=====================================================
	function Velocity( area ) {
		super( area )
		_vx = random( 10, -10 )
		_vy = random( 10, -10 )
	}
}

/////////////////////////////////////////////////////////////////////
class Gravity extends Velocity {
	var _gravity
	
	//=====================================================
	override function _move( e ) {
		_vy += _gravity
		x += _vx
		y += _vy
		
		_checkCollision()
	}
	
	//=====================================================
	function Gravity( gravity, area ) {
		super( area )
		_gravity = gravity
	}
}

/////////////////////////////////////////////////////////////////////
class Easing extends Ball {
	var _easing
	
	//=====================================================
	override function _move( e ) {
		_vx = (_area.mouseX - x)*_easing
		_vy = (_area.mouseY - y)*_easing
		x += _vx
		y += _vy
		
		_checkCollision()
	}
	
	//=====================================================
	function Easing( easing, area ) {
		super( area )
		_easing = easing
	}
}

/////////////////////////////////////////////////////////////////////
class Spring extends Ball {
	var _spring
	var _friction
	
	//=====================================================
	override function _move( e ) {
		_vx += (_area.mouseX - x)*_spring
		_vy += (_area.mouseY - y)*_spring
		_vx *= _friction
		_vy *= _friction
		x += _vx
		y += _vy
		
		_checkCollision()
	}
	
	//=====================================================
	function Spring( spring, friction, area ) {
		super( area )
		_spring = spring
		_friction = friction
	}
}

/////////////////////////////////////////////////////////////////////
class Area extends Sprite {
	static var _parent :Sprite
	
	//=====================================================
	public static function setParent( p ) {
		_parent = p
	}
	
	//=====================================================
	function title( s :Sprite ) {
		var field :TextField = new TextField
		field.text = className( s )
		field.textColor = 0xffffff
		field.selectable = false
		field.autoSize = "left"
		addChild( field )		
	}

	//=====================================================
	function Area( x, y, w, h, color = 0x333333 ) {
		graphics.beginFill( color )
		graphics.drawRect( 0, 0, w, h )
		this.x = x
		this.y = y
		
		_parent.addChild( this )
	}	
}

//=========================================================
function random( max, min = 0 ) {
	return min + (max-min)*Math.random()
}

//=========================================================
function className( obj ) {
	return obj.toString().match( /[A-Z]+[a-z0-9]+/ ).join()
}