/**
 * Copyright akkey.guitar ( http://wonderfl.net/user/akkey.guitar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aDTm
 */

// forked from akkey.guitar's flash on 2011-1-17
package 
{
    import flash.display.Shape;
    import flash.events.Event;
    import flash.filters.BlurFilter;

    public class Snowflake extends Shape 
    {
        private var stageWidth:int = 0;
        private var stageHeight:int = 0;
        private var highestDropSpeed:uint = 16;
        private var dropSpeed:int = Math.round(Math.random() * Math.random() * highestDropSpeed);
        private var incrementer:int = Math.round(Math.random() * 100);
        private var shades:Array = [ 0xFFFFFF, 0xCCCCCC, 0x999999, 0x666666 ];
        private var windSpeed:int = 2;
        private var snowObj:Shape = new Shape();
        
        public function Snowflake(w:uint, h:uint) 
        {
            stageWidth = w;
            stageHeight = h;
            init()
        }
        public function init():void
        {
            graphics.beginFill(shades[ Math.ceil(Math.random() * shades.length) ]);
            graphics.drawCircle(0, 0, 4);
            graphics.endFill();
            filters = [ new BlurFilter(1, dropSpeed, 1) ];
            addEventListener(Event.ENTER_FRAME, update); 
            reset();
        }
        private function reset():void 
        {
            y = Math.random() * stageHeight * -1;
            x = Math.random() * stageWidth - (windSpeed * 100);
            scaleX = scaleY = 0.25 + (Math.random() * Math.random() * 0.75);
        }
        private function update(e:Event):void 
        {
            y += dropSpeed;
            x += windSpeed + Math.sin(incrementer / 10) * (1 / (dropSpeed / 3));
            if (y > stageHeight) 
            {
                reset();
            }
            incrementer++;
        }
   }
}

