/**
 * Copyright y_tti ( http://wonderfl.net/user/y_tti )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aD7J
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.filters.GradientBevelFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;

    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0x0")]
    public class GraphicTest1 extends Sprite
    {
        private var _bmds:Array;
        private var _canvas:BitmapData;
        private var _colorTran:ColorTransform = new ColorTransform(1,1,1,0.999);
        private var _num:int = 10;
        private var _sizes:Array = [3,2,1];
        private var _colors:Array = [0xf90336,0x07f2c7,0x002397,0x2bc6da];
        private var _previousPt:Point;
        public function GraphicTest1()
        {
            addEventListener(Event.ADDED_TO_STAGE , _init);
        }

        private function _init(event:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE , _init);
            
            _canvas = new BitmapData(465,465,false,0x0);
            addChild(new Bitmap(_canvas));
            
            _bmds = [];
            for (var i:int = 0; i < _colors.length; i++) {
                _addCircle(_colors[i]);
            }
            
            
            _previousPt = new Point(mouseX,mouseY);
            addEventListener(Event.ENTER_FRAME , _update );
        }
        
        private function _update(e:Event):void {
            var dx:Number = mouseX - _previousPt.x;
            var dy:Number = mouseY - _previousPt.y;
            var distance:Number = Math.sqrt( dx*dx + dy+dy );
            var ramdistance:Number = (50-distance)/50 * 50;
            
            for (var i:int = 0; i < _num; i++) {
                var bmd:BitmapData = _bmds[Math.floor(_bmds.length*Math.random())];
                var mat:Matrix = new Matrix();
                var ramX:Number = Math.random()*ramdistance-ramdistance/2;
                var ramY:Number = Math.random()*ramdistance-ramdistance/2;
                mat.tx = mouseX - (bmd.width>>1) + ramX;
                mat.ty = mouseY - (bmd.height>>1) + ramY;
                _canvas.draw(bmd,mat,null,BlendMode.DIFFERENCE);
            }
            _canvas.colorTransform(new Rectangle(0,0,_canvas.width,_canvas.height) , _colorTran );
            _previousPt = new Point(mouseX,mouseY);
        }
        
        
        private function _addCircle($color:uint):void {
            for (var i:int = 0; i < _sizes.length; i++) {
                var s:Shape = _createCircle($color,_sizes[i]);
                var bmd:BitmapData = new BitmapData( s.width+2 , s.height+2 , true , 0x00FFFFFF );
                var mat:Matrix = new Matrix();
                mat.tx = (s.width>>1) +1;
                mat.ty = (s.height>>1) +1;
                bmd.draw(s,mat);
                _bmds.push(bmd);
            }
            
        }
        
        private function _createCircle($color:uint,$size:Number):Shape {
            var s:Shape = new Shape();
            s.graphics.lineStyle(2,$color,1);
            s.graphics.drawCircle(0,0,$size);
            return s;
        }
    }
}