/**
 * Copyright ShutheSL ( http://wonderfl.net/user/ShutheSL )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aCvu
 */

// forked from pakyao's forked from: forked from: forked from: 3D tag cloud
// forked from CarlitosWay's forked from: forked from: 3D tag cloud
// forked from soulside's forked from: 3D tag cloud
// forked from esabear's 3D tag cloud
package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter;
    import flash.filters.BitmapFilterQuality;
    import org.papervision3d.materials.special.BitmapParticleMaterial;
    import org.papervision3d.core.geom.Particles;
    import org.papervision3d.core.geom.renderables.Particle;
    import org.papervision3d.events.InteractiveScene3DEvent;

    import org.papervision3d.scenes.Scene3D;  
    import org.papervision3d.view.Viewport3D;  
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.objects.DisplayObject3D;  
    import org.papervision3d.render.BasicRenderEngine;    

    public class FlashTest extends Sprite {
        private var scale:Number = 5;
        private var radius:Number = 500;
        private var smoothing:Boolean = true;
        private var minAlpha:Number = 0.3;
        private var glow:GlowFilter;
        private var tags:Array;
        private var tag_num:uint;
        private var tagArray:Array;
        private var view:Viewport3D;
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine; 
        private var tagContainer:DisplayObject3D;

        public function FlashTest() {
            // write as3 code here..
            init ();
        }

        private function init ():void {
            glow = new GlowFilter (0x003366, 1, 8, 8, 2, BitmapFilterQuality.LOW, true, false);
            tags = ["Abogados","Ingenieros","Empresas A1","Pymes","Seg. Hombres/Mujeres","Jvn.19-30 anos","Hoteles","Paginas amarillas","Ejecutivos","Gerentes","NSE A1/A/B","universitarios", "Mineras", "Textiles", "Agricultura", "Institutos", "Marketing","Finanzas","Producciones","Administraci♀on","Telecomunicaciones","Discotecas","Club Regatas","Country Club","Ejc.gobierno","Provincias","Distritos","Escuelas","Top 10 000","Comercio"];
            tag_num = tags.length;
            tagArray = [];
            tagContainer = new DisplayObject3D ();
            tagContainer.x = -radius * 0.25;
            tagContainer.y =  radius * 0.25;

            view = new Viewport3D(0,0,true,true);
            scene = new Scene3D();
            camera = new Camera3D();
            camera.z = -2 * radius;
            camera.zoom = 20;
            renderer = new BasicRenderEngine();

            this.addChild (view);
            scene.addChild (camera);
            scene.addChild(tagContainer);

            buildTags ();

            addEventListener (Event.ENTER_FRAME, enterFrameHandler);
        }

        private function buildTags ():void {
            var i:uint;
            for (i = 0; i < tag_num; i++) {
            // 2D
            var txt:TextField = new TextField ();
            txt.text = tags[i];
            txt.filters = [new BlurFilter(1.1, 1.1)];
            var txtW:Number = txt.textWidth + 4;
            var txtH:Number = txt.textHeight + 4;
            var bitmap:BitmapData = new BitmapData (txtW, txtH, true, 0x01FFFFFF);
            bitmap.draw (txt);

            var phi:Number = Math.acos((2 * (i + 1) - 1) / tag_num - 1);
            var theta:Number = Math.sqrt(tag_num * Math.PI) * phi;

            // 3D
            var material:BitmapParticleMaterial = new BitmapParticleMaterial (bitmap);
            material.interactive = true;
            material.smooth = smoothing;

            var tag:Particle = new Particle (material, scale, 0, 0, 0);
            var tagHolder:Particles = new Particles ();
             tagHolder.addParticle (tag);
            tagHolder.x = radius * Math.cos (theta) * Math.sin (phi);
            tagHolder.y = radius * Math.sin (theta) * Math.sin (phi);
             tagHolder.z = radius * Math.cos (phi);
             tagHolder.useOwnContainer = true;
            tagHolder.autoCalcScreenCoords = true;
             tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OVER, objectOverHandler);
            tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OUT, objectOutHandler);
            //tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_PRESS, objectPressHandler);

            tagContainer.addChild (tagHolder);
            tagArray.push (tagHolder);
            }
        }

        private function objectOverHandler (e:InteractiveScene3DEvent):void {
            view.buttonMode = true;
            e.target.filters = [glow];
        }

        private function objectOutHandler (e:InteractiveScene3DEvent):void {
            view.buttonMode = false;

            for (var j:uint = 0; j < tag_num; j++) {
                tagArray [j].filters = [];
            }
        }

        private function enterFrameHandler (e:Event):void {
            tagContainer.rotationX += (mouseY - stage.stageHeight * 0.5) * 0.01;
            tagContainer.rotationY += (mouseX - stage.stageWidth * 0.5) * 0.01;
            renderer.renderScene (scene,camera,view);
            for (var j:uint = 0; j < tag_num; j++) {
                tagArray[j].alpha = minAlpha + (1 - minAlpha) * (1 - (tagArray[j].screen.z - radius) / (2 * radius));
            }
        }
    }
}
