/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aBzc
 */

// forked from twotree's flash on 2010-5-27
package
{
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import Box2D.Dynamics.Joints.b2RevoluteJointDef;
    import com.actionsnippet.qbox.QuickBox2D;
    import flash.display.MovieClip;
    import flash.events.Event;
 
    [SWF(backgroundColor="0x414647")]
    public class QuickBox2DInitializeWorld extends MovieClip
    {
        private var world:b2World;
        private var scale:Number = 30;
 
        public function QuickBox2DInitializeWorld()
        {
            /*/
            /*/
            var quickBox2D:QuickBox2D = new QuickBox2D(this, { debug:true } );
            quickBox2D.mouseDrag();
            quickBox2D.gravity = new b2Vec2;
            world = quickBox2D.w;
            //*/
            Shape.world = world;
            Shape.scale = scale;
            Shape.create( { shape:Shape.RECT, x:0, y:465, width:465, height:1 } );
 
            var bodyB:b2Body = Shape.create( { shape:Shape.RECT, x:200, y:180, width:17,height:17, density:10, restitution:0.6 } );
            var bodyA:b2Body = Shape.create( { shape:Shape.RECT, x:220, y:180, width:50, height:20, density:10, restitution:0.8 } );
 
            var joint:b2RevoluteJointDef = new b2RevoluteJointDef();
            joint.Initialize(bodyA, bodyB, new b2Vec2(bodyA.GetWorldCenter().x -2.5, bodyA.GetWorldCenter().y));
            joint.lowerAngle = 10 / (180/Math.PI);
            joint.upperAngle = 50 / (180/Math.PI);
            joint.referenceAngle = bodyA.GetAngle();
            joint.enableLimit = true;
            joint.motorSpeed = 4;
            joint.userData = { skin:"none"}; 
            world.CreateJoint(joint);
 
            //quickBox2D.start();
            //addEventListener(Event.ENTER_FRAME, onEnterFrame);
            onEnterFrame(null);
        }   
        private function onEnterFrame(event:Event):void 
        {
            world.Step(1 / 60, 10);
        }
    }
}
 
import Box2D.Collision.Shapes.b2CircleDef;
import Box2D.Collision.Shapes.b2PolygonDef;
import Box2D.Collision.Shapes.b2ShapeDef;
import Box2D.Common.Math.b2Vec2;
import Box2D.Dynamics.b2Body;
import Box2D.Dynamics.b2BodyDef;
import Box2D.Dynamics.b2World;
 
class Shape
{
    public static const CIRCLE:int = 0;
    public static const RECT:int = 1;
 
    public static var world:b2World;
    public static var scale:Number;
 
    public static function addVec2(body:b2Body, x:Number, y:Number):void
    {
        body.SetXForm(new b2Vec2(body.GetPosition().x + x / scale, body.GetPosition().y + y / scale), body.GetAngle());
    }
 
    public static function setVec2(body:b2Body, x:Number, y:Number):void
    {
        body.SetXForm(new b2Vec2(x / scale, y / scale), body.GetAngle());
    }
 
    public static function addAngle(body:b2Body, rotate:Number):void
    {
        body.SetXForm(body.GetPosition(), body.GetAngle() + rotate * Math.PI / 180);
    }
 
    public static function setAngle(body:b2Body, rotate:Number):void
    {
        body.SetXForm(body.GetPosition(), rotate * Math.PI / 180);
    }
 
    public static function create(params:Object):b2Body
    {
        var def:b2BodyDef = new b2BodyDef();
        if (params.angle) def.angle = params.angle * Math.PI / 180;
 
        var shape:b2ShapeDef;
        if (params.shape == Shape.RECT)
        {
            def.position.Set((params.x + params.width / 2) / scale, (params.y + params.height / 2) / scale);
            shape = new b2PolygonDef();
            b2PolygonDef(shape).SetAsBox(params.width / 2 / scale, params.height / 2 / scale);
        }
        else if (params.shape == Shape.CIRCLE)
        {
            def.position.Set(params.x / scale, params.y / scale);
            shape = new b2CircleDef();
            b2CircleDef(shape).radius = params.radius / scale;
        }
 
        shape.density = params.density;
        shape.restitution = params.restitution;
 
        var body:b2Body = world.CreateBody(def);
        body.CreateShape(shape);
 
        if (shape.density > 0) body.SetMassFromShapes();
 
        return body;
    }
}

