/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aB4L
 */

/**
 * Dot Font
 * 一部 whirlpower さんのを参考にしました。
 * @author jc at bkzen
 * @see http://wonderfl.net/c/bGHr
 */
package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF (backgroundColor = "0x000000", frameRate = "30", width = "465", height = "465")]
    public class DotFontMain extends Sprite
    {
        
        public function DotFontMain() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            var txt: STextField = new STextField(0xFFFFFF, 2, 0, STextField.CENTER);
            addChild(txt);
            txt.x = stage.stageWidth >> 1;
            txt.add("┌──ばかぜん──┰──────────┐");
            txt.add("│　　　　　　　　┃　　　ちから：　１０│");
            txt.add("│　　せんし　　　┃　　すばやさ：２５５│");
            txt.add("│せいべつ：おとこ┃　たいりょく：１２３│");
            txt.add("│　レベル：　　３┃　　かしこさ：　　０│");
            txt.add("│　　ＨＰ：　４０┃　うんのよさ：１４０│");
            txt.add("│　　ＭＰ：　　０┃さいだいＨＰ：　５０│");
            txt.add("┝━━━━━━━━┫さいだいＭＰ：　　０│");
            txt.add("│Ｅ　もじゃのけん┃　こうげきカ：　３０│");
            txt.add("│Ｅ　ただのよろい┃　　しゅびカ：１１３│");
            txt.add("│Ｅ　きのたて　　┃　　　　　　　　　　│");
            txt.add("│Ｅ　かめん　　　┃￡：１２３４５６７８│");
            txt.add("└────────┸──────────┘");
            
            
        }
        
    }
}
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.display.Shape;
import flash.events.Event;
import flash.geom.ColorTransform;
import flash.geom.Matrix;

class STextField extends Shape
{
    public static const LEFT: int   = 0;
    public static const CENTER: int = 1;
    public static const RIGHT: int  = 2;
    private var rows: Array/*Row*/ = [];
    private var mtx: Matrix = new Matrix();
    private var h: Number = 0, cnt: int, len: int;
    private var defaultColor: uint = 0xFFFFFF;
    private var defaultScale: Number = 1.0;
    private var defaultDelay: uint = 0;
    private var defaultAlign: uint = 0;
    
    function STextField(defaultColor: uint = 0xFFFFFF, defaultScale: Number = 1.0, defaultDelay: uint = 1, defaultAlign: uint = 0) 
    {
        this.defaultColor = defaultColor;
        this.defaultScale = defaultScale;
        this.defaultDelay = defaultDelay;
        this.defaultAlign = defaultAlign;
        
    }
    public function add(
        text: String, color: Object = null, scale: Object = null, delay: Object = null, align: Object = null
    ): void
    {
        var row: Row = new Row(
            text, 
            color == null ? defaultColor : uint(color), 
            scale == null ? defaultScale : Number(scale), 
            delay == null ? defaultDelay : uint(delay), 
            align == null ? defaultAlign : uint(align), 
            h
        );
        len = rows.push(row);
        h += row.h;
        removeEventListener(Event.ENTER_FRAME, loop);
        addEventListener(Event.ENTER_FRAME, loop);
    }
    
    private function loop(e: Event): void 
    {
        if (rows[cnt].draw(graphics) && (++cnt == len)) removeEventListener(Event.ENTER_FRAME, loop);
    }
    
    private function clear(): void
    {
        graphics.clear();
        while ((len = rows.length) > 0) rows.pop().dispose();
    }
}

class Row
{
    private static const sizeW: int = 8;
    private static const sizeH: int = 15;
    public var bmd: BitmapData;
    public var width: Number, w: Number, h: Number;
    public var length: int, cnt: int, head: int;
    private var mtx: Matrix;
    private var delay: uint;
    
    function Row(text: String, color: uint, scale: Number, delay: uint, align: uint, y: Number)
    {
        this.delay = delay;
        w = sizeW * scale, h = sizeH * scale;
        align = align % 3;
        length = text.length;
        bmd = new BitmapData(width = w * length, h, true, 0);
        var colorTf: ColorTransform = (color == 0xFFFFFF ? null : new ColorTransform(
            1, 1, 1, 1, ((color >> 0x10) & 0xFF) - 0xFF, ((color >> 0x08) & 0xFF) - 0xFF, ((color >> 0x00) & 0xFF) - 0xFF
        ));
        mtx = new Matrix(scale, 0, 0, scale);
        bmd.lock();
        for (var i: int = 0; i < length; i++) 
        {
            bmd.draw(FontData(fonts[text.charAt(i)] || fonts["ng"]).bmd, mtx, colorTf);
            mtx.tx += w;
        }
        bmd.unlock();
        mtx.a = mtx.d = 1;
        mtx.b = mtx.c = 0;
        mtx.tx = - width * align / 2;
        mtx.ty = y;
    }
    
    public function draw(g: Graphics): Boolean
    {
        if (delay == 0) 
        {
            g.beginBitmapFill(bmd, mtx);
            g.drawRect(mtx.tx, mtx.ty, width, h);
            return true;
        }
        if ((cnt++ % delay) == 0)
        {
            g.beginBitmapFill(bmd, mtx);
            g.drawRect(mtx.tx + (w * head), mtx.ty, w, h);
            if (++head >= length) return true;
        }
        return false;
    }
    public function dispose(): void
    {
        bmd.dispose();
        bmd = null;
        mtx = null;
    }
}

class FontData
{
    public var bmd: BitmapData;
    function FontData(data: String)
    {
        if (data == null) return;
        var arr: Array = data.match(/../g).map(_map).reverse();
        bmd = new BitmapData(8, 15, true, 0x00000000);
        bmd.lock();
        var y: int, x: int;
        while (arr.length > 0)
        {
            var u: uint = arr.pop();
            for (x = 0; x < 8; x++, u >>= 1) bmd.setPixel32(7 - x, y, (u & 1) ? 0xFFFFFFFF : 0x00000000);
            y ++;
        }
        bmd.unlock();
    }
    private function _map(e: *, i: int, a: Array): int { return parseInt(e, 16); }
}

const fonts: Object = 
{
    "A": $("0000000000386CC6C6FEC6C6000000"), "B": $("0000000000FCC6C6FCC6C6FC000000"), "C": $("00000000003C66C0C0C0663C000000"), 
    "D": $("0000000000F8CCC6C6C6CCF8000000"), "E": $("00000000007E60607C60607E000000"), "F": $("0000000000FEC0C0FCC0C0C0000000"),
    "G": $("00000000003E60C0CEC6663E000000"), "H": $("0000000000C6C6C6FEC6C6C6000000"), "I": $("00000000007E18181818187E000000"),
    "J": $("00000000000606060606C67C000000"), "K": $("0000000000C6CCD8F0F8DCCE000000"), "L": $("00000000006060606060607E000000"),
    "M": $("0000000000C6EEFEFED6C6C6000000"), "N": $("0000000000C6E6F6FEDECEC6000000"), "O": $("00000000007CC6C6C6C6C67C000000"),
    "P": $("0000000000FCC6C6C6FCC0C0000000"), "Q": $("00000000007CC6C6C6DECC7A000000"), "R": $("0000000000FCC6C6CEF8DCCE000000"),
    "S": $("000000000078CCC07C06C67C000000"), "T": $("00000000007E181818181818000000"), "U": $("0000000000C6C6C6C6C6C67C000000"),
    "V": $("0000000000C6C6C6EE7C3810000000"), "W": $("0000000000C6C6D6FEFEEEC6000000"), "X": $("0000000000C6EE7C387CEEC6000000"),
    "Y": $("00000000006666663C181818000000"), "Z": $("0000000000FE0E1C3870E0FE000000"), "a": $("0000000000000078CCCCCC7E000000"),
    "b": $("000000000060607C6666667C000000"), "c": $("000000000000003C6660663C000000"), "d": $("000000000006063E6666663E000000"), 
    "e": $("000000000000003C667E603E000000"), "f": $("000000000038307830303030000000"), "g": $("000000000000003C6666663E063C00"),
    "h": $("000000000060607C66666666000000"), "i": $("000000000018001818181818000000"), "j": $("000000000018001818181818D87000"),
    "k": $("00000000006060666C786C66000000"), "l": $("000000000018181818181818000000"), "m": $("00000000000080FCD6D6D6D6000000"),
    "n": $("000000000000007C66666666000000"), "o": $("000000000000003C6666663C000000"), "p": $("000000000000007C6666667C606000"),
    "q": $("000000000000003E6666663E060600"), "r": $("000000000000006E78706060000000"), "s": $("000000000000003E703C0E7C000000"),
    "t": $("000000000030307830303030000000"), "u": $("00000000000000666666663E000000"), "v": $("000000000000006666663C18000000"),
    "w": $("00000000000000C6D6D6D66C000000"), "x": $("00000000000000663C183C66000000"), "y": $("00000000000000666666663E063C00"),
    "z": $("000000000000007E1C38707E000000"), "0": $("0000000000384CC6C6C66438000000"), "1": $("00000000001838781818187E000000"),
    "2": $("00000000007CC60E3C78E0FE000000"), "3": $("00000000007E0C183C06C67C000000"), "4": $("00000000001C3C6CCCFE0C0C000000"),
    "5": $("0000000000FCC0FC0606C67C000000"), "6": $("00000000003C60C0FCC6C67C000000"), "7": $("0000000000FEC60C18303030000000"),
    "8": $("000000000078C4E4789E867C000000"), "9": $("00000000007CC6C67E060C78000000"), "!": $("000000000018181818180018000000"),
    "\"":$("00000000006C6C2400000000000000"), "#": $("00000000006CFE6C6C6CFE6C000000"), "$": $("00000000007CD6D07C16D67C000000"),
    "%": $("0000000000E4ACB8FE3A6A4E000000"), "&": $("0000000000386C6CFECCCE7A000000"), "'": $("000000000060602000000000000000"),
    "(": $("00000000000C18181818180C000000"), ")": $("0000000000180C0C0C0C0C18000000"), "=": $("000000000000FE0000FE0000000000"),
    "~": $("00000000000060F29E0C0000000000"), "|": $("000000000018181818181818000000"), "-": $("00000000000000FE00000000000000"),
    "^": $("0000000010386C0000000000000000"), "`": $("000000000060703818000000000000"), "@": $("00000000007CC6F6D6F6C07E000000"), 
    "*": $("000000000000107C38280000000000"), "+": $("0000000000003030FC303000000000"), "_": $("0000000000000000000000FE000000"),
    "?": $("00000000003C66660C180018000000"), ">": $("00000000006030180C183060000000"), "<": $("00000000000C18306030180C000000"),
    ",": $("000000000000000000003030100000"), ".": $("000000000000000000003030000000"), "/": $("0000000000060C183060C080000000"),
    "\\":$("0000000000C06030180C0602000000"), "[": $("000000000038303030303038000000"), "]": $("000000000038181818181838000000"), 
    ":": $("000000000000181800181800000000"), ";": $("000000000000181800181808000000"), "{": $("00000000000C18183018180C000000"),
    "}": $("0000000000180C0C060C0C18000000"), "あ": $("000000000020FC207CAAB2E4000000"), "い": $("00000000000088848282A240000000"),
    "う": $("000000000078007C82020418000000"), "え": $("00000000007800FC081028CE000000"), "お": $("00000000002CF2203C62A2EC000000"), 
    "か": $("000000000024FA262444548C000000"), "き": $("0000000000107C08FE08403E000000"), "く": $("000000000008102040201008000000"),
    "け": $("000000000084BE8484848458000000"), "こ": $("00000000007804000000827C000000"), "さ": $("000000000010FE08048C807C000000"),
    "し": $("000000000080808082824438000000"), "す": $("000000000004FE3C443C0418000000"), "せ": $("000000000044FE444440403C000000"),
    "そ": $("00000000007C08FE1820201C000000"), "た": $("000000000040FC405E80A09E000000"), "ち": $("000000000020FE203C42023C000000"),
    "つ": $("000000000000FC0202020438000000"), "て": $("0000000000FE08102020201C000000"), "と": $("00000000004026382040403E000000"),
    "な": $("000000000040F64288384C32000000"), "に": $("0000000000409E80808090CE000000"), "ぬ": $("0000000000487CCAAAB6BA66000000"),
    "ね": $("000000000040EC5262CED24E000000"), "の": $("0000000000003C5292929264000000"), "は": $("000000000004BE84849CA65A000000"),
    "ひ": $("000000000030E02C46444438000000"), "ふ": $("0000000000380810544A8AB6000000"), "へ": $("000000000000205088840200000000"),
    "ほ": $("0000000000BE84BE849CA6DA000000"), "ま": $("000000000010FC10FC7098E4000000"), "み": $("0000000000E024247EA4A448000000"),
    "む": $("000000000020F42262A0A27C000000"), "め": $("0000000000487C4ACAB2A254000000"), "も": $("0000000000107C20FC20221C000000"),
    "や": $("0000000000485C62A2241010000000"), "ゐ": $("000000000070103C52929666000000"), "ゆ": $("000000000050BCCA8AAA9C50000000"),
    "ゑ": $("000000000038107C04387CAA000000"), "よ": $("0000000000101C1010789462000000"), "ら": $("00000000001804205C62421C000000"),
    "り": $("000000000044424252220408000000"), "る": $("000000000078103C42823A3C000000"), "れ": $("000000000020EE322262A426000000"),
    "ろ": $("000000000078103C4282021C000000"), "わ": $("000000000040DC6242C24244000000"), "を": $("0000000000107C305E28403C000000"),
    "ん": $("000000000010202070488A84000000"), "ぁ": $("00000000000020782074A8F4000000"), "ぃ": $("00000000000000888484A440000000"),
    "ぅ": $("0000000000007000F8080870000000"), "ぇ": $("0000000000007000F81070DC000000"), "ぉ": $("00000000000028F42078A4CC000000"),
    "っ": $("0000000000000038C4040438000000"), "ゃ": $("0000000000004878C4442820000000"), "ゅ": $("00000000000010B8D4949C30000000"),
    "ょ": $("000000000000101C10709874000000"), "ゎ": $("00000000000040D86444C448000000"), "が": $("000000050524FA262444548C000000"),
    "ぎ": $("0000000505107C08FE08403E000000"), "ぐ": $("000000050508102040201008000000"), "げ": $("000000050584BE8484848458000000"),
    "ご": $("00000005057804000000827C000000"), "ざ": $("000000050510FE08048C807C000000"), "じ": $("000000050580808082824438000000"),
    "ず": $("000000050504FE3C443C0418000000"), "ぜ": $("000000050544FE444440403C000000"), "ぞ": $("00000005057C08FE1820201C000000"),
    "だ": $("000000050540FC405E80A09E000000"), "ぢ": $("000000050520FE203C42023C000000"), "づ": $("000000050500FC0202020438000000"),
    "で": $("0000000505FE08102020201C000000"), "ど": $("00000005054026382040403E000000"), "ば": $("000000050504BE84849CA65A000000"),
    "び": $("000000050530E02C46444438000000"), "ぶ": $("0000000505380810544A8AB6000000"), "べ": $("0000000505002070D88C0602000000"),
    "ぼ": $("0000000505BE84BE849CA6DA000000"), "ぱ": $("000002050204BE84849CA65A000000"), "ぴ": $("000002050230E02C46444438000000"),
    "ぷ": $("0000020502380810544A8AB6000000"), "ぺ": $("000000040A04205088840200000000"), "ぽ": $("0000020502BE84BE849CA6DA000000"),
    "ア": $("0000000000FE021214102040000000"), "イ": $("0000000000020418E8080808000000"), "ウ": $("000000000010FE8282020438000000"),
    "エ": $("000000000000FE10101010FE000000"), "オ": $("000000000004FE040C1424C4000000"), "カ": $("000000000020FE222242428C000000"),
    "キ": $("000000000020FE1010FE0808000000"), "ク": $("0000000000203E4282020438000000"), "ケ": $("0000000000407E4484040830000000"),
    "コ": $("000000000000FE02020202FE000000"), "サ": $("000000000044FE4444040830000000"), "シ": $("0000000000C020C222040870000000"),
    "ス": $("0000000000FE0204081422C2000000"), "セ": $("000000000040FE424440403E000000"), "ソ": $("000000000082424202040830000000"),
    "タ": $("00000000003E22629A060438000000"), "チ": $("00000000000C7010FE101020000000"), "ツ": $("000000000052525202020438000000"),
    "テ": $("00000000007C00FE10101020000000"), "ト": $("0000000000404040704C4040000000"), "ナ": $("000000000008FE0808101020000000"),
    "ニ": $("0000000000007C00000000FE000000"), "ヌ": $("0000000000FE0202340C0A70000000"), "ネ": $("000000000010FE020438D610000000"),
    "ノ": $("0000000000020202040418E0000000"), "ハ": $("000000000048444442424282000000"), "ヒ": $("00000000004046784040403E000000"),
    "フ": $("0000000000FE020202020438000000"), "ヘ": $("000000000000205088840200000000"), "ホ": $("000000000010FE1054549292000000"),
    "、": $("000000000000000000804020000000"), "。": $("000000000000000060909060000000"), "マ": $("0000000000FE020204281008000000"),
    "ミ": $("0000000000700C601800E01C000000"), "ム": $("000000000010202044448EF2000000"), "メ": $("0000000000024222140814E2000000"),
    "モ": $("00000000007C2020FE20201C000000"), "ヤ": $("000000000040FE4224201010000000"), "ヰ": $("000000000008087848FE0808000000"),
    "ユ": $("0000000000007808080808FE000000"), "ヱ": $("0000000000FC0414181010FE000000"), "ヨ": $("0000000000FC0404FC0404FC000000"),
    "ラ": $("00000000007C00FE02020478000000"), "リ": $("000000000042424242020438000000"), "ル": $("000000000010505050525498000000"),
    "レ": $("0000000000808080808488F0000000"), "ロ": $("0000000000FE8282828282FE000000"), "ワ": $("0000000000FE828202020438000000"),
    "ヲ": $("0000000000FE02023E020478000000"), "ン": $("0000000000C0320202020CF0000000"), "ァ": $("000000000000F80828302040000000"),
    "ィ": $("0000000000000810E0202020000000"), "ゥ": $("00000000000020F888081020000000"), "ェ": $("00000000000000F8202020F8000000"),
    "ォ": $("00000000000010F810305090000000"), "ッ": $("00000000000000A8A8081060000000"), "ャ": $("00000000000040F848482020000000"),
    "ュ": $("0000000000000070101010F8000000"), "ョ": $("00000000000000F8087808F8000000"), "ヮ": $("00000000000000F888081060000000"),
    "ガ": $("000000050520FE222242428C000000"), "ギ": $("000000050520FE1010FE0808000000"), "グ": $("0000000505203E4282020438000000"),
    "ゲ": $("0000000505407E4484040830000000"), "ゴ": $("000000050500FE02020202FE000000"), "ザ": $("000000050544FE4444040830000000"),
    "ジ": $("0000000505C020C222040870000000"), "ズ": $("0000000505FE0204081422C2000000"), "ゼ": $("000000050540FE424440403E000000"),
    "ゾ": $("000000050580424202040830000000"), "ダ": $("00000005053E22629A060438000000"), "ヂ": $("00000005050C7010FE101020000000"),
    "ヅ": $("000000050550525202020438000000"), "デ": $("00000005057C00FE10101020000000"), "ド": $("0000000A0A404040704C4040000000"),
    "バ": $("000000050548444442424282000000"), "ビ": $("00000005054046784040403E000000"), "ブ": $("0000000505FE020202020438000000"),
    "ベ": $("000000000A0A205088840200000000"), "ボ": $("000000050510FE1054549292000000"), "パ": $("000002050248444442424282000000"),
    "ピ": $("00000205024046784040403E000000"), "プ": $("0000020502FE020202020438000000"), "ペ": $("000000040A04205088840200000000"),
    "ポ": $("000002050210FE1054549292000000"), " ":  $("000000000000000000000000000000"), "　": $("000000000000000000000000000000"),
    "「": $("0000001E1E18181818000000000000"), "」": $("000000000000181818187878000000"), "★": $("000000001038FE7C386CC600000000"), 
    "●": $("00000000387CFEFEFE7C3800000000"), "○": $("000000003844828282443800000000"), "◎": $("000000003844BAAABA443800000000"), 
    "■": $("00000000007C7C7C7C7C0000000000"), "□": $("00000000007C4444447C0000000000"), "◆": $("000000000010387C38100000000000"),
    "◇": $("000000000010284428100000000000"), "▲": $("000000001038387C7CFE0000000000"), "△": $("000000001028284444FE0000000000"),
    "▼": $("0000000000FE7C7C38381000000000"), "▽": $("0000000000FE444428281000000000"), "×": $("000000000044281028440000000000"),
    "ω": $("0000000000004492926C0000000000"), "Д": $("000000003848484878840000000000"), "※": $("000000009244289228449200000000"), 
    "←": $("00000000002040FE40200000000000"), "↑": $("000000001038541010101000000000"), "↓": $("000000001010101054381000000000"),
    "→": $("00000000001008FC08100000000000"), "♀": $("0000003844444438107C1010000000"), "♂": $("000000001E060A7290906000000000"),
    "♪": $("00000000101814141070F060000000"), "ゝ": $("00000000002020100C300000000000"), "ゞ": $("000000041248402018600000000000"), 
    "ヽ": $("000000000020100804040000000000"), "ヾ": $("000000041248201008080000000000"), "㊥": $("0000007CFEFE9292EE7C5400000000"), // ドクロ
    "㊤": $("00000000006CFEFE7C381010000000"), "㊦": $("0000001082387C7C7C388210000000"), "㊧": $("00000000041C7CFC7C1C0400000000"), // ハート、太陽、<|
    "㊨": $("0000000040707C7E7C704000000000"), "￡": $("00000000F08085E58285F500000000"), "ー": $("000000000000403E00000000000000"), // |>、Ex、ー
    "│": $("181818181818181818181818181818"), "┃": $("3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C"), "┤": $("181818181818F8F818181818181818"), 
    "┥": $("1818181818F8F000F0F81818181818"), "┨": $("3C3C3C3C3C3CFCFC3C3C3C3C3C3C3C"), "┫": $("3C3C3C3C3CFCEC0CECFC3C3C3C3C3C"), 
    "├": $("1818181818181F1F18181818181818"), "┝": $("18181818181F0F000F1F1818181818"), "┠": $("3C3C3C3C3C3C3F3F3C3C3C3C3C3C3C"),
    "┣": $("3C3C3C3C3C3F3730373F3C3C3C3C3C"), "┌": $("0000000000000F1F18181818181818"), "┐": $("000000000000F0F818181818181818"), 
    "┘": $("181818181818F8F000000000000000"), "└": $("1818181818181F0F00000000000000"), "─": $("000000000000FFFF00000000000000"), 
    "━": $("0000000000FFFF00FFFF0000000000"), "┬": $("000000000000FFFF18181818181818"), "┰": $("000000000000E7FF3C3C3C3C3C3C3C"), 
    "┯": $("0000000000FFFF00FFFF1818181818"), "┳": $("0000000000FFFF00E7FF3C3C3C3C3C"), "┴": $("181818181818FFFF00000000000000"), 
    "┸": $("3C3C3C3C3C3CFFE700000000000000"), "┻": $("3C3C3C3C3CFFE700FFFF0000000000"), "┷": $("1818181818FFFF00FFFF0000000000"), 
    "┼": $("181818181818FFFF18181818181818"), "╋": $("3C3C3C3C3CFFE700E7FF3C3C3C3C3C"), "┿": $("1818181818FFFF00FFFF1818181818"),
    "╂": $("3C3C3C3C3C3CE7E73C3C3C3C3C3C3C"), 
    
    "Ａ": $("0000000000386CC6C6FEC6C6000000"), "Ｂ": $("0000000000FCC6C6FCC6C6FC000000"), "Ｃ": $("00000000003C66C0C0C0663C000000"), 
    "Ｄ": $("0000000000F8CCC6C6C6CCF8000000"), "Ｅ": $("00000000007E60607C60607E000000"), "Ｆ": $("0000000000FEC0C0FCC0C0C0000000"),
    "Ｇ": $("00000000003E60C0CEC6663E000000"), "Ｈ": $("0000000000C6C6C6FEC6C6C6000000"), "Ｉ": $("00000000007E18181818187E000000"),
    "Ｊ": $("00000000000606060606C67C000000"), "Ｋ": $("0000000000C6CCD8F0F8DCCE000000"), "Ｌ": $("00000000006060606060607E000000"),
    "Ｍ": $("0000000000C6EEFEFED6C6C6000000"), "Ｎ": $("0000000000C6E6F6FEDECEC6000000"), "Ｏ": $("00000000007CC6C6C6C6C67C000000"),
    "Ｐ": $("0000000000FCC6C6C6FCC0C0000000"), "Ｑ": $("00000000007CC6C6C6DECC7A000000"), "Ｒ": $("0000000000FCC6C6CEF8DCCE000000"),
    "Ｓ": $("000000000078CCC07C06C67C000000"), "Ｔ": $("00000000007E181818181818000000"), "Ｕ": $("0000000000C6C6C6C6C6C67C000000"),
    "Ｖ": $("0000000000C6C6C6EE7C3810000000"), "Ｗ": $("0000000000C6C6D6FEFEEEC6000000"), "Ｘ": $("0000000000C6EE7C387CEEC6000000"),
    "Ｙ": $("00000000006666663C181818000000"), "Ｚ": $("0000000000FE0E1C3870E0FE000000"), "ａ": $("0000000000000078CCCCCC7E000000"),
    "ｂ": $("000000000060607C6666667C000000"), "ｃ": $("000000000000003C6660663C000000"), "ｄ": $("000000000006063E6666663E000000"), 
    "ｅ": $("000000000000003C667E603E000000"), "ｆ": $("000000000038307830303030000000"), "ｇ": $("000000000000003C6666663E063C00"),
    "ｈ": $("000000000060607C66666666000000"), "ｉ": $("000000000018001818181818000000"), "ｊ": $("000000000018001818181818D87000"),
    "ｋ": $("00000000006060666C786C66000000"), "ｌ": $("000000000018181818181818000000"), "ｍ": $("00000000000080FCD6D6D6D6000000"),
    "ｎ": $("000000000000007C66666666000000"), "ｏ": $("000000000000003C6666663C000000"), "ｐ": $("000000000000007C6666667C606000"),
    "ｑ": $("000000000000003E6666663E060600"), "ｒ": $("000000000000006E78706060000000"), "ｓ": $("000000000000003E703C0E7C000000"),
    "ｔ": $("000000000030307830303030000000"), "ｕ": $("00000000000000666666663E000000"), "ｖ": $("000000000000006666663C18000000"),
    "ｗ": $("00000000000000C6D6D6D66C000000"), "ｘ": $("00000000000000663C183C66000000"), "ｙ": $("00000000000000666666663E063C00"),
    "ｚ": $("000000000000007E1C38707E000000"), "０": $("0000000000384CC6C6C66438000000"), "１": $("00000000001838781818187E000000"),
    "２": $("00000000007CC60E3C78E0FE000000"), "３": $("00000000007E0C183C06C67C000000"), "４": $("00000000001C3C6CCCFE0C0C000000"),
    "５": $("0000000000FCC0FC0606C67C000000"), "６": $("00000000003C60C0FCC6C67C000000"), "７": $("0000000000FEC60C18303030000000"),
    "８": $("000000000078C4E4789E867C000000"), "９": $("00000000007CC6C67E060C78000000"), "！": $("000000000018181818180018000000"),
    "”": $("00000000006C6C2400000000000000"), "＃": $("00000000006CFE6C6C6CFE6C000000"), "＄": $("00000000007CD6D07C16D67C000000"),
    "％": $("0000000000E4ACB8FE3A6A4E000000"), "＆": $("0000000000386C6CFECCCE7A000000"), "’": $("000000000060602000000000000000"),
    "（": $("00000000000C18181818180C000000"), "）": $("0000000000180C0C0C0C0C18000000"), "＝": $("000000000000FE0000FE0000000000"),
    "～": $("00000000000060F29E0C0000000000"), "｜": $("000000000018181818181818000000"), "－": $("00000000000000FE00000000000000"),
    "＾": $("0000000010386C0000000000000000"), "‘": $("000000000060703818000000000000"), "＠": $("00000000007CC6F6D6F6C07E000000"), 
    "＊": $("000000000000107C38280000000000"), "＋": $("0000000000003030FC303000000000"), "＿": $("0000000000000000000000FE000000"),
    "？": $("00000000003C66660C180018000000"), "＞": $("00000000006030180C183060000000"), "＜": $("00000000000C18306030180C000000"),
    "，": $("000000000000000000003030100000"), "．": $("000000000000000000003030000000"), "／": $("0000000000060C183060C080000000"),
    "￥": $("0000000000C06030180C0602000000"), "［": $("000000000038303030303038000000"), "］": $("000000000038181818181838000000"), 
    "：": $("000000000000181800181800000000"), "；": $("000000000000181800181808000000"), "｛": $("00000000000C18183018180C000000"),
    "｝": $("0000000000180C0C060C0C18000000"), 
    
    "ng": $("00FEC6AA92AAC6FE00000000000000"), "return": $(null) 
}
function $(data: String): FontData { return new FontData(data); }
