/**
 * Copyright yumoi ( http://wonderfl.net/user/yumoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aB1m
 */

// forked from yama3's flash on 2011-5-18
package {
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    [SWF(width="465", height="465", frameRate="60", backgroundColor="0")]
    
    public class FlashTest extends Sprite {
        private const IMAGE:String = "C:\Documents and Settings\000608\デスクトップ\わんだい\free3DhumanfigureApollob.jpg";
        private const MAX_DIST:int = 50;
        private var _loader:Loader;
        private var _srcBmd:BitmapData;
        private var _canvas:BitmapData;
        private var _glow:BitmapData;
        private var _iniPoints:Array = [];
        private var _pPoints:Array = [];
        private var _ct:ColorTransform = new ColorTransform(.85, .85, .85);
        
        public function FlashTest() {
            loadImage(IMAGE);            
        }
        
        private function loadImage(url:String):void
        {
            var context:LoaderContext = new LoaderContext;
            context.checkPolicyFile = true;
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoaded);
            _loader.load(new URLRequest(url), context);
        }
        
        private function onLoaded(e:Event):void
        {
            _loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onLoaded);
            _srcBmd = new BitmapData(stage.stageWidth, stage.stageHeight);
            _srcBmd.draw(_loader);
            setup();
        }
        
        private function setup():void
        {
            createGrid();
            _canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
            var bm:Bitmap = new Bitmap(_canvas);
            addChild(bm);
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void
        {
            _canvas.lock();
            _canvas.colorTransform(_canvas.rect, _ct);
            var l:int = _pPoints.length;
            for(var i:int=0; i<l; i++) {
                var p:PhysicsPoint = _pPoints[i];
                p.setAcceleration((_iniPoints[i].x - p.x) * 5, (_iniPoints[i].y - p.y) * 5);
                var dist:Number = Point.distance(new Point(mouseX, mouseY), p);
                if(dist < MAX_DIST) {
                    var n:Number = (MAX_DIST - dist) / MAX_DIST;
                    p.setAcceleration((p.x - mouseX) * n * 500, (p.y - mouseY) * n * 500);
                }
                p.update();
                _canvas.setPixel(p.x, p.y, _srcBmd.getPixel(p.x, p.y));
            }
            _canvas.unlock();
        }
        
        private function createGrid():void
        {
            var p:Point;
            var pp:PhysicsPoint;
            for(var i:int=0; i<465; i++) {
                for(var j:int=0; j<465; j++) {
                    if(Math.random() < .1) {
                        p = new Point(j, i);
                        pp = new PhysicsPoint(j, i);
                        _iniPoints.push(p);
                        _pPoints.push(pp);
                    }
                }
            }
        }
    }
}

import flash.geom.Point;
import flash.utils.Timer;
import flash.events.Event;

internal class PhysicsPoint extends Point
{
    private var _ax:Number, _ay:Number;
    public var vx:Number, vy:Number;
    public var resistance:Number;
    public var pastTime:Number;
    
    public function PhysicsPoint(px:Number, py:Number)
    {
        x = px;
        y = py;
        resistance = .9;
        vx = 0;
        vy = 0;
        _ax = 0;
        _ay = 0;
        pastTime = new Date().getTime();
    }
    
    public function update():void
    {
        var now:Number = new Date().getTime();
        var t:Number = (now -pastTime) * .001;
        
        x += vx * t + .5 * _ax * t * t;
        y += vy * t + .5 * _ay * t * t;
        
        vx += _ax * t;
        vy += _ay * t;
        
        vx *= resistance;
        vy *= resistance;
        
        _ax = 0;
        _ay = 0;
        
        pastTime = now;
    }
    
    public function setAcceleration(ax:Number, ay:Number):void
    {
        _ax += ax;
        _ay += ay;
    }
}
