/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aAJW
 */

// forked from Nikolya.Petrov's forked from: Spinfade 2
// forked from GreekFellows's Spinfade 2
package {
    import flash.display.Bitmap;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.geom.Vector3D;
    import flash.geom.Matrix3D;
    
    [SWF(width='465', height='465', frameRate='50')]
    
    public class Spinfade2 extends Sprite {
        private var array:Array;
        private var all:Array;
        private var pushedindex:Array;
        private var done:Array;
        
        private var core:Sprite;
        
        private var sbd:BitmapData;
        private var sb:Bitmap;
        private var ss:Sprite;
        
        private const UNIT:int = 1;
        
        public function Spinfade2() {
            text();
            
            var bitmapData:BitmapData = new BitmapData(465, 465);
            bitmapData.draw(this);
            this.removeChildAt(0);
            
            this.sbd = new BitmapData(465, 465);
            this.sb = new Bitmap(sbd);
            this.ss = new Sprite();
            this.addChild(sb);
            
            this.core = new Sprite();
            this.core.x = 0;
            this.core.y = 0;
            this.core.z = 0;
            this.ss.addChild(this.core);
            
            this.array = [];
            this.all = [];
            this.pushedindex = [];
            this.done = [];
            
            for (var ver:int = 0; ver < bitmapData.height; ver += this.UNIT) {
                for (var hor:int = 0; hor < bitmapData.width; hor += this.UNIT) {
                    if (bitmapData.getPixel(hor, ver) != 0xffffff) {
                        var z:Number = Math.random() * 200 - 100;
                        this.all.push({
                            gx:hor,
                            gy:ver,
                            gz:0,
                            vector:new Vector3D(465 / 2, 465 / 2, z),
                            ax:(hor - 465 / 2) / 820,
                            ay:(ver - 465 / 2) / 820,
                            az:- z / 820,
                            divide:40,
                            color:bitmapData.getPixel(hor, ver)
                        });
                        this.pushedindex.push(this.pushedindex.length);
                    }
                }
            }
            
            this.addEventListener(Event.ENTER_FRAME, spinfade);
        }
        
        private function spinfade(e:Event):void {
            this.core.transform.matrix3D.appendRotation((mouseX - 465/2) / 50, Vector3D.Y_AXIS, new Vector3D(465/2, 0, 0));
            
            for (var it:int = 0; it < 10; it++) {
                if (this.pushedindex.length > 0) {
                    // var ind:int = this.pushedindex[Math.floor(Math.random() * this.pushedindex.length)];
                    var ind:int = this.pushedindex[this.pushedindex.length - 1];
                    this.array.push(this.all[ind]);
                    this.pushedindex.splice(ind, 1);
                }
            }
            
            ss.graphics.clear();
            
            ss.graphics.beginFill(0xffffff, 1);
            ss.graphics.drawRect(0, 0, 465, 465);
            ss.graphics.endFill();
            
            for (var inde:int; inde < this.array.length; inde++) {
                ss.graphics.beginFill(this.array[inde].color, 1);
                ss.graphics.drawRect(graph(this.array[inde].vector).x, graph(this.array[inde].vector).y, this.UNIT, this.UNIT);
                ss.graphics.endFill();
                
                this.array[inde].vector.x += this.array[inde].ax * this.array[inde].divide;
                this.array[inde].vector.y += this.array[inde].ay * this.array[inde].divide;
                this.array[inde].vector.z += this.array[inde].az * this.array[inde].divide;
                
                if (this.array[inde].divide <= 0) {
                    this.array[inde].vector.x = this.array[inde].gx;
                    this.array[inde].vector.y = this.array[inde].gy;
                    this.array[inde].vector.z = this.array[inde].gz;
                    this.array[inde].ax = 0;
                    this.array[inde].ay = 0;
                    this.array[inde].az = 0;
                    
                    this.done.push( {
                        vector:this.array[inde].vector,
                        color:this.array[inde].color
                    });
                    
                    this.array.splice(inde, 1);
                } else {
                    this.array[inde].divide--;
                }
            }
            
            for (var doni:int = 0; doni < this.done.length; doni++) {
                ss.graphics.beginFill(this.done[doni].color, 1);
                ss.graphics.drawRect(graph(this.done[doni].vector).x, graph(this.done[doni].vector).y, this.UNIT, this.UNIT);
                ss.graphics.endFill();
            }
            
            this.sbd.draw(ss);
        }
        
        private function graph(vector:Vector3D):Vector3D {
            var mat:Matrix3D = this.core.transform.matrix3D.clone();
            
            var xy:Vector3D = vector;
            xy = mat.transformVector(vector);
            xy.w = (2000 + xy.z) / 2000;
            xy.project();
            
            return xy;
        }
        
        private function text():TextField {
            var tf:TextField = new TextField();
            tf.text = "デフレ抑制 ";
            
            var fm:TextFormat = new TextFormat();
            fm.font = "Segoe UI Light";
            fm.size = 72;
            fm.align = "center";
            
            tf.setTextFormat(fm);
            
            tf.width = tf.textWidth;
            tf.height = tf.textHeight + 5;
            tf.x = 465 / 2 - tf.textWidth / 2;
            tf.y = 465 / 2 - tf.textHeight / 2;
            
            this.addChild(tf);
            
            return tf;
        }

    }
}