/**
 * Copyright toyoshim ( http://wonderfl.net/user/toyoshim )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aADz
 */

/*
 *
 * 練習がてらこの辺（http://www.adamrocker.com/blog/125/papervision3d_simple_plane.html）から拝借
 * 一部仕様が変わっているようなので若干修正、内容もちょっといじってみた。
 *
 */
package {
    import flash.display.*;
    import flash.events.*;
 
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.core.effects.view.*;
    
    import net.hires.debug.Stats;
 
    [SWF(backgroundColor=0x000008)]
 
    public class MyPlane extends ReflectionView
    {
        private var rootNode  : DisplayObject3D; 
        private var planeObj  : DisplayObject3D;
        private var material  : ColorMaterial;
 
        public function MyPlane():void
        {
            // フレームレート設定
            stage.frameRate = 60;
            
            // 反射する床
            surfaceHeight = -300;
            viewportReflection.alpha = .1;
 
            // rootNode生成
            rootNode = new DisplayObject3D();
            scene.addChild( rootNode );
 
            // マテリアル設定
            material = new ColorMaterial( 0xffaacc, 1 );
            material.oneSide = false;
 
            // Planeオブジェクト生成
            planeObj = new Plane( material, 300, 300, 1, 1);
            planeObj.y += 300;
            rootNode.addChild( planeObj );
 
            // カメラ設定
            camera.z = -1000;
            camera.focus = 30;
            camera.zoom = 10;

            // デバッグ情報
            stage.addChild(new Stats()); 
            
            // イベント登録
            stage.addEventListener(Event.ENTER_FRAME, loop);
        }

        private function loop( event:Event ):void
        {
            // 回転
            planeObj.rotationX += 2;
            planeObj.rotationY += 5;
            planeObj.rotationZ += 1;
 
            // 再レンダリング
            singleRender();
        }
    }
}
