/**
 * Copyright kto12 ( http://wonderfl.net/user/kto12 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a9nH
 */

// forked from kto12's Fractal Test - Chaos Game
package 
{
    import flash.display.Sprite;
    [SWF(frameRate="30", backgroundColor="#000000")]
    public class FractalTest1 extends Sprite {
        
        private var iter:int = 3000;
        private var weightArr:Array = [3, 2];
        //private var fNum:int = 3;
        private var scale:int = 400;
        private var oldX:Number = scale;
        private var oldY:Number = scale;
        private var freq:Array = [0,0,0,0,0,0];
        //constant Arr
        private var cA:Array = 
        [
        0.333, 0, 0, 0, 0.333, 0,
        0.167, -0.289, 0.333, 0.289, 0.167, 0,
        0.167, 0.289, 0.5, -0.289, 0.167, 0.289,
        0.333, 0, 0.677, 0, 0.333, 0
        ];
        /* 
        Sierpinski's Gasket
        [0.5, 0, 0, 0, 0.5, 0,
        0.5, 0, 0.5, 0, 0.5, 0,
        0.5, 0, 0, 0, 0.5, 0.5]
        [
        0.5, 0, 0, 0, 0.5, 0,
        0.5, 0, 0.5, 0, 0.5, 0,
        0.5, 0, 0.25, 0, 0.5, 0.433
        ]
        Koch Curve
        [
        0.333, 0, 0, 0, 0.333, 0,
        0.167, -0.289, 0.333, 0.289, 0.167, 0,
        0.167, 0.289, 0.5, -0.289, 0.167, 0.289,
        0.33, 0, 0.677, 0, 0.333, 0
        ]
        */
        
        public function FractalTest1():void 
        {
	    var id:int;
            var fNum:int = (cA.length+1)/6;
            //trace("start");
            for (var i:int = 0; i < iter; i++) 
	    {
                id = Math.floor(Math.random()*fNum);
                freq[id]++;
		drawPt(id * 6);
	    }
            trace("freq", freq);
        }//end of constructor
       
        //drawing fns
        private function drawPt(tfid:int):void 
	{
	    var newX:Number = 0;
	    var newY:Number = 0; 
	    newX = (
                    cA[tfid + 0] * oldX 
                    + cA[tfid + 1] * oldY
                    + cA[tfid + 2] * scale
                   );
            newY = (
                    cA[tfid + 3] * oldX 
                    + cA[tfid + 4] * oldY
                    + cA[tfid + 5] * scale
                   );
            
	    oldX = newX;
	    oldY = newY;
	    trace(tfid, "pt", oldX, oldY);
            graphics.beginFill(0xFFFFFF);
	    graphics.drawCircle(oldX, oldY, 1);
	}
    }//end of class
}