/**
 * Copyright k.cherenkov ( http://wonderfl.net/user/k.cherenkov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a9UF
 */

// forked from k.cherenkov's Snake game
package  
{
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.utils.Dictionary; 
    import net.user1.reactor.*;
        
    public class Main extends Sprite
    {
        private var snake_vector:Vector.<Element>; //the snake's parts are held in here
        private var other_snakes:Dictionary = new Dictionary();
        private var other_last_buttons:Dictionary = new Dictionary();
        private var timer:Timer;
        private var min_elements:int; //holds how many parts should the snake have at the beginning
        private var apple:Element; //Our apple
        private var apple_catch_value:int;
        private var space_value:Number; //space between the snake parts
        private var last_button_down:uint; //the keyCode of the last button pressed
        private var flag:Boolean; //is it allowed to change direction?
        private var score:Number;
        private var score_tf:TextField; //the Textfield showing the score
        
        private var reactor:Reactor;
        private var room:Room;
        
        public function Main() 
        {
            if(stage)
                addEventListener(Event.ADDED_TO_STAGE, init);
            else
                init();
        }
        
        private function init(e:Event = null):void
        {
            snake_vector = new Vector.<Element>;
            
            space_value = 2;
            timer = new Timer(50); //Every 50th millisecond, the moveIt() function will be fired!
            min_elements = 5;
            apple = new Element(0xFF0000, 1, 10, 10); //red, not transparent, width:10, height: 10;
            apple_catch_value = 10;
            last_button_down = Keyboard.RIGHT; //The starting direction of the snake (only change it if you change the 'for cycle' too.)
            flag = true;
            score = 0;
            score_tf = new TextField();
            this.addChild(score_tf);
            
            reactor = new Reactor();
            reactor.addEventListener(ReactorEvent.READY, onReactorReady);
            reactor.connect("tryunion.com", 80);

            //Create the first <min_elements> Snake parts
            for(var i:int = 0; i < min_elements; ++i)
            {
                snake_vector[i] = new Element(0x00AAFF, 1, 10, 10);
                if (i == 0)
                {
                    //you have to place the first element on a GRID. (now: 0,0) [possible x positions: (snake_vector[0].width+space_value)*<UINT> ]
                    var boundsX:int = (Math.floor(stage.stageWidth / (snake_vector[0].width + space_value)))-1;
                    var randomX:Number = Math.floor(Math.random()*boundsX);
            
                    var boundsY:int = (Math.floor(stage.stageHeight/(snake_vector[0].height + space_value)))-1;
                    var randomY:Number = Math.floor(Math.random()*boundsY);
            
                    attachElement(snake_vector[i], randomX * (snake_vector[0].width + space_value), randomY * (snake_vector[0].height + space_value));
                    snake_vector[0].alpha = 0.7;
                }
                else
                {
                    attachElement(snake_vector[i], snake_vector[i - 1].x - snake_vector[0].width - space_value, snake_vector[i - 1].y);
                }
            }
            
            placeApple(false);
            timer.addEventListener(TimerEvent.TIMER,moveIt);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDown);
            //timer.start();
        }
        
        private function onReactorReady(e:ReactorEvent):void 
        {
            
            room = reactor.getRoomManager().createRoom("wonderfl.kos.MultiSnakeGame");
            
            room.addMessageListener("NEW_USER", onNewUser);
            room.addMessageListener("DIRECTION_CHANGED", onDirectionChanged);
            room.join();
            
            room.sendMessage("NEW_USER", false, null, snake_vector[0].x + ',' + snake_vector[0].y);
        }
        
        private function onNewUser(from:IClient,data:String):void
        {
            //room.sendMessage("NEW_USER", false, null, snake_vector[0].x + ',' + snake_vector[0].y);
            var buffer:/*String*/Array = data.split(',');
            
            var x:Number = Number(buffer[0]);
            var y:Number = Number(buffer[1]);
            
            other_snakes[from.getClientID()] = new Vector.<Element>;
            
            other_snakes[from.getClientID()][0] = new Element(0x00FF00, 1, 10, 10);
            attachElement(other_snakes[from.getClientID()][0], x, y);
            
            for(var i:int = 1; i < min_elements; ++i)
            {
                other_snakes[from.getClientID()][i] = new Element(0x00FF00, 1, 10, 10);
                attachElement(other_snakes[from.getClientID()][i], other_snakes[from.getClientID()][i - 1].x - other_snakes[from.getClientID()][0].width - space_value, other_snakes[from.getClientID()][i - 1].y);
            }
        }
        
        private function onDirectionChanged(from:IClient,data:String):void
        {
            other_last_buttons[from.getClientID()] = uint(data);
        }

        
        private function attachElement(who:Element,lastXPos:Number = 0,lastYPos:Number = 0):void
        {
            who.x = lastXPos;
            who.y = lastYPos;

            this.addChild(who);
        }
        
        private function placeApple(caught:Boolean = true):void
        {
            if (caught)
                apple_catch_value += 10;
            
            var boundsX:int = (Math.floor(stage.stageWidth / (snake_vector[0].width + space_value)))-1;
            var randomX:Number = Math.floor(Math.random()*boundsX);
            
            var boundsY:int = (Math.floor(stage.stageHeight/(snake_vector[0].height + space_value)))-1;
            var randomY:Number = Math.floor(Math.random()*boundsY);

            apple.x = randomX * (apple.width + space_value);
            apple.y = randomY * (apple.height + space_value);
            
            for(var i:uint=0; i<snake_vector.length-1; i++)
            {
                if(snake_vector[i].x == apple.x && snake_vector[i].y == apple.y)
                {
                    placeApple(false);
                    return;
                }
            }
            if (!apple.stage)
                this.addChild(apple);
        }
        
        private function moveIt(e:TimerEvent):void
        {
            if (snake_vector[0].x == apple.x && snake_vector[0].y == apple.y)
            {
                //show the current Score
                score += apple_catch_value;
                score_tf.text = "Score: " + String(score);
                
                placeApple();
                
                //Attach a new snake Element
                snake_vector.push(new Element(0x00AAFF,1,10,10));
                attachElement(snake_vector[snake_vector.length-1],
                                      (snake_vector[snake_vector.length-2].x),
                                      snake_vector[snake_vector.length-2].y);
            }
            if (snake_vector[0].x > stage.stageWidth-snake_vector[0].width || snake_vector[0].x < 0 || snake_vector[0].y > stage.stageHeight-snake_vector[0].height || snake_vector[0].y < 0)
            {
                GAME_OVER();
            }
            
            
            for (var i:int = 0; i < snake_vector.length; i++)
            {
                if (snake_vector[i] != snake_vector[0] && (snake_vector[0].x == snake_vector[i].x && snake_vector[0].y == snake_vector[i].y))
                {
                    GAME_OVER();
                }
                
            }
            
            moveSnake(snake_vector, last_button_down);
                        
            flag = true;
            
            for (var id:String in other_snakes)
            {
                moveSnake(other_snakes[id], other_last_buttons[id]);
            }

            
        }
        
        private function moveSnake(snake:Vector.<Element>, keyCode:uint):void
        {
            var tail:Element = snake.pop();
            switch (keyCode)
            {
                case Keyboard.RIGHT :
                    tail.x =  snake[0].x + snake[0].width + space_value;
                    tail.y = snake[0].y;
                    break;
                case Keyboard.LEFT :
                    tail.x = snake[0].x - snake[0].width - space_value;
                    tail.y = snake[0].y;
                    break;
                case Keyboard.DOWN :
                    tail.y = snake[0].y + snake[0].height + space_value;
                    tail.x = snake[0].x;
                    break;
                case Keyboard.UP :
                    tail.y = snake[0].y - snake[0].height - space_value;
                    tail.x = snake[0].x;
                    break;
            }
            
            tail.alpha = 0.7;
            snake[0].alpha = 1;
            snake.unshift(tail);
        }

        
        private function GAME_OVER():void 
        {
            timer.stop();
            while (this.numChildren)
                this.removeChildAt(0);
            timer.removeEventListener(TimerEvent.TIMER, moveIt);
            stage.removeEventListener(KeyboardEvent.KEY_DOWN, keyDown);
            init();
        }
    
        private function keyDown(e:KeyboardEvent):void 
        {
            if (e.keyCode == Keyboard.LEFT && last_button_down != e.keyCode && last_button_down != Keyboard.RIGHT && flag)
            {
                last_button_down = Keyboard.LEFT;
                flag = false;
            }
            else if (e.keyCode == Keyboard.RIGHT && (last_button_down != e.keyCode || !timer.running) && last_button_down != Keyboard.LEFT && flag)
            {
                last_button_down = Keyboard.RIGHT;
                flag = false;
            }
            else if (e.keyCode == Keyboard.UP && last_button_down != e.keyCode && last_button_down != Keyboard.DOWN && flag)
            {
                last_button_down = Keyboard.UP;
                flag = false;
            }
            else if (e.keyCode == Keyboard.DOWN && last_button_down != e.keyCode && last_button_down != Keyboard.UP && flag)
            {
                last_button_down = Keyboard.DOWN;
                flag = false;
            }
            
            if (!flag)
            {
                room.sendMessage("DIRECTION_CHANGED", false, null, last_button_down.toString());
                if (!timer.running)
                {
                    timer.start();
                }
            }
        }
        
    }
}

import flash.display.Shape;
class Element extends Shape
    {
        //IF IT IS AN APPLE ->
        protected var _catchValue:Number;
        
        //color,alpha,width,height                
        public function Element(_c:uint,_a:Number,_w:Number,_h:Number) 
        {
            graphics.lineStyle(0, _c, _a);
            graphics.beginFill(_c, _a);
            graphics.drawRect(0, 0, _w, _h);
            graphics.endFill();
        }
    }