/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a9RgN
 */

// forked from mutantleg's flash on 2015-3-22
package {
    import flash.text.TextField;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.geom.Rectangle;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            deb = new TextField();
            deb.width=320;deb.height=240;
            deb.mouseEnabled=false;
            addChild(deb);
            
            heightPic = new BitmapData(64,64, false, 0);
   
            addBox(4,4+3, 3,7, 1);           
            addBox(4,4, 3,3, 2);
            addBox(4+3,4, 6,3, 3);
      
            addBox(12,12, 3,3, 4);
            addBox(12-1,12, 1,2, 3);
            addBox(12-2,12, 1,2, 2);
            addBox(12-3,12, 1,2, 1);
      
            
            cx=128;cz=128;

            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKup); 
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor

        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512, false);
        public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }
        public function onKup(e:KeyboardEvent):void { vecKey[e.keyCode] = false; }
        public function isKeyDown(k:int):Boolean { return vecKey[k]; }     

        public var deb:TextField;
            
        public var heightPic:BitmapData;
        public var cw:Number = 16;
        public var ch:Number = 16;
        public var chh2:Number = 16;
        public var mw:int = 16;
        public var mh:int = 16;
        
        public function getHeightWorld(ax:Number, az:Number):Number
        { return heightPic.getPixel(ax/cw,az/ch);  }   
        
        public var rect:Rectangle = new Rectangle();
        public function setHeight(ax:Number,ay:Number,aw:Number,ah:Number, h:Number):void
        { rect.x=ax;rect.y=ay;rect.width=aw;rect.height=ah; heightPic.fillRect(rect,h); }
        
        
        public var cx:Number = 0;
        public var cy:Number = 0;
        public var cz:Number = 0;

        public var ry:Number = 0;

        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);
         
            drawBox(0,0,0, cw*mw,0,ch*mh);  
          
            var i:int; var num:int;  var a:xBox;
            num = vecBox.length;
            for (i = 0; i < num; i+=1)
            {
              a = vecBox[i];
              drawBox2(a.cx,a.cy,a.cz, a.cw,a.ch,a.cd);  
            }//nexti

            camx = 0; camz = cz- 180;
            
            var kd:int;
            var kx:Number; var ky:Number; var kz:Number;
            var ms:Number; ms = 8; 
              kx = cx; ky = cy; kz =cz; kd =0;
            if (isKeyDown(Keyboard.LEFT)) { kx-=ms; kd=1; }
            if (isKeyDown(Keyboard.RIGHT)) { kx+=ms; kd=1; }
            if (isKeyDown(Keyboard.UP)) { kz-=ms;kd=1; }
            if (isKeyDown(Keyboard.DOWN)) { kz+=ms;kd=1; }
            
            var wy:Number;
            ky = getHeightWorld(kx,kz);
            wy = getHeightWorld(cx,cz);
           
            //abs -> dont allow falling down either
           
            if (Math.abs(ky-wy) < 20)
            {cx=kx; cy=ky; cz=kz; }
            else
            {
                //hack to slide at walls
                ky = getHeightWorld(cx,kz);
                if (Math.abs(ky-wy) < 20)
                { cy=ky; cz=kz; }
                else
                {
                    ky = getHeightWorld(kx,cz);
                    if (Math.abs(ky-wy) < 20)
                    {cx=kx; cy=ky;  }
                    
                } 
            }
            
            /*
            if (kd >0)
            {ms=4;
                if (ry < cy) { ry+=ms; if (ry>cy){ry=cy;}}
                else if (ry > cy) { ry-=ms; if (ry<cy){ry=cy;}}
                        
            }
            */
            
            drawBox2(cx,cy,cz, 8, 16, 8);
            //drawBox2(cx,ry,cz, 8, 16, 8);
        
            deb.text = ""+cy;
            
            
        }//onenter
        
        public function addBox(ax:Number, az:Number,  aw:Number, ad:Number, h:Number):void
        {
          var a:xBox; a = new xBox(); vecBox.push(a);
          a.cx = ax*cw; a.cy=0; a.cz = az*ch;
          a.cw = aw*cw; a.ch= h * chh2; a.cd = ad*ch;
          setHeight(ax,az, aw,ad, a.ch);             
        }//addbox

        public var vecBox:Vector.<xBox> = new Vector.<xBox>(0,false);        
        
        public var rendw:Number = 465 * 0.5;        public var rendh:Number = 465 * 0.5;
        public var camx:Number = 0;        public var camy:Number = 0;        public var camz:Number = 0; 
        
       public function drawLine(ax:Number, ay:Number, az:Number,      bx:Number, by:Number, bz:Number):void
        {
           var sx:Number; var sy:Number;     
           ax -= camx; ay -= camy; az -= camz;           bx -= camx; by -= camy; bz -= camz;
    
            sx = ax -az*1.5 + rendw;            sy = (ax * 0) + (az * 1) - ay;
            graphics.moveTo(sx,sy);

            sx = bx -bz*1.5 + rendw;            sy = (bx * 0) + (bz * 1) - by;
            graphics.lineTo(sx, sy);
            
            
        }//drawline 
        
        
       public function drawBox2(ax:Number, ay:Number, az:Number,
       aw:Number, ah:Number, ad:Number):void
        {   drawBox(ax,ay,az,ax+aw,ay+ah,az+ad); }
        
       public function drawBox(ax:Number, ay:Number, az:Number,
          bx:Number, by:Number, bz:Number):void
        {
          drawLine(ax, ay, az,   bx, ay, az);
          drawLine(ax, by, az,   bx, by, az);
          drawLine(ax, ay, bz,   bx, ay, bz);
          drawLine(ax, by, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, by, az);
          drawLine(bx, ay, az,   bx, by, az);
          drawLine(ax, ay, bz,   ax, by, bz);
          drawLine(bx, ay, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, ay, bz);
          drawLine(bx, ay, az,   bx, ay, bz);
          drawLine(ax, by, az,   ax, by, bz);
          drawLine(bx, by, az,   bx, by, bz);
        }//drawbox  
        
        
        
        
    }//classend
}

internal  class xBox
{
  public var cx:Number =0;  public var cy:Number =0;  public var cz:Number =0;
  public var cw:Number =0; public var ch:Number =0; public var cd:Number =0;
     
    
}//xbox


