/**
 * Copyright autumngoodluck ( http://wonderfl.net/user/autumngoodluck )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a9Rg
 */

// forked from autumngoodluck's お絵かきツールもどき（なめらかバージョン）
// forked from autumngoodluck's お絵かきツールもどき
// forked from autumngoodluck's MyTemplate
package
{
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

    [SWF(width="465", height="465", backgroundColor="0x227755", frameRate="25")]
    public class DrawSample extends Sprite
    {
		private var _lines:Array;
		private var _mouseDown:Boolean;

		/*
		 * 初期化
		 */    		
    		public function DrawSample()
    		{
    			_lines     = new Array();
    			_mouseDown = false;

    			addEventListener(Event.ENTER_FRAME, loop, false, 0, true);

    			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler, false, 0, true);
    			stage.addEventListener(MouseEvent.MOUSE_UP,   mouseUpHandler,   false, 0, true);
    		}

    		/*
    		 * マウスボタンが押されている間、線を描画する。
    		 */    		
    		private function loop(event:Event):void
    		{
    			if (_mouseDown)
    			{
    				_lines[_lines.length - 1].addPoint(mouseX, mouseY);
    			}
			for (var i:uint; i < _lines.length; i++)
			{
				_lines[i].draw();
			}
    		}
    		
    		/*
    		 * マウスボタンが押された時の処理
    		 */
    		private function mouseDownHandler(event:MouseEvent):void
    		{
    			_mouseDown = true;
    			
    			_lines.push(new Line());
    			_lines[_lines.length - 1].addPoint(mouseX, mouseY);
    			addChild(_lines[_lines.length - 1]);
    		}
    		
    		/*
    		 * マウスボタンが離された時の処理
    		 */
    		private function mouseUpHandler(event:MouseEvent):void
    		{
    			_mouseDown = false;
    			_lines[_lines.length - 1].fix();
    		}
    }
}

import flash.display.Sprite;
import flash.events.TimerEvent;
import flash.geom.Point;
import flash.utils.Timer;

/*
 * 振動する点
 */
class VibrationPoint extends Point
{
	private var _vibrationWidth:int;
	private var _timer:Timer;
	
	/*
	 * 初期化
	 */
	public function VibrationPoint(x:Number, y:Number)
	{
		super(x, y);
		
		_vibrationWidth = 1;
		
		_timer = new Timer(25);
		_timer.addEventListener(TimerEvent.TIMER, move);
	}
	
	/*
	 * 振動運動スタート
	 */
	public function start():void
	{
		_timer.start();
	}
	
	/*
	 * 振動幅に従い点が行ったり来たりする
	 */
	private function move(event:TimerEvent):void
	{
		_vibrationWidth *= -1;
		x += _vibrationWidth;
		y += _vibrationWidth;
	}
}

/*
 * 線クラス
 */
class Line extends Sprite
{
	private var _thickness:Number;	// 線の太さ
	private var _color:uint;			// 線の色
	private var _points:Array;		// 線を構成する点
	
	/*
	 * 初期化
	 */
	public function Line(thickness:Number = 6, color:uint = 0xFFFFFF)
	{
		_thickness = thickness;
		_color     = color;
		_points    = new Array();
	}
	
	/*
	 * 線を構成する点の追加
	 */
	public function addPoint(x:Number, y:Number):void
	{
		_points.push(new VibrationPoint(x, y));
	}
	
	/*
	 * 線の描画
	 */
	public function draw():void
	{
		graphics.clear();
		graphics.lineStyle(_thickness, _color);

		if (_points.length == 2)
		{
			graphics.moveTo(_points[0].x, _points[0].y);
			graphics.lineTo(_points[1].x, _points[1].y);
		}
		else if (_points.length >= 3)
		{
			graphics.moveTo(_points[0].x, _points[0].y);
			for (var i:uint = 1; i < _points.length - 3; i++)
			{
				graphics.curveTo(_points[i].x,
				                 _points[i].y,
				                 (_points[i].x + _points[i + 1].x) / 2,
				                 (_points[i].y + _points[i + 1].y) / 2);
			}
			graphics.curveTo(_points[_points.length - 2].x,
			                 _points[_points.length - 2].y,
			                 _points[_points.length - 1].x,
			                 _points[_points.length - 1].y);
		}
	}
	
	/*
	 * 線が確定した（これ以上点の追加がない）ことを知らせる
	 */
	public function fix():void
	{
		for (var i:uint = 0; i < _points.length; i++)
		{
			_points[i].start();
		}
	}
}