/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a9LT
 */

// forked from codeonwort's AGAL gaussian blur
// forked from codeonwort's AGAL zoom blur
// forked from codeonwort's context3D creation problem
package {
    
    import flash.display.Sprite;
    import flash.events.Event
    import flash.display.Stage3D
    import flash.display3D.Context3D
    import flash.display3D.Context3DRenderMode
    
    public class FlashTest extends Sprite {

        public function FlashTest() {
            // write as3 code here..
            //Wonderfl.disable_capture()
            stage ? init() : addEventListener("addedToStage", init)
        }
        
        private function init(e:Event=null):void {
            removeEventListener("addedToStage", arguments.callee)
            
            var s3d:Stage3D = stage.stage3Ds[0]
            s3d.addEventListener(Event.CONTEXT3D_CREATE, initStage3D)
            s3d.requestContext3D(Context3DRenderMode.AUTO)
        }
        
        private function initStage3D(e:Event):void {
            var context:Context3D = e.target.context3D as Context3D
            new Study04_GaussianBlur(this, context)
        }

    }
    
}

var debug:TextField

import flash.system.LoaderContext;
import flash.display.LoaderInfo;
import flash.display.DisplayObject;
import flash.text.TextField;
import flash.net.URLRequest;
import flash.display.Loader;

//package {
    import com.adobe.utils.AGALMiniAssembler;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display3D.Context3D;
    import flash.display3D.Context3DTriangleFace
    import flash.display3D.IndexBuffer3D;
    import flash.display3D.Program3D;
    import flash.display3D.VertexBuffer3D;
    import flash.events.Event
    import flash.geom.Matrix3D;
    /**
     * ...
     * @author codeonwort
     */
    internal class Study_Base 
    {
        
        protected var document:Sprite, stage:Stage, context:Context3D
        //protected var antiAlias:int = 4, enableDepthAndStencil:Boolean = false
        
        protected var worldTransform:Matrix3D
        
        protected var vertBuf:VertexBuffer3D
        protected var idxBuf:IndexBuffer3D
        
        protected var vertShaderAsm:AGALMiniAssembler
        protected var fragShaderAsm:AGALMiniAssembler
        protected var program:Program3D
        
        public function Study_Base(document:Sprite, context:Context3D) 
        {
            this.document = document
            stage = document.stage
            this.context = context
            
            stage.addEventListener("resize", resize)
            
            setupContext()
            readyResource()
            //render()
        }
        
        protected function resize(e:Event = null):void {
            setupContext()
        }
        
        protected function setupContext():void {
            context.configureBackBuffer(stage.stageWidth, stage.stageHeight, 4, false)
            context.setCulling(Context3DTriangleFace.BACK)
            program = context.createProgram()
            vertShaderAsm = new AGALMiniAssembler
            fragShaderAsm = new AGALMiniAssembler
            worldTransform = new Matrix3D
            worldTransform.identity()
        }
        
        protected function readyResource():void {
            //
        }
        
        protected function render():void {
            //
        }
        
        // 셰이더 코드에 \n + 붙이기 귀찮아서
        protected function unify(...commands):String {
            var str:String = ""
            for each(var cmd:String in commands) {
                str += cmd + "\n"
            }
            return str.substr(0, str.length - 1)
        }
        
    }

//}

//package {
    import flash.events.Event;
    import flash.utils.ByteArray;
    import flash.geom.Matrix;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite
    import flash.display3D.Context3D
    import flash.display3D.VertexBuffer3D;
    import flash.display3D.textures.Texture;
    
    import com.adobe.utils.AGALMiniAssembler
    import com.bit101.components.Slider
    /**
     * ...
     * @author codeonwort
     */
    internal class Study04_GaussianBlur extends Study_Base
    {
        public function Study04_GaussianBlur(document:Sprite, context:Context3D) 
        {
            super(document, context)
            var L:Loader = new Loader
            L.load(new URLRequest("http://assets.wonderfl.net/images/related_images/d/d9/d9b9/d9b9e27367920f3ef42cc14e1155ec0f18908b3b"), new LoaderContext(true))
            L.contentLoaderInfo.addEventListener("complete", load_complete)
        }
        
        // constant register values for each gaussian blur strength
        private var coefficients:Vector.<Number>
        private var h_blur:ByteArray // horizontal gaussian blur
        private var v_blur:ByteArray // vertical gaussian blur
        private var simple_mov:ByteArray
        private var tex:Texture
        
        protected override function resize(e:Event = null):void {
            super.resize(e)
        }
        
        protected function load_complete(e:Event):void {
            // vertex stream
            var verts:Vector.<Number> = new Vector.<Number>
            verts.push( -1, -1, 0,
                        -1, 1, 0,
                        1, 1, 0,
                        1, -1, 0)
            vertBuf = context.createVertexBuffer(4, 3)
            vertBuf.uploadFromVector(verts, 0, 4)
            context.setVertexBufferAt(0, vertBuf, 0, "float3")
            
            // index stream
            var indices:Vector.<uint> = new Vector.<uint>
            indices.push(0, 1, 2,
                        2, 3, 0)
            idxBuf = context.createIndexBuffer(6)
            idxBuf.uploadFromVector(indices, 0, 6)
            
            // uv
            var uv:Vector.<Number> = new Vector.<Number>
            uv.push(0, 1,
                    0, 0,
                    1, 0,
                    1, 1)
            var uvBuf:VertexBuffer3D = context.createVertexBuffer(4, 2)
            uvBuf.uploadFromVector(uv, 0, 4)
            context.setVertexBufferAt(1, uvBuf, 0, "float2")
            
            // texture
            var info:LoaderInfo = e.target as LoaderInfo
            var img:Loader = info.loader
            var bd:BitmapData = new BitmapData(512, 512, false)
            var mat:Matrix = new Matrix
            mat.scale(bd.width / img.width, bd.height / img.height)
            try {
                bd.draw(img.content, mat)
            } catch(err:Error) {
                bd.perlinNoise(512, 512, 8, 12323, false, true)
            }
            tex = context.createTexture(512, 512, "bgra", true)
            tex.uploadFromBitmapData(bd)
            context.setTextureAt(0, tex)
            
            // vertex shader 정점 셰이더
            var vertShaderSrc:String = unify("m44 op, va0, vc0", "mov v0, va1")
            vertShaderAsm.assemble("vertex", vertShaderSrc)
            context.setProgramConstantsFromMatrix("vertex", 0, worldTransform)
                        
            // coefficients calculation
            coefficients = new Vector.<Number>
            var len:uint = 6
            var pascal_len:uint = len * 2
            var sum_coeffs:uint = Math.pow(4, len)
            for(var i:uint = 0 ; i <= len ; i++){
                coefficients.unshift(C(pascal_len, i) / sum_coeffs)
            }
            // coefficients.length = len + 1          
            
            function merge(opcode:String, coord:String, mul:String):String {
                return unify(opcode + " ft2." + coord + ", ft2." + coord + ", fc0." + coord,
                             "tex ft3, ft2.xy, fs0 <2d,clamp,linear>",
                             "mul ft3.xyz, ft3.xyz, " + mul,
                             "add ft1.xyz, ft1.xyz, ft3.xyz")
            }
            function gblur(dir:String, cnt:int):String {
                var s:String = "mov ft2.xy, ft0.xy"
                for(var i:int= 0 ; i < cnt ; i++){
                    s = unify(s, merge("sub", dir, reg("fc", i+3)))
                }
                s = unify(s, "mov ft2.xy, ft0.xy")
                for(i= 0 ; i < cnt ; i++){
                    s = unify(s, merge("add", dir, reg("fc", i+3)))
                }
                return s
            }
            
            var fragShaderSrc:String = unify(
                "mov ft0, v0",
                "tex ft1, ft0, fs0 <2d,clamp,linear>",
                "mul ft1.xyz, ft1.xyz, " + reg("fc", 2),
                gblur("x", len), "mov oc, ft1")
            fragShaderAsm.assemble("fragment", fragShaderSrc)
            h_blur = fragShaderAsm.agalcode
            
            fragShaderSrc = unify(
                "mov ft0, v0",
                "tex ft1, ft0, fs0 <2d,clamp,linear>",
                "mul ft1.xyz, ft1.xyz, " + reg("fc", 2),
                gblur("y", len), "mov oc, ft1")
            fragShaderAsm.assemble("fragment", fragShaderSrc)
            v_blur = fragShaderAsm.agalcode
            
            fragShaderSrc = "tex oc, v0, fs0 <2d,clamp,linear>"
            fragShaderAsm.assemble("fragment", fragShaderSrc)
            simple_mov = fragShaderAsm.agalcode
            
            // render
            var const_register:Vector.<Number> = new Vector.<Number>
            const_register.push(2 / 465, 2 / 465) // 512 : tex width, height
            const_register = const_register.concat(coefficients)
            
            // make const vector's length multiple of 4.
            var power2:int = 1
            while(power2 < const_register.length) power2 *= 2
            while(const_register.length < power2) const_register.push(0)
            
            context.setProgramConstantsFromVector("fragment", 0, const_register)
            render()
        }
        
        protected override function render():void {
            
            
            var temp:Texture = context.createTexture(512, 512, "bgra", true)
            
            //context.setBlendFactors("one", "zero")
            context.setRenderToTexture(temp)
            context.setTextureAt(0, tex)
            context.clear(0, 0, 0)
            program.upload(vertShaderAsm.agalcode, v_blur)
            context.setProgram(program)
            context.drawTriangles(idxBuf, 0, 2)
            
            context.setRenderToBackBuffer()
            context.clear(0, 0, 0)
            context.setTextureAt(0, temp)
            //context.setBlendFactors("oneMinusDestinationAlpha", "destinationAlpha")
            program.upload(vertShaderAsm.agalcode, h_blur)
            //context.setProgram(program)
            context.drawTriangles(idxBuf, 0, 2)
            
            context.present()
        }
        
    }

//}

// calculate combination
function C(n:uint, k:uint):uint {
    return factorial(n) / factorial(k) / factorial(n-k)
}
function factorial(n:uint):uint {
    if(n == 0) return 1
    var cnt:uint = n
    while(cnt --> 1) n *= cnt
    return n
}

var xyzw:Array = ["x", "y", "z", "w"]
function reg(register:String, index:uint):String {
    return register + uint(index/4) + "." + xyzw[index % 4] + String(xyzw[index % 4]) + xyzw[index % 4]
}