/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a9Ib
 */

//
//	キラキラ
//
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	
	/**
	 * ...
	 * @author okoi
	 */
	public class Main extends Sprite 
	{
		private static const STAR_NUM:int = 300;
		private var stars:Array = new Array();
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			
			var i:uint = 0;
			for ( i = 0; i < STAR_NUM; i++ )
			{
				var x:Number = Math.random() * stage.stageWidth;
				var y:Number = Math.random() * stage.stageHeight;
				stars.push( new Star(x, y) );
			}
			
			addEventListener( Event.ENTER_FRAME, EnterFrame );
		}
		
		private function EnterFrame(e:Event):void 
		{
			var i:uint = 0;
			for ( i = 0; i < STAR_NUM; i++ )
			{
				stars[i].Update(stage);
			}
			
			graphics.clear();
			graphics.beginFill( 0x000000 );
			graphics.drawRect( 0, 0, stage.stageWidth, stage.stageHeight );
			graphics.endFill();
			
			for ( i = 0; i < STAR_NUM; i++ )
			{
				var s:Star = stars[i];
				s.Draw(graphics);
			}
		}
		
	}
	
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
import flash.display.Graphics;
import flash.display.Stage;

class Star {
	
	public var posX:Number;
	public var posY:Number;
	public var moveX:Number;
	public var moveY:Number;
	public var alpha:Number;
	
	public var step:int;
	public var steps:int;
	
	public	var size:int;
	
	public	function Star(_x:Number, _y:Number) {
		Init(_x, _y);
	}
	
	public	function Init(_x:Number, _y:Number):void 
	{
		var angle:Number = Math.random() * 360;
		var speed:Number = Math.random() + 0.1;
		
		posX = _x;
		posY = _y;
		moveX = Math.cos( angle * Math.PI / 180.0 ) * speed;
		moveY = Math.sin( angle * Math.PI / 180.0 ) * speed;
		
		step = int(Math.random() * 360);
		steps = int(Math.random() * 10) + 1;
		alpha = (Math.sin( step * Math.PI / 180 ) + 1) / 2;
		
		size = Math.random()*1.5 + 1;
	}
	
	public	function Update(stage:Stage):void 
	{
		alpha = (Math.sin( step * Math.PI / 180 ) + 1) / 2;	
		step = (step + steps) % 360;
		
		posX += moveX;
		posY += moveY;
		if ( posX < 0 )	posX = stage.stageWidth;
		if ( posX > stage.stageWidth ) posX = 0;
		if ( posY < 0 ) posY = stage.stageHeight;
		if ( posY > stage.stageHeight ) posY = 0;
	}
	
	public	function Draw(g:Graphics):void
	{
		g.beginFill( 0xFFFFFF, alpha );
		g.drawCircle( posX, posY, size );
		g.endFill();
	}
}


