/**
 * Copyright glasses_factory ( http://wonderfl.net/user/glasses_factory )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a90q
 */

package
{
    import alternativ7.engine3d.containers.BSPContainer;
    import alternativ7.engine3d.containers.ConflictContainer;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.objects.BSP;
    import alternativ7.engine3d.primitives.Box;
    import alternativ7.engine3d.primitives.Plane;
    
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Vector3D;
    
    import jiglib.geometry.JBox;
    import jiglib.geometry.JSphere;
    import jiglib.physics.RigidBody;
    
    [SWF(backgroundColor=0)]
    public class Alt3DJiglib extends Sprite
    {
        /*/////////////////////////////////
        * public variables
        /*/////////////////////////////////
        
        //オブジェクトを突っ込むコンテナ
        public var container:ConflictContainer;
        //ビュー
        public var view:View;
        
        public var camera:Camera3D;
        
        public var cameraController:SimpleObjectController;
        
        public var isRendering:Boolean = false;
        
        
        /*/////////////////////////////////
        * public methods
        /*/////////////////////////////////
        
        //Constractor
        public function Alt3DJiglib()
        {
            if( stage ){ _init(); }
            else{ addEventListener( Event.ADDED_TO_STAGE, _init ); }
        }
        
        
        /*/////////////////////////////////
        * private methods
        /*/////////////////////////////////
        
        protected function _init( e:Event = null ):void
        {
            removeEventListener( Event.ADDED_TO_STAGE, _init );
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            container = new ConflictContainer();
            view = new View( stage.stageWidth, stage.stageHeight );
            addChild( view );
            
            camera = new Camera3D();
            camera.view = view;
            container.addChild( camera );
            
            camera.x = 0;
            camera.y = -500;
            camera.z = 0;
            
            _canvas = new MovieClip();
            _canvas.visible = false;
            addChild( _canvas );
            
            _root = new Object3DContainer();
            _cc = new BSPContainer();
            _root.addChild( _cc );
            _cc.mouseChildren = false;
            _physics = new Alt3dPhysics( _cc, 8 );
            
            var material:FillMaterial = new FillMaterial( 0, 0, 1, 0xffffff );
            
            _spheres = new Vector.<RigidBody>(30);
            for( var i:int = 0; i < 30; i++ )
            {
                var rSphere:RigidBody = _physics.createSphere( Math.random() * 10 + 10, material, 6, 6 );
                rSphere.mass = Math.random() * 2;
                rSphere.friction = 1;
                rSphere.restitution = 0.5;
                rSphere.y = Math.random() * 10 - 10;
                rSphere.x = Math.random() * 50 - 50;
                rSphere.z = Math.random() * 50 - 50;
                _spheres[i] =  rSphere;
            }
            
            
            var planeMat:FillMaterial = new FillMaterial( 0, 0, 1, 0x444444 );
            var plane:Plane = new Plane( 400, 400, 10, 10, true, false, true );
            plane.setMaterialToAllFaces( planeMat );
            for (i = 0; i < plane.vertices.length; i++ )
            {
                plane.vertices[i].x += Math.random() * 5 - 2.5;
                plane.vertices[i].z = Math.random() * 60 * -1;
            }
            var ground:RigidBody = _physics.createMesh( plane, 400, 1, 400 );
            ground.movable = false;
            ground.friction = 0.1;
            ground.restitution = 0.8;
            ground.rotationX = 90;
            ground.y = -100;
            container.addChild( _root );        
            
            
            cameraController = new SimpleObjectController( stage, camera, 10 );
            cameraController.mouseSensitivity = 1;
            cameraController.unbindAll();
            cameraController.lookAtXYZ( 0, 0, 0 );
            
            _root.rotationY = -60;
            cameraController.setObjectPosXYZ( -0, 50, -200 );
            cameraController.lookAtXYZ( 0, 0, 0 );
            cameraController.mouseSensitivity = 0;
            
            _objectController = new SimpleObjectController( stage, _root, 20, 4 );
            _objectController.mouseSensitivity = 1;
            _objectController.unbindAll();
            
            startRender();
        }
        
        
        public function startRender():void
        {
            isRendering = true;
            addEventListener( Event.ENTER_FRAME, _enterFrameHandler );
        }
        
        
        public function stopRender():void
        {
            removeEventListener( Event.ENTER_FRAME, _enterFrameHandler );
            isRendering = false;
        }
        
        public function update():void
        {
            _physics.engine.integrate( 0.4 );
            cameraController.update();
            _objectController.update();
            camera.render();
            
            for (var i:int = 0; i < _spheres.length; i++ )
            {
                if( _spheres[i].y < -5000 )
                {
                    _spheres[i].y = 100;
                    _spheres[i].x = Math.random() * 20 - 20;
                    _spheres[i].z = Math.random() * 20 - 20;
                }
            }
        }
        
        protected function _enterFrameHandler( e:Event ):void
        {
            update();
        }
        
        
        /*/////////////////////////////////
        * private variables
        /*/////////////////////////////////
        
        private var _root:Object3DContainer;
        private var _cc:BSPContainer;
        private var _box:Box;
        private var _objectController:SimpleObjectController;
        private var _spheres:Vector.<RigidBody>;
        private var _canvas:MovieClip;
        private var _physics:Alt3dPhysics;
        private var _lookAtVect:Vector3D = new Vector3D();
        
    }
}

/*
ここで紹介してるやつをちょいいじった
http://flastar.ru/blog/flastarposts/778
*/

import alternativ7.engine3d.core.Object3DContainer;
import alternativ7.engine3d.materials.Material;
import alternativ7.engine3d.objects.Mesh;
import alternativ7.engine3d.primitives.Box;
import alternativ7.engine3d.primitives.Plane;
import alternativ7.engine3d.primitives.Sphere;

import jiglib.geometry.*;
import jiglib.math.JMatrix3D;
import jiglib.physics.RigidBody;
import jiglib.plugin.AbstractPhysics;


class Alt3dPhysics extends AbstractPhysics
{
    
    public var rootContainer:Object3DContainer
    
    //Constractor
    public function Alt3dPhysics( container:Object3DContainer, speed:Number = 1 )
    {
        super( speed );
        rootContainer = container;
    }
    
    public function getMesh( body:RigidBody ):Mesh
    {
        if( body.skin != null )
        {
            return ( body.skin as Alt3dMesh ).mesh;
        }
        else
        {
            return null;
        }
    }
    
    
    public function createSphere( radius:Number, material:Material, radialSegments:uint = 8, heightSegments:uint = 8, reverse:Boolean = false ):RigidBody
    {
        var sphere:Sphere = new Sphere( radius, radialSegments, heightSegments, reverse );
        sphere.setMaterialToAllFaces( material );
        rootContainer.addChild( sphere );
        
        var jSphere:JSphere = new JSphere( new Alt3dMesh( sphere ), radius );
        addBody( jSphere );
        return jSphere;
    }
    
    public function createGround( width:Number, height:Number, material:Material, widthSegments:uint = 1, lengthSegments:uint = 1,
                                  twoSided:Boolean = false, reverse:Boolean = false, triangulate:Boolean = false):RigidBody
    {
        var plane:Plane = new Plane( width, height, widthSegments, lengthSegments, twoSided, reverse, triangulate, material, material );
        rootContainer.addChild( plane );
        
        var jPlane:JPlane = new JPlane( new Alt3dMesh(plane));
        jPlane.setOrientation(JMatrix3D.getRotationMatrixAxis(90));
        addBody( jPlane );
        return jPlane;
    }
    
    public function createBox( width:Number, length:Number, height:Number, material:Material, widthSegments:uint = 1, lengthSegments:uint = 1, heightSegments:uint = 1,
                               reverse:Boolean = false, triangulate:Boolean = false ):RigidBody
    {
        var cube:Box = new Box( width, length, height, widthSegments, lengthSegments, heightSegments, reverse, triangulate );
        cube.setMaterialToAllFaces( material );
        rootContainer.addChild( cube );
        
        var jBox:JBox = new JBox( new Alt3dMesh( cube ), width, length, height );
        addBody( jBox );
        return jBox;
    }
    
    public function createMesh( mesh:Mesh, w:Number, l:Number, h:Number ):RigidBody
    {
        rootContainer.addChild( mesh );
        var jBox:JBox = new JBox( new Alt3dMesh( mesh ), w, l, h );
        addBody( jBox );
        return jBox;
    }
}


import alternativ7.engine3d.objects.Mesh;

import flash.geom.Matrix3D;

import jiglib.plugin.ISkin3D;

class Alt3dMesh implements ISkin3D
{
    
    public function get transform():Matrix3D{ return _mesh.matrix; }
    public function set transform( matrix:Matrix3D ):void{ _mesh.matrix = matrix.clone(); }
    
    public function get mesh():Mesh{ return _mesh; }
    private var _mesh:Mesh;
    
    
    //Constractor
    public function Alt3dMesh( inputMesh:Mesh )
    {
        _mesh = inputMesh;
    }
}
