/**
 * Copyright tananuka13 ( http://wonderfl.net/user/tananuka13 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a8yO
 */

// forked from nutsu's 多脚戦車（絵だけ)
// forked from 9re's Wonderfl Tank Game Tank Sample 1
// このコードを新着タンク一覧http://flash-games.wonderfl.net/tank/list/new
// に表示させるにはinfinite-tank-entry
// というタグをつけてください
package 
{    
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.system.Security;
    import flash.utils.getTimer;
    
    import net.wonderfl.game.infinity_tank.development.*;
    import net.wonderfl.math.WVector2D;
    import net.wonderfl.utils.SequentialLoader;
    /**
     * @author 9re
     */
    // クラス名は必ずTankにして、TankBaseクラスを拡張して下さい
    // http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/tank/TankBase.html
    public class Tank extends TankBase
    {
        private var _spTank:Sprite;
        private var _spBody:Sprite;
        private var _spBattery:Sprite;
        private var _parts:Array;
        private var mtx:Matrix;
        private var ctfm:ColorTransform;
        private var _arr:Array = [];
        private var time0:int;
        private var dgc:Graphics;
        
        public function Tank() 
        {
            _bulletRenderer = "http://swf.wonderfl.net/swf/usercode/b/bb/bb20/bb20d8176f27b9afc27c15abad377a8aeb94c043.swf";
            
            _spBody = new Sprite();
            dgc = _spBody.graphics;
            
            _spBattery = new Sprite();
            _spBattery.x = _spBattery.y = 0;
            _spBattery.scaleX = _spBattery.scaleY = 60/465;
            
            _spTank = new Sprite();
            _spTank.addChild( _spBody );
            _spTank.addChild( _spBattery );
            
            SequentialLoader.loadImages([ "http://assets.wonderfl.net/images/related_images/4/44/444c/444c3ebf8617a1eefc106659160132a5e307a33a"], _arr, onImageLoaded);
        }
        
        private function onImageLoaded():void
        {
            var _images:Vector.<Bitmap> = Vector.<Bitmap>(_arr.map(function ($ldr:Loader, $index:int, $arr:Array):Bitmap {
                //var mat:Matrix = new Matrix;
                var bd:BitmapData = new BitmapData($ldr.width, $ldr.height, true, 0x00ffffff);
                bd.draw($ldr);
                var bm:Bitmap = new Bitmap(bd);
                return bm;
            }));
            
            var srcbd:BitmapData = Bitmap(_images.pop()).bitmapData;
            var bodyBmp:BitmapData = new BitmapData( 465, 465, true, 0 );
            var legBmp:BitmapData  = new BitmapData( 60, 165, true, 0 );
            bodyBmp.copyPixels( srcbd, new Rectangle( 0, 0, 465, 465 ), bodyBmp.rect.topLeft );
            legBmp.copyPixels( srcbd, new Rectangle( 465, 0, 525, 165 ), legBmp.rect.topLeft );
            srcbd.dispose();
            
            _parts = [];
            _parts.push( _spBattery.addChild( new Bitmap( legBmp, "auto", true ) ) );
            _parts.push( _spBattery.addChild( new Bitmap( legBmp, "auto", true ) ) );
            _parts.push( _spBattery.addChild( new Bitmap( legBmp, "auto", true ) ) );
            _parts.push( _spBattery.addChild( new Bitmap( legBmp, "auto", true ) ) );
            _parts.push( _spBattery.addChild( new Bitmap( bodyBmp, "auto", true ) ) );
            
            mtx = new Matrix();
            ctfm = new ColorTransform( 1, 1, 1, 0);
            updateImage();
            
            time0 = -1;
        }
        
        //--------------------------------------------------
        
        private var mm:Matrix = new Matrix();
        private var mf:int = -1;
        
        private var mvx:Number = 0;
        private var mvy:Number = 0;
        private var ma:Number  = 0;
        private var mga:Number = 0;
        
        private var evx:Number = 0;
        private var evy:Number = 0;
        
        private var moveflg:int = 0;
        
        //お試し中
        override public function action():int
        {
            if( time0 < 0 ){
                time0 = getTimer();
            }
           
            
            var action:int = 0;
            
            //
            var e:WVector2D  = _scene.enemyTankPosition;
            var ev:WVector2D = _scene.enemyTankLinearVelocity;
            var ea:Number    = _scene.enemyTankAngularVelocity;
            var m:WVector2D  = _scene.myTankPosition;
            var mv:WVector2D = _scene.myTankLinearVelocity;
            var gvx:Number   = Math.cos( _scene.myGunAngle );
            var gvy:Number   = Math.sin( _scene.myGunAngle );
            var tvx:Number   = Math.cos( _scene.myTankAngle );
            var tvy:Number   = Math.sin( _scene.myTankAngle );
            
            mm.identity();
            mm.rotate( _scene.myTankAngle );
            mm.translate( m.x, m.y );
            mm.invert();
         
         
            //
            var dx:Number = mm.a * e.x + mm.c * e.y + mm.tx;
            var dy:Number = mm.b * e.x + mm.d * e.y + mm.ty;
            var d:Number  = Math.sqrt( dx*dx + dy*dy );
            
            var t:Number  = d/50;
            if( t>5 ) t = 5;
            var evx0:Number = ev.x*Math.cos(ea) - ev.y*Math.sin(ea);
            var evy0:Number = ev.x*Math.sin(ea) + ev.y*Math.cos(ea);
            evx += (evx0-evx)*0.5;
            evy += (evy0-evy)*0.5;
            var ex1:Number = e.x + evx;
            var ey1:Number = e.y + evy;
            var ex2:Number = e.x + evx*t;
            var ey2:Number = e.y + evy*t;
            var dx1:Number = mm.a * ex1 + mm.c * ey1 + mm.tx;
            var dy1:Number = mm.b * ex1 + mm.d * ey1 + mm.ty;
            var dx2:Number = mm.a * ex2 + mm.c * ey2 + mm.tx;
            var dy2:Number = mm.b * ex2 + mm.d * ey2 + mm.ty;
            
            if( t<1 ){
                dx1 = dx;
                dy1 = dy;
            }
            if( dx2*dx + dy2*dy < 0 ){
               dx2 = dx;
               dy2 = dy; 
            }
            
            var ga:Number = Math.atan2( dy1, dx1 );
            if( Math.abs(ga) < Math.PI/2.5 ){
                moveflg = 6; 
            }else if( moveflg<0 ){
                moveflg = 6;
            }else{
                moveflg--;
            }
            
            if( (getTimer()-time0>5000) && moveflg<=6 && (mv.x * dx1 + mv.y*dy1)<0 ){
                mf = ( dx1 > 0 ) ? -1 : 1;
                moveflg = 15;
            }
            
            var gad:Number = Math.PI/10;
            
            if( mf == 1 ){
                if( moveflg>0 ) action |= Command.TANK_MOVE_BACKWARD;
                if (ga > gad) action |= Command.TANK_TURN_LEFT;
                else if (ga < -gad) action |= Command.TANK_TURN_RIGHT;
            }else{
               if( moveflg>0 ) action |= Command.TANK_MOVE_FORWARD;
                if (ga < -gad) action |= Command.TANK_TURN_LEFT;
                else if (ga > gad) action |= Command.TANK_TURN_RIGHT;
            }
            
            
            //
            var d2:Number =  Math.sqrt( dx2*dx2 + dy2*dy2 );
            var crs:Number = gvx * dy2/d2 - gvy * dx2/d2;
            if ( crs > 0 ) {
                action |= Command.GUN_TURN_RIGHT;
            }else if ( crs < 0 ){
                action |= Command.GUN_TURN_LEFT;
            }
            
            if( (gvx * dx2/d2 + gvy * dy2/d2) > 0.6 ){
                action |= Command.FIRE;
            }
            
            //for view
            mvx += ( mv.x - mvx )*0.5;
            mvy += ( mv.y - mvy )*0.5;
            ma  = _scene.enemyTankAngularVelocity;
            
            //*
             dgc.clear();
            dgc.lineStyle( 0, 0xffffff, 0.2 );
            //dgc.moveTo(0,0);
            //dgc.lineTo( dx1, dy1 );
            dgc.drawRect( -40, -20, 80, 40 );
            dgc.moveTo( 40, 0 );
            dgc.lineTo( 30, 0 );
            //*/
            
            return action;
        }
        
        override public function draw(bitmapData:BitmapData):void
        {
            mga = _scene.myGunAngle;
           updateImage( mvx, mvy, ma/4 , mga, _scene.myTankAngle );
            if( _hit_flg> 0 ){
                _cf = ( (int(_hit_flg/2)%2) > 0 ) ? _cf1 : _cf0;
                if( _hit_flg++ > 10 ){
                    _cf = _cf1;
                    _hit_flg = 0; 
                }
            }
            //
            _spTank.rotation = _scene.myTankAngle * 180/Math.PI;
            _spTank.x = _scene.myTankPosition.x;
            _spTank.y = _scene.myTankPosition.y;
            // update
            bitmapData.colorTransform(bitmapData.rect, ctfm);
            bitmapData.draw( _spTank, _spTank.transform.matrix, _cf, null, null, true );
        }
                
        private function updateImage( vx:Number = 0, vy:Number = 0, a:Number=0, ga:Number = 0, ba:Number=0 ):void {
            var lima:Number = Math.PI / 10;
            if ( a > lima )
                a = lima;
            else if ( a < -lima )
                a = -lima;
            var d:Number  = Math.sqrt( vx * vx + vy * vy );
            if ( d > 30 ) {
                vx *= 30 / d;
                vy *= 30 / d;
            }
            
            var s:Number = Math.sin(-ga-ba);
            var c:Number = Math.cos(-ga-ba);
            var ox:Number = vx*c - vy*s;
            var oy:Number = vx*s + vy*c;
            _fire_bounce = 0;
            
            s = Math.sin(a);
            c = Math.cos(a);            
            _parts[4].transform.matrix = bodymat( ox, oy, a );
            _parts[0].transform.matrix = legmat(  15*c - 50*s + ox,  15*s + 50*c + oy,  70,  200, 160);
            _parts[1].transform.matrix = legmat(  15*c + 50*s + ox,  15*s - 50*c + oy,  70, -200, 160, true);
            _parts[2].transform.matrix = legmat( -20*c - 46*s + ox, -20*s + 46*c + oy, -80,  200, 165);
            _parts[3].transform.matrix = legmat( -20*c + 46*s + ox, -20*s - 46*c + oy, -80, -200, 165, true);
            ga -= a;
            _spBattery.rotation = 180*ga/Math.PI;
        }
        
        private function bodymat( ox:Number=0, oy:Number=0, a:Number=0 ):Matrix {
            mtx.identity();
            mtx.translate( -465 / 2 - 30, -465 / 2 );
            mtx.rotate( a );
            mtx.translate( 20 + ox, oy );
            return mtx;
        }
        
        private function legmat( rx:Number, ry:Number, sx:Number, sy:Number, sd:Number, ref:Boolean=false ):Matrix {
            var mx:Number = sx - rx;
            var my:Number = sy - ry;
            var ms:Number = Math.sqrt( mx * mx + my * my ) / sd;
            mtx.identity();
            mtx.translate( -30, 0 );
            if( ref ){
                mtx.scale( -1, 1 );
            }
            mtx.scale( 1, ms );
            mtx.rotate( Math.atan2( my, mx )-Math.PI/2 );
            mtx.translate( 20 + rx, ry );
            return mtx;
        }
        
        private var _fire_bounce:Number = 0;
        private var _hit_flg:int = 0;
        private var _cf:ColorTransform;
        private var _cf0:ColorTransform = new ColorTransform(1,1,1,0.5);
        private var _cf1:ColorTransform = new ColorTransform(1,1,1,1);
        
        // called when a bullet hits this tank
        override public function hit():void {
            _hit_flg = 1;
        }
        
        override public function fire():void{
            _fire_bounce = 100;
        }

    }
}