/**
 * Copyright sugyan ( http://wonderfl.net/user/sugyan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a8lc
 */

// forked from sugyan's flash on 2010-1-21
/* マウスをゆっくり追従してくるサンプル */
package {
	import flash.events.Event;
	import flash.events.MouseEvent;
    import flash.display.Sprite;

    public class FlashTest extends Sprite {
        private var _circles:Array = [
            new MyCircle(10.0, 0.9),
            new MyCircle(7.5,  0.7),
            new MyCircle(5.0,  0.5),
            new MyCircle(2.5,  0.3),
        ];
        private var _targetX:Number;
        private var _targetY:Number;
        private var _easeRatio:Number = 0.2;
    	    
        public function FlashTest() {
        	    for each(var circle:MyCircle in _circles) {
                addChild(circle);
        	    }
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        private function onMouseMove(event:MouseEvent):void {
        	    _targetX = event.stageX;
        	    _targetY = event.stageY;
        }
        
        private function onFrame(event:Event):void {
        	    var dX:Number = _targetX - _circles[0].x;
        	    var dY:Number = _targetY - _circles[0].y;
        	    
        	    for (var i:Number = _circles.length - 1; i > 0; i--) {
        	        _circles[i].x = _circles[i - 1].x;
        	        _circles[i].y = _circles[i - 1].y;
        	    }
        	    _circles[0].x += dX * _easeRatio;
        	    _circles[0].y += dY * _easeRatio;
        }
    }
}


import flash.display.Sprite;

class MyCircle extends Sprite {
	public function MyCircle(radius:Number, alpha:Number) {
		this.alpha = alpha;
		graphics.beginFill(0xFF0000);
		graphics.drawCircle(0, 0, radius);
	}
}