/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a8Q6
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.utils.*;
    
    import com.flashdynamix.utils.*;
    import com.bit101.components.*;
    
    public class HigeWriter extends Sprite {
        private var _faceImage:DisplayObject;
        private var _canvas:Sprite;
        private var _hitArea:Sprite;
        private var _higePoints:Vector.<Hige> = new Vector.<Hige>();
        
        public var higeStrong:HUISlider;
        public var higeColor:ColorChooser;
        public var higeLength:HUISlider;
        public var higeVolume:HUISlider;
        
        public var btnUpload:PushButton;
        public var btnClear:PushButton;
        public var btnSave:PushButton;
        
        public function HigeWriter() {
            addEventListener( Event.ADDED_TO_STAGE, onInit );
        }
        
        private function onInit( e:Event ):void {
            removeEventListener( Event.ADDED_TO_STAGE, onInit );
            
            _canvas = new Sprite();
            addChild( _canvas );
            
            _hitArea = new Sprite();
            _hitArea.graphics.beginFill(0,0);
            _hitArea.graphics.drawRect( 0, 0, stage.stageWidth, stage.stageHeight );
            _hitArea.graphics.endFill();
            addChild( _hitArea );
            
            higeColor = new ColorChooser(this, 390, 10, 0xff0000);
            higeStrong = new HUISlider(this, 290, 30, "Strong");
            higeLength = new HUISlider(this, 290, 50, "Length");
            higeVolume = new HUISlider(this, 290, 70, "Volume");
            btnClear= new PushButton(this, 350, 100, "Clear", onClickClear );
            btnUpload= new PushButton(this, 10, 10, "Upload", onClickUpload );
            btnSave= new PushButton(this, 10, 40, "Save", onClickSave );
            
            //higeColor.usePopup = true;
            
            higeStrong.value = 1;
            higeVolume.value = 20;
            higeLength.value = 20;
            higeColor .value = 0x00;

            SWFProfiler.init( this );
             
            Wonderfl.capture_delay(2); 
                        
            _hitArea.addEventListener( MouseEvent.MOUSE_DOWN, onPress );
            addEventListener( Event.ENTER_FRAME, onUpdate );
        }
        
        private function onClickSave( e:Event ):void {
            var raw:BitmapData = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0xFFFFFF );
            if( _faceImage ) raw.draw( _faceImage );
            raw.draw( _canvas );
            
            var png:ByteArray = PNGEnc.encode(raw);
            var file:FileReference = new FileReference();
            file.save(png, 'hige.png');
            
            
            //Wonderfl.capture();
        }
        
        private function onClickClear(e:Event):void {
            _canvas.graphics.clear();
            _higePoints = new Vector.<Hige>();
        }
        
        private var _fileRef:FileReference;
        private var _fileFilters:Array= [new FileFilter("Images", "*.jpg;*.gif;*.png")];
        private function onClickUpload(e:Event):void {
            _fileRef = new FileReference();
            _fileRef.addEventListener( Event.SELECT, onSelect );
            _fileRef.browse(_fileFilters);
        }
        
        private function onSelect (e:Event):void {
            _fileRef.removeEventListener( Event.SELECT, onSelect );
            _fileRef.addEventListener( Event.COMPLETE, onLoadImage );
            _fileRef.load();
        }
        private function onLoadImage(e:Event):void {
            _fileRef.removeEventListener( Event.COMPLETE, onLoadImage );
            var loader:Loader= new Loader();
            loader.loadBytes( _fileRef.data);
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onLoaderComplete );
            
            _fileRef = null;
        }
        private function onLoaderComplete(e:Event):void {
            var loader:Loader = LoaderInfo( e.target ).loader;
            if( _faceImage != null ) removeChild( _faceImage );
            _faceImage = addChildAt( loader.content, 0 );
        }

        private function onPress( e:MouseEvent ) :void {
            _hitArea.addEventListener( MouseEvent.MOUSE_UP, onRelease );
            stage.addEventListener( Event.MOUSE_LEAVE, onRelease );
            addEventListener( Event.ENTER_FRAME, onMouseMove );
            _canvas.graphics.moveTo( mouseX, mouseY );
        }
        private function onRelease( e:MouseEvent ) :void {
            _hitArea.removeEventListener( MouseEvent.MOUSE_UP, onRelease );
            stage.removeEventListener( Event.MOUSE_LEAVE, onRelease );
            removeEventListener( Event.ENTER_FRAME, onMouseMove );
            
        }
        private function onMouseMove(e:Event):void {
            const RADIAN:Number = 2*Math.PI;
            var vol:int = Math.max( 1, higeVolume.value );
            for( var i:int = 0; i<vol; ++i ) {
                var angle:Number= Math.random()*RADIAN;
                addHige( mouseX+Math.cos(angle)*i, mouseY+Math.sin(angle)*i);
            }
        }
        private function addHige( higeX:Number, higeY:Number ):void {
            var p:Hige= new Hige( higeX, higeY, higeStrong.value, higeColor.value, higeLength.value );
            _higePoints.push( p );    
        }
        
        private function onUpdate(e:Event):void {
            _canvas.graphics.clear();
            for each( var p:Hige in _higePoints ) {
                if( p.update() ) {
                }
                p.draw( _canvas.graphics );
            }
        }
    }
}

import flash.display.*;
import flash.geom.*;
class Hige extends Point {
    private var _tracks:Vector.<Point> = new Vector.<Point>;
    public var life:int;
    public var weight:int;
    public var color:uint;
    public function Hige ( x:Number = 0, y:Number = 0, weight:int = 2, color:uint = 0x00, life:int = 20  ) {
        super( x, y );
        this.weight = weight;
        this.color= color;
        this.life = life;
        update();
    }
    public function draw( g:Graphics ) :void {
        g.moveTo( _tracks[0].x, _tracks[0].y );
        g.lineStyle( weight, color );
        for each( var p:Point in _tracks )
            g.lineTo( p.x, p.y );
    }
    public function update():Boolean {
        life--;
        if( life <= 0 ) return false;
        
        _tracks.push( this.clone() );
        x += Math.random()*2 -1;
        y += Math.random()* 2;
        return true;
    }
}


import flash.display.*;
import flash.utils.*;
import flash.system.*;

// http://www.5etdemi.com/blog/archives/2006/12/as3-png-encoder-faster-better/
// @see Saqoosha http://wonderfl.net/code/21cfc87e11ffb354562c393a6e55666d61e15bf6
class PNGEnc {
	
    public static function encode(img:BitmapData, type:uint = 0):ByteArray {
    	
        // Create output byte array
        var png:ByteArray = new ByteArray();
        // Write PNG signature
        png.writeUnsignedInt(0x89504e47);
        png.writeUnsignedInt(0x0D0A1A0A);
        // Build IHDR chunk
        var IHDR:ByteArray = new ByteArray();
        IHDR.writeInt(img.width);
        IHDR.writeInt(img.height);
        if(img.transparent || type == 0)
        {
        	IHDR.writeUnsignedInt(0x08060000); // 32bit RGBA
        }
        else
        {
        	IHDR.writeUnsignedInt(0x08020000); //24bit RGB
        }
        IHDR.writeByte(0);
        writeChunk(png,0x49484452,IHDR);
        // Build IDAT chunk
        var IDAT:ByteArray= new ByteArray();
        
        switch(type)
        {
        	case 0:
        		writeRaw(img, IDAT);
        		break;
        	case 1:
        		writeSub(img, IDAT);
        		break;
        }
        
        IDAT.compress();
        writeChunk(png,0x49444154,IDAT);
        // Build IEND chunk
        writeChunk(png,0x49454E44,null);
        // return PNG
        
        
        
        return png;
    }
    
    private static function writeRaw(img:BitmapData, IDAT:ByteArray):void
    {
        var h:int = img.height;
        var w:int = img.width;
        var transparent:Boolean = img.transparent;
        
        for(var i:int=0;i < h;i++) {
            // no filter
            if ( !transparent ) {
            	var subImage:ByteArray = img.getPixels(
            		new Rectangle(0, i, w, 1));
            	//Here we overwrite the alpha value of the first pixel
            	//to be the filter 0 flag
            	subImage[0] = 0;
				IDAT.writeBytes(subImage);
				//And we add a byte at the end to wrap the alpha values
				IDAT.writeByte(0xff);
            } else {
            	IDAT.writeByte(0);
            	var p:uint;
                for(var j:int=0;j < w;j++) {
                    p = img.getPixel32(j,i);
                    IDAT.writeUnsignedInt(
                        uint(((p&0xFFFFFF) << 8)|
                        (p>>>24)));
                }
            }
        }
    }
    
    private static function writeSub(img:BitmapData, IDAT:ByteArray):void
    {
        var r1:uint;
        var g1:uint;
        var b1:uint;
        var a1:uint;
        
        var r2:uint;
        var g2:uint;
        var b2:uint;
        var a2:uint;
        
        var r3:uint;
        var g3:uint;
        var b3:uint;
        var a3:uint;
        
        var p:uint;
        var h:int = img.height;
        var w:int = img.width;
        
        for(var i:int=0;i < h;i++) {
            // no filter
            IDAT.writeByte(1);
            if ( !img.transparent ) {
				r1 = 0;
				g1 = 0;
				b1 = 0;
				a1 = 0xff;
                for(var j:int=0;j < w;j++) {
                    p = img.getPixel(j,i);
                    
                    r2 = p >> 16 & 0xff;
                    g2 = p >> 8  & 0xff;
                    b2 = p & 0xff;
                    
                    r3 = (r2 - r1 + 256) & 0xff;
                    g3 = (g2 - g1 + 256) & 0xff;
                    b3 = (b2 - b1 + 256) & 0xff;
                    
                    IDAT.writeByte(r3);
                    IDAT.writeByte(g3);
                    IDAT.writeByte(b3);
                    
                    r1 = r2;
                    g1 = g2;
                    b1 = b2;
                    a1 = 0;
                }
            } else {
				r1 = 0;
				g1 = 0;
				b1 = 0;
				a1 = 0;
                for(j=0;j < w;j++) {
                    p = img.getPixel32(j,i);
                    
                    a2 = p >> 24 & 0xff;
                    r2 = p >> 16 & 0xff;
                    g2 = p >> 8  & 0xff;
                    b2 = p & 0xff;
                    
                    r3 = (r2 - r1 + 256) & 0xff;
                    g3 = (g2 - g1 + 256) & 0xff;
                    b3 = (b2 - b1 + 256) & 0xff;
                    a3 = (a2 - a1 + 256) & 0xff;
                    
                    IDAT.writeByte(r3);
                    IDAT.writeByte(g3);
                    IDAT.writeByte(b3);
                    IDAT.writeByte(a3);
                    
                    r1 = r2;
                    g1 = g2;
                    b1 = b2;
                    a1 = a2;
                }
            }
        }
    }

    private static var crcTable:Array;
    private static var crcTableComputed:Boolean = false;

    private static function writeChunk(png:ByteArray, 
            type:uint, data:ByteArray):void {
		var c:uint;
        if (!crcTableComputed) {
            crcTableComputed = true;
            crcTable = [];
            for (var n:uint = 0; n < 256; n++) {
                c = n;
                for (var k:uint = 0; k < 8; k++) {
                    if (c & 1) {
                        c = uint(uint(0xedb88320) ^ 
                            uint(c >>> 1));
                    } else {
                        c = uint(c >>> 1);
                    }
                }
                crcTable[n] = c;
            }
        }
        var len:uint = 0;
        if (data != null) {
            len = data.length;
        }
        png.writeUnsignedInt(len);
        var p:uint = png.position;
        png.writeUnsignedInt(type);
        if ( data != null ) {
            png.writeBytes(data);
        }
        var e:uint = png.position;
        png.position = p;
        c = 0xffffffff;
        for (var i:int = 0; i < (e-p); i++) {
            c = uint(crcTable[
                (c ^ png.readUnsignedByte()) & 
                0xff] ^ (c >>> 8));
        }
        c = uint(c^uint(0xffffffff));
        png.position = e;
        png.writeUnsignedInt(c);
    }
}
