/**
 * Copyright forresto ( http://wonderfl.net/user/forresto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a7YO
 */

/*
 *
 * Cross your eyes to make the two sides become one in 3D
 * http://tinyurl.com/wiggledlandscape if you can't see it cross-eyed
 * View full-screen for best effect.
 * Click to redraw
 *
 */

package {
    import frocessing.display.*;
    import flash.display.*;
    
    [SWF(backgroundColor=0x000000, frameRate="60")]
    public class SilkyLandscapeStereo3D extends F5MovieClip2DBmp
    {
        private var stage_width:Number;
        private var stage_height:Number;
        private var n:int    = 4;
        private var t:Number = 0;
        
        private var peakOffset:Number = 300;
        private var stereoOffset:Number = 50;
        private var rangeWidth:Number;
        
        private var scrollStart:Number = 50;
        private var scrollEnd:Number = stage_height + 20;
        private var position:Number = scrollStart;
        
        public function SilkyLandscapeStereo3D ()
        {
            super();
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
        }
        
        public function setup():void
        {
            stage_width = stage.stageWidth;
            stage_height = stage.stageHeight;
            
            rangeWidth = stage_width / 2 - stereoOffset;
            
            size( stage_width, stage_height );
            background( 0 );
        }
        
        public function draw():void
        {
            if( isMousePressed )
                position = scrollStart;
            
            translate( 0, position );
            position += .3;
            
            // 3D offset
            var offset:Number = stereoOffset * (stage_height-position) / stage_height;
            
            fill(0, 0, 0, 0.07);
                           
            beginShape();
            stroke( 0, 1 );
            vertex( 0, 0 );
            
            // Right Eye (left column)
            var rightStart:Number = stereoOffset - offset;
            vertex( rightStart, 0 );
            stroke( 255, 0.2 );
            for( var i:int=1; i<n; i++ ) {
                var xx:Number = rightStart + i * rangeWidth / n;
                var yy:Number = noise( i * 0.25, t ) * peakOffset - peakOffset/2;
                vertex( xx, yy );
            }
            vertex( rightStart+rangeWidth, 0 );
            
            stroke( 0, 1 );
            vertex( stage_width/2, 0 );

            // Left Eye (right column)
            var leftStart:Number = stage_width/2 + offset;
            vertex( leftStart, 0 );
            stroke( 255, 0.2 );
            for( var j:int=1; j<n; j++ ) {
                var xxx:Number = leftStart + j * rangeWidth / n;
                var yyy:Number = noise( j * 0.25, t ) * peakOffset - peakOffset/2;
                vertex( xxx, yyy );
            }
            vertex( leftStart+rangeWidth, 0 ); 

            stroke( 0, 0 );
            vertex( stage_width, 0 ); 

            // Fill
            vertex(stage_width, stage_height)
            vertex(0, stage_height)
            endShape();
            
            t+=0.01;
        }
    }
}