/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a7QI
 */

// forked from checkmate's fladdict challenge for professionals
// 2009/07/22 createPattern() メソッドにおいて、変数 color が適正化されていなかったのを修正
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.utils.ByteArray;
    
    
    public class Professional extends Sprite {
        private var color1:uint = 0xFF000000;
        private var color2:uint = 0xFFFFFFFF;
        private var bitmapDataVector:Vector.<BitmapData>;

        private const ATOM_WIDTH:uint  = 4;
        private const ATOM_HEIGHT:uint = 6;

        private const PATTERN_WIDTH:uint  = 480 / 2;
        private const PATTERN_HEIGHT:uint = 480 / 2;
        private var patternFieldBitmapData:BitmapData = new BitmapData(PATTERN_WIDTH, PATTERN_HEIGHT, false, 0xFFFFFFFF);

        private const NOISE_WIDTH:uint  = PATTERN_WIDTH  / ATOM_WIDTH;
        private const NOISE_HEIGHT:uint = PATTERN_HEIGHT / ATOM_HEIGHT;
        private var noiseFieldBitmapData:BitmapData;
        private var noiseFieldBitmap:Bitmap;

        private var octaves:uint;
        private var seed:Number;
        private var channels:uint;
        private var offset:Array;
        private var offsetX:Vector.<Number>;
        private var offsetY:Vector.<Number>;
        private var channelCnt:uint = 1;

        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            createNoiseField();

            noiseFieldBitmap = new Bitmap(noiseFieldBitmapData);
            noiseFieldBitmap.width  = PATTERN_WIDTH;
            noiseFieldBitmap.height = PATTERN_HEIGHT;
            addChild(noiseFieldBitmap);

            stage.addEventListener(MouseEvent.CLICK, clickHandler);
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function clickHandler(event:MouseEvent):void {
            createNoiseField();
            noiseFieldBitmap.bitmapData = noiseFieldBitmapData;
        }
        private function enterFrameHandler(e:Event):void {
            for (var i:int = 0; i < octaves; i++) {
                offset[i].x += offsetX[i];
                offset[i].y += offsetY[i];
            }
            noiseFieldBitmapData.perlinNoise(NOISE_WIDTH, NOISE_HEIGHT, octaves, seed, true, true, channels, false, offset);

            createPattern();
            patternFieldDraw();
        }
		
        private function createNoiseField():void {
            octaves = 2;
            seed = Math.floor(Math.random() * 0xFFFF);
            //channels = BitmapDataChannel.RED | BitmapDataChannel.GREEN | BitmapDataChannel.BLUE;
            channels = channelCnt;
            channelCnt %= 7;
            channelCnt++;
            offset = new Array();
            offsetX = new Vector.<Number>();
            offsetY = new Vector.<Number>();
            var dist:uint  = 3;
            for (var i:int = 0; i < octaves; i++) {
                offset[i] = new Point(Math.random()*NOISE_WIDTH, Math.random()*NOISE_HEIGHT);
                offsetX[i] = Math.random() * dist - dist / 2;
                offsetY[i] = Math.random() * dist - dist / 2;
            }
            noiseFieldBitmapData = new BitmapData(NOISE_WIDTH, NOISE_HEIGHT, false);
        }
		
        private function createPattern():void {
            bitmapDataVector = new Vector.<BitmapData>();
            var byteArray:ByteArray = noiseFieldBitmapData.getPixels(noiseFieldBitmapData.rect);
            byteArray.position = 0;
            var len:uint = byteArray.length;
            while (byteArray.position < len) {
                var color:uint = byteArray.readUnsignedInt();
                color &= 0xFFFFFF;
                bitmapDataVector.push(createPatternBitmapData(color.toString(16)));
            }
        }

        private function createPatternBitmapData(hexStr:String):BitmapData {
            var pattern:Array = [[0, 0, 0, 0],
                                 [0, 0, 0, 0],
                                 [0, 0, 0, 0],
                                 [0, 0, 0, 0],
                                 [0, 0, 0, 0],
                                 [0, 0, 0, 0]];
            var h:uint = ATOM_HEIGHT;
            for (var i:uint = 0; i < h; i++) {
                var bit:int = parseInt(hexStr.substr(i, 1), 16);
                var w:int = ATOM_WIDTH;
                while (bit >>= 1) {
                    pattern[i][--w] = bit & 1;
                }
            }
	
            return BitmapPatternBuilder.build(pattern, [color1, color2]);
        }
		
        private function patternFieldDraw():void{
            var w:uint = NOISE_WIDTH;
            var h:uint = NOISE_HEIGHT;
            var c:uint = 0;
            for (var i:uint = 0; i < h; i++) {
                for (var j:uint = 0; j < w; j++) {
                    patternFieldBitmapData.copyPixels(
                        bitmapDataVector[c++],
                        bitmapDataVector[0].rect,
                        new Point(j * ATOM_WIDTH, i * ATOM_HEIGHT)
                    );
                }
            }
			
            graphics.clear();
            graphics.beginBitmapFill(patternFieldBitmapData);// , new Matrix(2, 0, 0, 2, 0, 0));
            graphics.drawRect(0, 0, 480, 480);
            graphics.endFill();
        }
        
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}