/**
 * Copyright naoto5959 ( http://wonderfl.net/user/naoto5959 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a6S8
 */

package  
{
    import com.bit101.components.PushButton;
    import com.bit101.components.Text;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    import net.user1.logger.LogEvent;
    import net.user1.logger.Logger;
    import net.user1.reactor.IClient;
    import net.user1.reactor.Reactor;
    import net.user1.reactor.ReactorEvent;
    import net.user1.reactor.Room;
    import net.user1.reactor.RoomEvent;
    import net.user1.reactor.RoomModules;
    import net.user1.reactor.RoomModuleType;
    /**
     * locahostのUnion Server経由でtwitterに投稿してみる
     * http://fla.la/archives/369
     * の記事と連動しています。
     * @author naoto koshikawa
     */
    public class TryUnion4 extends Sprite
    {
        //----------------------------------------------------------------------
        //  properties
        //----------------------------------------------------------------------
        //------------------------------
        //  private properties
        //------------------------------
        /**
         * Reactorインスタンス
         */
        private var _reactor:Reactor;
        
        /**
         * Roomインスタンス
         */
        private var _room:Room;
        
        /**
         * Loggerインスタンス
         */
        private var _logger:Logger;
        
        /**
         * Log表示用TextField
         */
        private var _logField:TextField;
        
        /**
         * twit用TextField
         */
        private var _twitField:TextField;
        
        /**
         * twit用button
         */
        private var _twitButton:PushButton;
        
        //----------------------------------------------------------------------
        //  methods
        //----------------------------------------------------------------------
        //------------------------------
        //  public methods
        //------------------------------
        /**
         * constructor
         */
        public function TryUnion4() 
        {
            // ログ表示用TextFieldを作成します。
            _logField = new TextField();
            _logField.defaultTextFormat = new TextFormat("_等幅", 10);
            _logField.border = true;
            _logField.width = 463;
            _logField.height = 440;
            _logField.x = 1;
            _logField.y = 1;
            _logField.multiline = true;
            _logField.wordWrap = true;
            addChild(_logField);
            
            // twit用TextFieldを作成します。
            _twitField = new TextField();
            _twitField.type= TextFieldType.INPUT;
            _twitField.defaultTextFormat = new TextFormat("_等幅", 10);
            _twitField.border = true;
            _twitField.maxChars = 140;
            _twitField.height = 15;
            _twitField.width = 365;
            _twitField.x = 1;
            _twitField.y = 445;
            addChild(_twitField);
            
            // twitボタンを作成します。
            _twitButton = new PushButton(this, 370, 445, "twit");
            _twitButton.setSize(95, 15);
            
            // Reactorインスタンスを生成します。
            _reactor = new Reactor();
            _reactor.addEventListener(ReactorEvent.READY, _reactor_readyHandler);
            
            // Loggerインスタンスの参照を取得します。
            _logger = _reactor.getLog();
            _logger.addEventListener(LogEvent.UPDATE, _logger_updateHandler);
            
            // localhostのUnion Serverへ接続します。
            _reactor.connect("localhost", 9100);
        }
        
        /**
         * log Fieldにテキストを追加します。
         * @param    text
         * @param    color
         */
        private function appendText(text:String, color:uint = 0x000000):void
        {
            _logField.htmlText +=
                '<font color="#' + color.toString(16) + '" >' + text + '</font><br />';
            _logField.scrollV = _logField.maxScrollV;
        }
        
        //----------------------------------------------------------------------
        //  event handler
        //----------------------------------------------------------------------
        /**
         * ReactorEvent.Ready
         * @param    event
         */
        private function _reactor_readyHandler(event:ReactorEvent):void
        {
            // Room モジュールを指定します。
            var modules:RoomModules = new RoomModules();
            modules.addModule(
                "com.asmple.server.union.module.room.TwitModuleSample",
                RoomModuleType.CLASS);
            
            // Room モジュールを指定しながらRoomを生成します。
            _room = _reactor.getRoomManager().createRoom(
                "twitRoom", null, null, modules
             );
            _room.addEventListener(RoomEvent.JOIN, _room_joinHandler);
            
            // ServerからのMessageを監視します。
            _room.addMessageListener("response", _room_responseMessageHandler);
            
            // Roomにjoinします。
            _room.join();
        }
        
        /**
         * RoomEvent.JOIN
         * @param    event
         */
        private function _room_joinHandler(event:RoomEvent):void
        {
            // twitボタンのクリックイベントを監視します。
            _twitButton.addEventListener(
                MouseEvent.CLICK, _twitButton_clickHandler);
        }
        
        /**
         * response Messageを受信した際に実行されるハンドラ
         * @param    fromClient
         * @param    message
         */
        private function _room_responseMessageHandler(
                fromClient:IClient, result:String, message:String):void
        {
            if (result == "ok")
            {
                message = '<a href="' + message + '">' + message + '</a>';
                appendText(message, 0x0000FF);
            }
            else if (result == "ng")
            {
                appendText(message, 0xFF0000);
            }
        }
        /**
         * MouseEvent.CLICK
         * @param    event
         */
        private function _twitButton_clickHandler(event:MouseEvent):void
        {
            var message:String = _twitField.text;
            if (message.length == 0) return;
            
            message = encodeURI(message);
            _room.sendModuleMessage(
                "twit",
                { text:message }
            );
            
            _twitField.text = "";
        }
         
        /**
         * LogEvent.UPDATE
         * @param    event
         */
        private function _logger_updateHandler(event:LogEvent):void
        {
            appendText("[" + event.getLevel() + "]" + event.getMessage()); 
        }
    }
}