/**
 * Copyright MixedMilkChOcOlate ( http://wonderfl.net/user/MixedMilkChOcOlate )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a5dW
 */

package {
    import flash.display.Sprite;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.*;
    import flash.display.BitmapData;
    import flash.filters.ColorMatrixFilter;    
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.utils.getTimer;
    import flash.ui.Mouse;
    
    [SWF(frameRate="24", backgroundColor="#000000")]
    
    public class FlashTest extends Sprite {
   
        private var blur:BlurFilter;
        private var container:Sprite;
        private var source:Sprite;
        private var bmpd:BitmapData;
        private var cmf:ColorMatrixFilter;

        public function FlashTest() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.HIGH;            
            init();
                
            addEventListener(Event.ENTER_FRAME, update);
            Mouse.hide();
        }
        
        private function init():void
        {
            //creat a blur
            blur = new BlurFilter(10, 10);
            blur.quality = 3;
            // creat a bitmapData          
            bmpd = new BitmapData(500, 500, true, 0xFF00FF);
            
            container = new Sprite();
            source = new Sprite();
            addChild(new Bitmap(bmpd));
            container.addChild(source);
            with(source.graphics)
            {
                beginFill(0xFF00FF);
                // position X, position Y, widht/height
                drawCircle(0,0,30);
                endFill();
            }
            
            // init timer for color filter
            var colorTimer:Timer = new Timer(250, 0);
            colorTimer.addEventListener(TimerEvent.TIMER, colorTimerEvent);
            colorTimer.start();           
        }
        
        private function colorTimerEvent(event:TimerEvent):void {
            var r:Number = Math.random();
            var rFinal:Number = Math.random() * 255;
            var rFinal2:Number = Math.random() * 255 - rFinal;
            
            var g:Number = Math.random();
            var gFinal:Number = Math.random() * 255;
            var gFinal2:Number = Math.random() * 255 - gFinal;
            
            var b:Number = Math.random();
            var bFinal:Number = Math.random() * 255;
            var bFinal2:Number = Math.random() * 255 - bFinal;
            
            var a:Number = Math.random();
            a += 0.3;
            if(a > 1) {
                a = 1
            }
            
            cmf = new ColorMatrixFilter ([r, 0, 0, 0, rFinal,         // red
                                          0, g, 0, 0, gFinal,         // green
                                          0, 0, b, 0, bFinal,         // blue
                                          0, 0, 0, a, 0,]);           // alpha
        }

        private function update(e:Event = null):void
        {
            // SPRITE, MATRIX(here == null), COLORTRANSFORM(here == null), BLENDMODE, RECTANGLE, SMOOTHING
            bmpd.draw(container, null, null, BlendMode.ADD, null, true);
            bmpd.scroll(0, 2);
            bmpd.applyFilter(bmpd, bmpd.rect, new Point(), blur);
            bmpd.applyFilter(bmpd, bmpd.rect, new Point (), cmf);
            source.x = mouseX;
            source.y = mouseY;
        }
    }
}