/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a4pG
 */

package {
    import flash.events.MouseEvent;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
       
        public function FlashTest() {
            
            mwidth = 8;
            mheight = 8;
            vecGrid = Vector.<int>([
            3,3,1,1, 1,1,1,1, 
            3,2,2,1, 1,1,1,1, 
            1,2,1,1, 1,3,1,1, 
            1,1,1,1, 1,1,2,1, 
            
            1,2,2,1, 1,1,2,1, 
            1,2,3,1, 3,1,3,1, 
            1,2,3,1, 2,1,3,1, 
            1,1,1,1, 1,1,1,1
            ]);
            
            
            deb = new TextField();
            deb.width = 320;
            deb.height = 240;
            deb.mouseEnabled = false;
            addChild(deb);
            
            pa = new xActor();
            pa.cx = 4*cw;
            pa.cy = 4*ch;
            pa.cz = 16;
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mdown);
            stage.addEventListener(MouseEvent.MOUSE_UP, mup);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, kup);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);
        public var bMdown:Boolean = false;
        
        public function kdown(e:KeyboardEvent):void {if (e.keyCode>=512){return;} vecKey[e.keyCode] = true;}
        public function kup(e:KeyboardEvent):void { if (e.keyCode>=512){return;} vecKey[e.keyCode] = false;}
        
        public function mdown(e:MouseEvent):void
        { bMdown = true;}
        
        public function mup(e:MouseEvent):void
        { bMdown = false;}
        
        
        
        
        public var vecGrid:Vector.<int>;
        public var mwidth:int = 0;
        public var mheight:int = 0;
        public var cw:Number = 32;
        public var ch:Number = 32;
       
        public var deb:TextField;
       
        public var ang:Number = 0;
        
        public var pa:xActor;
        
        public var reload:int = 0;
        
        
        public function getTile(wx:Number, wy:Number):int
        {
            var tx:int;
            var ty:int;
            
            tx = Math.floor(wx / cw);
            ty = Math.floor(wy / ch);
            
            if (tx < 0) { return 4; }
            if (ty < 0) { return 4; }
            if (tx >= mwidth) { return 4; }
            if (ty >= mheight) { return 4; }
            
            
            return vecGrid[ty*mwidth +tx];
        }//gettile
        
        
        
       
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);
          
              var i:int;
              var k:int;
              var yt:int;
              var t:int;
              var rx:Number;
              var ry:Number;
              var rz:Number;
              var sx:Number;
              var sy:Number;
              
              var kw:Number;
              var kh:Number;
              
              var c:uint;
              
              var mx:Number;
              var my:Number;
              
              var tempx:Number;
              var tempy:Number;
              
              mx = mouseX-200;
              my = mouseY-100;
               
                tempy = (2*my - mx)*0.5;
                tempx = mx + tempy;
 
              mx = tempx;
              my = tempy;
              
              
              
              ang += 0.1;
              
              kw = cw*0.5;
              kh = ch*0.5;
              
              for (i = 0; i < mheight; i++)
              {
                  yt = i * mwidth;
                for (k = 0; k < mwidth; k++)
                {
                   t = vecGrid[yt+k];
                   if (t <= 0) { continue; } 
                    
                    rx = k * cw;
                    rz = 0;
                    ry = i * ch;
                    
                    sx = rx - ry;
                    sy = (rx*0.5)+(ry*0.5) - rz;
                    
                    sx += 200;
                    sy += 100;
           
                  
                  c = 0x808080;
                   
                   if (t == 3) { c = 0x208820; }
                  
                   graphics.beginFill(c, 0.5);
                    graphics.moveTo(sx, sy);
                    graphics.lineTo(sx+cw,sy+kh);  
                    graphics.lineTo(sx+cw-cw,sy+kh+kh);
                    graphics.lineTo(sx-cw, sy+kh);
                    graphics.lineTo(sx,sy);
                   graphics.endFill();   
                   
              
                }//nextk  
                  
              }//nexti
              
              
             /* 
              if (vecKey[Keyboard.UP]) { pa.vy -=0.3; } 
              if (vecKey[Keyboard.DOWN]) { pa.vy +=0.3; }
              if (vecKey[Keyboard.LEFT]) { pa.vx -=0.3; }
              if (vecKey[Keyboard.RIGHT]) { pa.vx +=0.3; }
              */
              
              if (vecKey[Keyboard.UP] || vecKey[Keyboard.W]) { pa.vy -=0.3; pa.vx-=0.3; } 
              if (vecKey[Keyboard.DOWN] || vecKey[Keyboard.S]) { pa.vy +=0.3; pa.vx+=0.3; }
              if (vecKey[Keyboard.LEFT] || vecKey[Keyboard.A]) { pa.vx -=0.3; pa.vy+=0.3;}
              if (vecKey[Keyboard.RIGHT] || vecKey[Keyboard.D]) { pa.vx +=0.3; pa.vy-=0.3;}
              
              
              pa.vz -= 0.2;
              
              pa.vx *= 0.97;
              pa.vy *= 0.97;
              
              if (pa.cz <= 16 && getTile(pa.cx,pa.cy)==3 ) { pa.vz=4;}
              
              if (pa.vx > 0 && getTile(pa.cx+8, pa.cy)==4) { pa.vx=0;}
              if (pa.vx < 0 && getTile(pa.cx-8, pa.cy)==4) { pa.vx=0;}
              if (pa.vy > 0 && getTile(pa.cx, pa.cy+8)==4) { pa.vy=0;}
              if (pa.vy < 0 && getTile(pa.cx, pa.cy-8)==4) { pa.vy=0;}
              
              if (pa.vz < 0 && pa.cz <= 16) { pa.vz = 0;}
              
              
              pa.cx += pa.vx;
              pa.cy += pa.vy;
              pa.cz += pa.vz;
              
              
              if (reload > 0) { reload -=1;}
              else if (bMdown)
              {
                  var dx:Number;
                  var dy:Number;
                  var dang:Number;
                  dx = mx - pa.cx;
                  dy = my - pa.cy;
                  dang = Math.atan2(dy, dx);
                  
                  addBullet(pa.cx,pa.cy,pa.cz, Math.cos(dang)*8,Math.sin(dang)*8,0);
                  reload=  8;
                  
              }//endif
              
              
              
              //draw shadow
                  rx = pa.cx;
                  ry = pa.cy;
                  rz = 0;
                  
                    sx = rx - ry;
                    sy = (rx*0.5)+(ry*0.5) - rz;
                    
                    sx += 200;
                    sy += 100;
                    
              graphics.beginFill(0, 1);
                  graphics.drawEllipse(sx-12,sy-4,24,8);
              graphics.endFill();
               
              //draw player
              
                    rx = pa.cx;
                    ry = pa.cy;
                    rz = pa.cz;
                    
                    sx = rx - ry;
                    sy = (rx*0.5)+(ry*0.5) - rz;
                    
                    sx += 200;
                    sy += 100;
              
              graphics.beginFill(0xFF0000, 1);
                  graphics.drawCircle(sx, sy, 16);
              graphics.endFill();
              
              graphics.beginFill(0xFFAAaa, 1);
                  graphics.drawCircle(sx-6,sy-6,4);
              graphics.endFill();
              
              
              
            //update and draw bullets
            
              upBullet();
              
              
              
              graphics.lineStyle(2, 0xFF0000, 0.5);
              graphics.drawEllipse(mouseX-8,mouseY-4,16,8);
              
              
            //debug draw              
            graphics.lineStyle(2,0,0.25);
              graphics.drawRect(0,0,mwidth*cw,mheight*ch);
              graphics.drawCircle(pa.cx,pa.cy,16);
              graphics.drawCircle(mx, my, 4);
              
              
              var num:int;
              var a:xActor;
              
              num = vecBull.length;
              for (i = 0; i < num; i++)
              {
                  a = vecBull[i];
                  graphics.drawCircle(a.cx,a.cy, 3);
              }//nexti
          
          
            
        }//onenter 
        
        
        public var vecBull:Vector.<xActor> = new Vector.<xActor>(0,false);
        public function addBullet(wx:Number,wy:Number,wz:Number,vx:Number,vy:Number,vz:Number):void
        {
            var a:xActor;
            
            a = new xActor();
             a.cx = wx;
             a.cy = wy;
             a.cz = wz;
             a.vx = vx;
             a.vy = vy;
             a.vz = vz;
             a.hp = 30;
             
           vecBull.push(a);  
        }//addbull
        
        public function upBullet():void
        {
              var rx:Number;
              var ry:Number;
              var rz:Number;
              var sx:Number;
              var sy:Number;
            
            
          var i:int;
          var num:int;
          var a:xActor;
          num = vecBull.length;
            
          for (i = 0; i < num; i++)
          {
              a = vecBull[i];
              
              a.cx += a.vx;
              a.cy += a.vy;
              a.cz += a.vz;
              a.hp -= 1;
              
              if (a.hp <= 0)
              {
                vecBull[i] = vecBull[num-1];
                a = null;
                i -= 1;
                num = vecBull.pop();
                continue;   
              }
              
                rx = a.cx;
                ry = a.cy;
                rz = a.cz;
                    
                sx = rx - ry;
                sy = (rx*0.5)+(ry*0.5) - rz;
                    
                sx += 200;
                sy += 100;
   
               //bullets are only circle outlines
               //because i cant be bothered to add sorting to this experiment
                graphics.drawCircle(sx,sy, 8);
                
                
                
                sx = rx - ry +200;
                sy = (rx*0.5)+(ry*0.5)+100;
                graphics.moveTo(sx-4,sy);          
                graphics.lineTo(sx+4,sy);
             
              
          }//nexti  
            
        }//upbullet
        
        
        
    }//classend
}

internal class xActor
{
    public var cx:Number = 0;
    public var cy:Number = 0;
    public var cz:Number = 0;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var vz:Number = 0;
    
    public var hp:Number = 0;
    
}//xactor