/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a3wQ
 */

// forked from gaina's soundtest6
//こっそりとSoundMixer.computeSpectrumの第二引数を
//stageクリックでかえれるようにしてみた。
//trueとfalaseでの動きの違いを確かめる。

package  
    {
        import flash.display.Bitmap;
        import flash.display.BitmapData;
        import flash.display.Sprite;
        import flash.display.StageAlign;
        import flash.display.StageQuality;
        import flash.display.StageScaleMode;
        import flash.events.Event;
        import flash.events.MouseEvent;
        import flash.events.TimerEvent;
        import flash.filters.BlurFilter;
        import flash.geom.ColorTransform;
        import flash.geom.Matrix;
        import flash.geom.Matrix3D;
        import flash.geom.Point;
        import flash.geom.Vector3D;
        import flash.media.Sound;
        import flash.media.SoundChannel;
        import flash.media.SoundLoaderContext;
        import flash.media.SoundMixer;
        import flash.net.URLRequest;
        import flash.utils.ByteArray;
        import flash.utils.Timer;
        
        //import flash.filters.BlurFilter;
        
        
        [SWF(width=465,height=800,backgroundColor=0x0)]
        public class Main extends Sprite
        {
            private const ZERO:Point = new Point(0, 0);
            private const RAD:Number = Math.PI * 2 / 256;
            
            private var leftRightSpList:Array;
            private var snd:Sound;
            private var FFTswitch:Boolean = false;
            
            private var container:Sprite;
            private var canvas:BitmapData;
            private var ct:ColorTransform = new ColorTransform(0.95, 0.95, 0.95);
            
            //private var fil:Array;
            
            function Main() 
            {
                stage.scaleMode = StageScaleMode.NO_SCALE;
                stage.align = StageAlign.TOP_LEFT;
                Wonderfl.capture_delay( 15 );
                
                canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0);
                var bmp:Bitmap = addChild(new Bitmap(canvas)) as Bitmap;
                
                container = new Sprite();
                //container.x = stage.stageWidth / 2;
                //container.y = stage.stageHeight / 2;
                
                leftRightSpList = makeLeftRightSpList();
                
                playSound("http://www.takasumi-nagai.com/soundfiles/sound001.mp3");
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
                stage.addEventListener(MouseEvent.CLICK, FFTswitcher);
            }
            
            private function playSound(sndUrl:String):void
            {
                snd = new Sound();
                var context:SoundLoaderContext = new SoundLoaderContext(10,true);
                var req:URLRequest = new URLRequest(sndUrl);
                snd.load(req, context);
                var sndChannel:SoundChannel=new SoundChannel();
                sndChannel = snd.play(0, 5);
                
            }
            
            private function FFTswitcher(e:MouseEvent):void 
            {
                if (FFTswitch) { FFTswitch = false; } else { FFTswitch = true;}
            }
            
            private function onEnterFrame(event:Event):void {
                var sp:Sprite=new Sprite();
                var bytes:ByteArray = new ByteArray();
                SoundMixer.computeSpectrum(bytes,false, 0);
                var i:uint, j:uint;
                for (i = 0; i < 2; i++)
                {
                    var spList:Array = leftRightSpList[i];
                    for (j = 0; j < 256; j++)
                    {
                        sp = spList[j];
                        var rf:Number = bytes.readFloat();
                        var scale:Number = Math.max(0.05, 1 + rf * 15);
                        sp.transform.colorTransform = new ColorTransform(scale * 0.1, scale * 0.3, scale * 0.2);
                        
                        if (i == 0)
                        {
                            sp.scaleX = sp.scaleY = scale;
                            sp.x = Math.cos(RAD * j) * 20 * scale;
                            sp.y = Math.sin(RAD * j) * 20 * scale;
                        }
                        else
                        {
                            sp.scaleX = sp.scaleY = scale * 0.5;
                            sp.x = Math.cos(RAD * j) * 40 * scale;
                            sp.y = Math.sin(RAD * j) * 40 * scale;
                        }
                    }
                }
                
                var mat:Matrix = new Matrix();
                mat.translate(stage.stageWidth / 2, stage.stageHeight / 2);
                canvas.draw(container,mat);
                canvas.colorTransform(canvas.rect, ct);
            }
                    
            private function makeLeftRightSpList():Array
            {
                var spLRList:Array = new Array();
                var circle_r:uint = 2;
                var n:uint;
                var i:uint;
                
                for (n = 0; n < 2; n++)
                {
                    var spList:Array = new Array();
                    for (i = 0; i < 256; i++) {
                        var sp:Sprite = new Sprite();
                        if (n == 0) {
                            sp.graphics.beginFill(0, 0);
                            sp.graphics.lineStyle(0.5, 0xFFFFFF);
                            sp.graphics.drawCircle(0, 0, circle_r);
                            sp.x = Math.cos(RAD * i) * 50;
                            sp.y = Math.sin(RAD * i) * 50;
                        }else {
                            sp.graphics.beginFill(0xFFFFFF);
                            sp.graphics.drawCircle(0, 0, circle_r);
                            sp.x = Math.cos(RAD * i) * 100;
                            sp.y = Math.sin(RAD * i) * 100;
                        }
                        sp.graphics.endFill();
                        container.addChild(sp);
                        spList.push(sp);
                    }
                    spLRList.push(spList);
                }
                return spLRList;
            }
        }
    }