/**
 * Copyright Hiiragi ( http://wonderfl.net/user/Hiiragi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a1oF
 */

// forked from clockmaker's あなたのイベントハンドラを教えて！
/**
* あなたのイベントハンドラを教えて！
*
* 複数のイベント＆複数のインスタンスに
* イベントハンドラを設定するときに
* みなさんの記述方法の違いを知りたい。
*
* [ルール]
* 画面上に3つのボタンが用意されており、
* クリックとロールオーバーの
* イベントハンドラを記述してください。
*/
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    public class FlashTest extends Sprite {
    
        private var _btnA:MyButton;
        private var _btnB:MyButton;
        private var _btnC:MyButton;
        private var _label:MyTextField;

		private var _buttonArray:Array;
		
        public function FlashTest() {
            // ボタンを作成
            _build();
            
            // 自分流のイベントハンドラを記述ください
			
			//配列にボタンをまとめる。
            _buttonArray = [_btnA, _btnB, _btnC];
			
			// Hiiragi流・・・？
			//　正直3つ程度ならわざわざこうする必要はない。Array.forEach()とか使ってもいいと思う。
			var len:int = _buttonArray.length;
			for (var i:int = 0; i < len; i++)
			{
				_buttonArray[i].addEventListener(MouseEvent.CLICK, _onMouseClickEvent);
				_buttonArray[i].addEventListener(MouseEvent.ROLL_OVER, _onMouseRollOverEvent);
			}
			
            // ClockMaker 流
            // クリック
            //_btnA.addEventListener(MouseEvent.CLICK, _onMouseEvent);
            //_btnB.addEventListener(MouseEvent.CLICK, _onMouseEvent);
            //_btnC.addEventListener(MouseEvent.CLICK, _onMouseEvent);
            // ロールオーバー
            //_btnA.addEventListener(MouseEvent.ROLL_OVER, _onMouseEvent);
            //_btnB.addEventListener(MouseEvent.ROLL_OVER, _onMouseEvent);
            //_btnC.addEventListener(MouseEvent.ROLL_OVER, _onMouseEvent);
        }
		
		
		//Hiiragi流・・・といっても、他の人と多分変わらず基本形。
		//関数をあまりまとめすぎると処理が多くなったときに見づらくなるので、だいたい分ける。
		//アウトラインパネルとかでも見やすくなるし。でも、これだけの処理量ならまとめるのはあり。
		//まぁせっかくなので分けて書く。
		private function _onMouseClickEvent(e:MouseEvent):void 
		{
			switch (e.currentTarget)
			{
				case _btnA: _label.text = "A がクリックされました"; break;
				case _btnB: _label.text = "B がクリックされました"; break;
				case _btnC: _label.text = "C がクリックされました"; break;
			}
		}
		
        private function _onMouseRollOverEvent(e:MouseEvent):void 
		{
			switch (e.currentTarget)
			{
				case _btnA: _label.text = "A がロールオーバーされました"; break;
				case _btnB: _label.text = "B がロールオーバーされました"; break;
				case _btnC: _label.text = "C がロールオーバーされました"; break;
			}
		}
		
		
		
        // ClockMaker 流
        //private function _onMouseEvent(e:MouseEvent):void {
             // タイプを判別
             //switch(e.type){
                 //case MouseEvent.CLICK:
                     // 対象を判別
                     //switch(e.currentTarget){
                         //case _btnA: _label.text = "A がクリックされました"; break;
                         //case _btnB: _label.text = "B がクリックされました"; break;
                         //case _btnC: _label.text = "C がクリックされました"; break;
                     //}
                     //break;
                 //case MouseEvent.ROLL_OVER:
                     // 対象を判別
                     //switch(e.currentTarget){
                         //case _btnA: _label.text = "A がロールオーバーされました"; break;
                         //case _btnB: _label.text = "B がロールオーバーされました"; break;
                         //case _btnC: _label.text = "C がロールオーバーされました"; break;
                     //}
                     //break;
             //}
        //}
        
        /**
        * インターフェースを作る
        */
        private function _build():void {
            _label = new MyTextField();
            _label.x = 150; _label.y = 280;
            addChild(_label);

            _btnA = new MyButton();
            _btnA.text = "Button A"; 
            _btnA.x = 70; _btnA.y = 230;
            addChild(_btnA);
            
            _btnB = new MyButton();
            _btnB.text = "Button B";
            _btnB.x = 190; _btnB.y = 230;
            addChild(_btnB);
   
            _btnC = new MyButton();            
            _btnC.text = "Button C";
            _btnC.x = 310; _btnC.y = 230;
            addChild(_btnC);
        }
    }
}

import flash.display.*
import flash.text.*;

/**
* MyButton クラスはボタン的な挙動をするようにしたSpriteです。
*/
class MyButton extends Sprite {
    private var _text:MyTextField;
    /**
    * 新しい MyButton インスタンスを作成します。
    */
    public function MyButton(){
        graphics.beginFill(0x000000);
        graphics.drawRoundRect(0, 0, 100, 30, 5, 5);
        addChild(_text = new MyTextField);
        buttonMode = true;
    }
    /**
    * ボタンの文言を設定します。
    */
    public function set text(value:String):void {
        _text.text = value;
        _text.x = (100 - _text.textWidth) / 2;
        _text.y = (30 - _text.textHeight) / 2;
    }
}

/**
* MyTextField クラスは適当な初期設定をしただけのテキストフィールドです。
*/
class MyTextField extends TextField {
    /**
    * 新しい MyTextField インスタンスを作成します。
    */
    public function MyTextField() {
        defaultTextFormat = new TextFormat("_sans", 12, 0xFF0000);
        autoSize = "left";
        selectable = false;
        mouseEnabled = false;
    }
}