/**
 * Copyright fumix ( http://wonderfl.net/user/fumix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a1mr
 */

// forked from naoto5959's wonderflに投稿したswfを別の投稿から使うテスト
package  
{
	import flash.display.MovieClip;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.net.URLRequest;
	import flash.events.DataEvent;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.events.TweenEvent;
	import org.libspark.betweenas3.tweens.IObjectTween;
	
	[SWF(width = "465", height = "465", backgroundColor = "0x111111", frameRate = "60")]
	/**
	 * wonderflに投稿したswfを別の投稿から使うテスト
	 * http://wonderfl.net/code/afe5412cf117b348681e9eb6e3595035cabd06e6
	 * で投稿したswfを読み込んで使ってみます。
	 * 
	 * とりあえず、矢印キーかマウスで移動します。
	 * 
	 * まだ作りかけです。
	 * @author naoto koshikawa
	 */
	public class Main extends Sprite
	{
		//----------------------------------------------------------------------
		//  static properties
		//----------------------------------------------------------------------
		//------------------------------
		//  private static properties
		//------------------------------
		/**
		 * avatar url
		 */
		private static const AVATAR_BODY_URL:String 
			= "http://swf.wonderfl.net/swf/usercode/9/97/97ab/"
			+ "97abee157680ac24ce5596c4f99105c61e1f7571.swf";
		
		/**
		 * distance of inertia 
		 */
		private static const DISTANCE_OF_INERTIA:Number = 15;
		
		/**
		 * distance of movement per Event.EnterFrame
		 */
		private static const DISTANCE_OF_MOVEMENT:Number = 1;
		
		//----------------------------------------------------------------------
		//  properties
		//----------------------------------------------------------------------
		//------------------------------
		//  private properties
		//------------------------------
		/**
		 * avatar
		 */
		private var _avatar:Avatar;
		
		/**
		 * indicate key is down or not.
		 */
		private var _isKeyDown:Boolean;
		
		/**
		 * pressed keycode
		 */
		private var _keyCode:uint;
		
		/**
		 * tween
		 */
		private var _tween:IObjectTween;
		//----------------------------------------------------------------------
		//  methods
		//----------------------------------------------------------------------
		//------------------------------
		//  public methods
		//------------------------------
		/**
		 * constructor
		 */
		public function Main() 
		{
			stage.quality = StageQuality.BEST;
			
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(
				Event.COMPLETE, loaderInfo_completeHandler
			);
			loader.load(new URLRequest(AVATAR_BODY_URL));
		}
		private function loaderInfo_completeHandler(event:Event):void
		{
			var loader:Loader = Loader(event.target.loader);
			loader.contentLoaderInfo.removeEventListener(
				Event.COMPLETE, loaderInfo_completeHandler
			);
			
			var _avatarBody = loader.content;
			addChild(_avatarBody);
		}
			
	}
}

import flash.display.Sprite;
import flash.display.Loader;
import flash.events.DataEvent;
import flash.events.Event;
import flash.net.URLRequest;

/**
 * Avatar
 */
class Avatar extends Sprite
{
	//--------------------------------------------------------------------------
	//  properties
	//--------------------------------------------------------------------------
	//----------------------------------
	//  public properties
	//----------------------------------
	private var _color:uint = 0x000000;
	/**
	 * color
	 */
	public function get color():uint
	{
		return _color;
	}
	/** @prviate */
	public function set color(value:uint):void
	{
		_color = value;
		if (_avatarBody) _avatarBody.color = _color;
	}
	
	//----------------------------------
	//  private properties
	//----------------------------------
	/**
	 * avatar body
	 */
	private var _avatarBody:*;
	
	//--------------------------------------------------------------------------
	//  methods
	//--------------------------------------------------------------------------
	//----------------------------------
	//  public methods
	//----------------------------------
	/**
	 * constructor
	 */
	public function Avatar():void
	{
		
	}
	
	/**
	 * load AvatarBody
	 * @param	url
	 */
	public function loadBody(url:String):void
	{
		var loader:Loader = new Loader();
		loader.contentLoaderInfo.addEventListener(
			Event.COMPLETE, loaderInfo_completeHandler
		);
		loader.load(new URLRequest(url));
	}
	
	public function front():void
	{
		if (_avatarBody) _avatarBody.front();
	}
	
	public function back():void
	{
		if (_avatarBody) _avatarBody.back();
	}
	
	public function right():void
	{
		if (_avatarBody) _avatarBody.right();
	}
	
	public function left():void
	{
		if (_avatarBody) _avatarBody.left();
	}
	
	public function play():void
	{
		if (_avatarBody) _avatarBody.play();
	}
	
	public function stop():void
	{
		if (_avatarBody) _avatarBody.stop();
	}
	
	public function stopComplete():void
	{
		if (_avatarBody) _avatarBody.stopComplete();
	}
	
	//--------------------------------------------------------------------------
	//  event handler
	//--------------------------------------------------------------------------
	//----------------------------------
	//  private event handler
	//----------------------------------
	/**
	 * 
	 * @param	event
	 */
	private function loaderInfo_completeHandler(event:Event):void
	{
		var loader:Loader = Loader(event.target.loader);
		loader.contentLoaderInfo.removeEventListener(
			Event.COMPLETE, loaderInfo_completeHandler
		);
		
		_avatarBody = loader.content;
		_avatarBody.x = - _avatarBody.width / 2;
		_avatarBody.y = - _avatarBody.height / 2;
		addChild(_avatarBody);
		dispatchEvent(new DataEvent(Event.COMPLETE, false, false, "body"));
	}
}
