/**
 * Copyright terra1119 ( http://wonderfl.net/user/terra1119 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a0Vo
 */

// forked from terra1119's papervision test
package {
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.utils.Timer;

	import org.papervision3d.view.BasicView;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.papervision3d.materials.special.ParticleMaterial;
	import org.papervision3d.objects.special.ParticleField;

	import caurina.transitions.Tweener;
        
        [SWF(width="1000", height="800", frameRate="60", backgroundColor="0x000000")]
	
        public class Main extends BasicView {

		private const DISTANCE:Number=500;
		private var theta:Number;
		private var no:int;
		private var flg:Boolean=true;
		private var timer:Timer;
		private var autoTimer:Timer;
		private var autoFlg:Boolean=true;
		private var selectedId:int=0;
		private var objs:Array;
		private var oldCameraX:Number;
		private var oldCameraY:Number;
		private var oldCameraZ:Number;
		private var oldRotX:Number;
		private var oldRotY:Number;
		private var oldRotZ:Number;
		private var contentsMax:int;

		public function Main() {
			stage.scaleMode=StageScaleMode.NO_SCALE;
			stage.align=StageAlign.TOP_LEFT;
			stage.quality=StageQuality.HIGH;
			super(0,0,true,true);
			buttonMode=true;
			init();
			
		}

		private function init():void {
			no=4;
			theta=0;
			contentsMax=50;
			camera.z=-500;
			camera.focus=500;
			camera.zoom=1;
			camera.target=DisplayObject3D.ZERO;
			var particleMat:ParticleMaterial=new ParticleMaterial(0xFFFFFF,0.4);
			
			objs = [];

			for (var i:int=0; i<contentsMax; i++) {
				var material:ColorMaterial=new ColorMaterial(0xFFFFFF*Math.random());
				material.doubleSided=true;
				material.interactive=true;
				var obj:Plane=new Plane(material,90,60,1,1);
				scene.addChild(obj);
				obj.x=0;
				obj.y=0;
				obj.z=0;
				//obj.alpha=0;
				obj.useOwnContainer=true; 
obj.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK,onClick);				obj.addEventListener(InteractiveScene3DEvent.OBJECT_OVER,onMouseOverHandler);
				obj.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);
				objs.push(obj);
			}
			startRendering();
			spread();
			//autoTimer=new Timer(8000);
			//autoTimer.addEventListener(TimerEvent.TIMER,onAutoTimer,false, 0, true);
			//autoTimer.start();
			//timer=new Timer(16000);
			//timer.addEventListener(TimerEvent.TIMER,onTimer,false, 0, true);
			//timer.start();
		}

		//リスナー
		override protected function onRenderTick(event:Event = null):void {                        
                        /*
			if (! flg) {
				camera.x=DISTANCE*Math.sin(theta*Math.PI/180);
				camera.y=DISTANCE*Math.cos(theta*Math.PI/180);
				camera.z=DISTANCE*2*Math.cos(theta*Math.PI/180);
				theta+=0.4;
			}
                        */
			super.onRenderTick(event);
		}
		private function onTimer(timer:TimerEvent):void {
			spread();
		}

		private function onAutoTimer(timer:TimerEvent):void {
			autoShow();
		}
		
		private function onMouseOverHandler(e:InteractiveScene3DEvent):void {
			//if (! flg) {
				Tweener.addTween(e.target, {time:0.4,scale:1.5,transition:"easeOutBack"});
			//}
		}
		private function onMouseOutHandler(e:InteractiveScene3DEvent):void {
			//if (! flg) {
				Tweener.addTween(e.target, {time:0.4,scale:1,transition:"easeOutBack"});
			//}
		}
                private function onClick(e:InteractiveScene3DEvent):void {
                    autoShow();
                }

		private function autoShow():void {
			if (autoFlg) {
				oldCameraX=camera.x;
				oldCameraY=camera.y;
				oldCameraZ=camera.z;
				objs[selectedId].rotationX=0;
				objs[selectedId].rotationY=0;
				objs[selectedId].rotationZ=0;
				flg=true;
				var target:DisplayObject3D = new DisplayObject3D();
				target.copyTransform(objs[selectedId]);
				target.moveBackward(200);
				// カメラを移動させる
				Tweener.addTween(camera, {x:target.x, y:target.y, z:target.z,time:1,transition:"easeInOut"});

				for (var i:int; i<contentsMax; i++) {
					Tweener.addTween(objs[i], {alpha:0,scale:1,time:1,transition:"easeInOut"});
				}
				// カメラのターゲットを移動させる
				Tweener.addTween(camera.target, {x:objs[selectedId].x, y:objs[selectedId].y,z:objs[selectedId].z,time:1,transition:"easeInOut"});

				Tweener.addTween(objs[selectedId], {alpha:1,time:1,transition:"easeInOut"});
				autoFlg=false;
				selectedId++;
				if (selectedId>objs.length) {
					selectedId=0;
				}
			} else {
				for (var j:int; j<contentsMax; j++) {
					Tweener.addTween(objs[j], {alpha:1,scale:1,time:1,transition:"easeInOut"});
				}
				Tweener.addTween(camera, {x:oldCameraX,y:oldCameraY,z:oldCameraZ,focus:500,zoom:1,time:1,transition:"easeInOut",onComplete:onCameraMoveComplete});
				Tweener.addTween(camera.target, {x:DisplayObject3D.ZERO.x,y:DisplayObject3D.ZERO.y,z:DisplayObject3D.ZERO.z,time:1,transition:"easeInOut"});
				autoFlg=true;
			}
		}
		
		private function onCameraMoveComplete():void{
			flg=false;
		}

		private function spread():void {
			switch (no) {
				case 0 :
					for (var i:int; i<contentsMax; i++) {
						Tweener.addTween(objs[i], {time:1,delay:0.02 * i,
						x:Math.random() * 2000 - 1000,
						y:Math.random() * 2000 - 1000,
						z:Math.random() * 2000 - 1000,
						rotationX:Math.random() * 360, 
						rotationY:Math.random() * 360, 
						rotationZ:Math.random() * 360,
						alpha:1,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[i]
						});
					}
					break;
				case 1 :
					for (var j:int; j<contentsMax; j++) {
						var r:Number=360/contentsMax*j;
						Tweener.addTween(objs[j], {
						time:1,
						delay:0.02 * j,
						x:Math.cos(r * 3 * Math.PI / 180) * 200,
						y:Math.sin(r * 3 * Math.PI / 180) * 200,
						z:j * 30 - 500,
						rotationX:0, 
						rotationY:0, 
						rotationZ:0,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[j]
						});
					}
					break;
				case 2 :
					for (var k:int; k<contentsMax; k++) {
					var rr:Number=360/contentsMax*k;
						Tweener.addTween(objs[k], {
						time:1,
						delay:0.02 * k,
						x:Math.cos(rr * Math.PI / 180) * 500,
						y:0,
						z:Math.sin(rr * Math.PI / 180) * 500,
						rotationX:0, 
						rotationY:0, 
						rotationZ:0,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[k]
						});
					}
					break;
					
				case 3 :
					var anglePer:Number = ((Math.PI*2) * (contentsMax/10)) / contentsMax;
					var yPos:int=0;
					for (var l:int; l<contentsMax; l++) {
						Tweener.addTween(objs[l], {
						time:1,
						delay:0.02 * l,
						x:Math.cos(l * anglePer) * 300,
						y:yPos-300,
						z:Math.sin(l * anglePer) * 300,
						rotationX:0, 
						rotationY:(-l*anglePer) * (180/Math.PI) + 270, 
						rotationZ:0,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[l]
						});
						if( (l+1) % 10 == 0 ){
							yPos += 115;
						}
					}
					break;

				case 4 :
					var yyPos:int=0;
					var xPos:int=0;
					for (var m:int; m<contentsMax; m++) {
						Tweener.addTween(objs[m], {
						time:1,
						delay:0.02 * m,
						x:xPos*140-700,
						y:yyPos-300,
						z:0,
						rotationX:0, 
						rotationY:0, 
						rotationZ:0,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[m]
						});
						xPos++;
						if( (m+1) % 10 == 0 ){
							yyPos += 110;
							xPos=0;
						}
					}
					break;
				}
			
			no=4;
		}
		
		private function onPlaneMoveStart():void{
			for (var i:int; i<contentsMax; i++) {
				objs[i].removeEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOverHandler);
				objs[i].removeEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);
			}
		}
		
		private function onPlaneMoveComplete(i:int):void{
			objs[i].addEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOverHandler);
			objs[i].addEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);
			
		}
	}
}