/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/a0RV
 */

// forked from yprops's テキスト表示用
package
{
    import flash.events.*;
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    
    public class DebugText extends Sprite
    {
        
        // Math.atan2(mouseY, mouseX) で得たラジアンを、
        // 赤線…　Math.sin, Math.cos を使って毎回描画
        // 紫線…　Math.cos, Math.sin を使って毎回描画
        // 青線…　Math.sin, Math.cos で描いた描線を DisplayObject.rotation で回転
        // 緑線…　Math.cos, Math.sin で描いた描線を DisplayObject.rotation で回転
        
        
        //----------props--------------------
        
        
        private var clock :Sprite;
        private var red :Sprite;
        private var purple :Sprite;
        private var green :Sprite;
        private var blue :Sprite;
        
        
        
        //------------main-----------------------
        
        
        public function main() :void{
            clock = new Sprite();
            clock.x = 224;
            clock.y = 224;
            var g :Graphics = clock.graphics;
            g.beginFill(0xFFFFFF);
            g.lineStyle(1,0x0);
            g.drawCircle(0,0,120);
            g.endFill();
            addChild(clock);
            
            red = new Sprite();
            red.transform.matrix = clock.transform.matrix;
            addChild(red);
            
            purple = new Sprite();
            purple.transform.matrix = clock.transform.matrix;
            addChild(purple);
            
            blue = new Sprite();
            blue.transform.matrix = clock.transform.matrix;
            drawHand(blue, 0, 50, 0x0000CC, 4);
            addChild(blue);
            
            green = new Sprite();
            green.transform.matrix = clock.transform.matrix;
            drawHand(green, 0, 50, 0x00CC00, 4, true);
            addChild(green);
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, update);
            update();
        }
        private function update(ev:MouseEvent = null) :void{
            var rad :Number = Math.atan2(clock.mouseY, clock.mouseX);
            
            //赤　描き直し
            drawHand(red, rad, 100, 0x990000, 2);
            drawHand(purple, rad, 80, 0x990099, 2, true);
            blue.rotation = rad * 180/Math.PI;
            green.rotation = rad * 180/Math.PI;
            
            deb.htmlText =
                "<font color='" + (rad>0? "#990000" : "#0000CC") + "'>" +
                "ラジアン " + rad + "\n角度 " + (rad * 180/Math.PI) +
                "</font>"
            ;
        }

        
        private function drawHand(sp :Sprite, rad :Number, len :Number, col :Number, tick :Number, flip :Boolean = false) :void{
            var g :Graphics = sp.graphics;
            g.clear();
            g.beginFill(0x0);
            g.lineStyle(tick, col);
            g.moveTo(0,0);
            if(flip){
                g.lineTo(Math.cos(rad) * len, Math.sin(rad) * len);
            }else{
                g.lineTo(Math.sin(rad) * len, Math.cos(rad) * len);
            }
            g.endFill();
        }

        
        
        
        
        
        //------------general---------------------
        public function DebugText(){
            if(stage)init();
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(ev:Event = null) :void{
            removeEventListener(Event.ADDED_TO_STAGE, init);
            addDeb(450, 100);
            main();
        }
        private var deb :TextField;
        private function addDeb(w:uint, h:uint) :void{
                deb = new TextField();
                deb.wordWrap = true;
                deb.width = w;
                deb.height = h;
                deb.border = true;
                deb.borderColor = 0;
                deb.background = true;
                deb.backgroundColor = 0x99ffffff;
                deb.text = "beginDebugText-------\n\n";
                addChild(deb);
        }
        private function addDebLine(...args) :void{
                deb.appendText(args.join(" ") + "\n");
                deb.scrollV = deb.maxScrollV;
        }
    }
}