/**
 * Copyright Delirium1988 ( http://wonderfl.net/user/Delirium1988 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zxKp
 */

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Vector3D;
	import flash.text.TextField;
		import jiglib.plugin.papervision3d.Pv3dMesh;
	import jiglib.physics.RigidBody;
	import jiglib.plugin.papervision3d.Papervision3DPhysics;
	import jiglib.geometry.JBox;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.materials.BitmapMaterial;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.view.BasicView;
    import org.papervision3d.events.FileLoadEvent;

	
	import org.papervision3d.objects.parsers.DAE;
	
	public class Dice extends BasicView {
		private static const MAX:uint = 10;
		public var stand:DAE;
		public var model:DAE;
		public var tvcollision:JBox;
		public var 	standcollision:JBox;
	
				private var _physics:Papervision3DPhysics;
		private var _diceList:Vector.<RigidBody> = new Vector.<RigidBody>();
		private var _tf:TextField = new TextField;
		
		public function Dice() {
			super(640, 640, false);

			addChild(_tf);
			
			initStage();
			init3d();
			initPysics();
				stand = new DAE();
			 			stand.load("stand.dae");
			 	 // stand.load("http://hokypoky.info/samples/10/01/13/collada/negimiku.dae");
			
					model = new DAE();
 			model.addEventListener( FileLoadEvent.LOAD_COMPLETE, myOnLoadCompleteHandler );
           
         //  model.load("http://hokypoky.info/samples/10/01/13/collada/negimiku.dae");
			model.load("tv.dae");
		
			startRendering();
        
		//body.friction = 0.15;
		//http://phosphorus.hlgamers.com/models/stand.dae
		}
		  private function myOnLoadCompleteHandler( event:FileLoadEvent ) : void
        {
        	
			
			//	body.rotationY += 270;
        		//	model.rotationY += 270;
        		 	//	body.y = 600;
        		//standcollision.z = 100;
        		//standcollision.y = 100;
        		//tvcollision.y = 100;
        			//model.x = -200;
        		 	//	model.y = 100;
        			//model.z = -400;
        				//model.y = 600;
        			//stand.rotationY += 270;
			//model.rotationY += 90
			
					model.scale = 10
		tvcollision = new JBox(new Pv3dMesh(model), 130, 60,130);		
tvcollision.rotationY += 270;
					tvcollision.y = 600;		
  		_physics.addBody(tvcollision);
		scene.addChild(model);
		
          
       
      stand.scale = 10;	
      	standcollision = new JBox(new Pv3dMesh(stand), 130, 60, 130);	
			standcollision.y = 400;	
			standcollision.rotationY += 270;
     	_physics.addBody(standcollision);
       	 	scene.addChild(stand);
        }
		private function initStage():void {
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stage.frameRate = 30;
			stage.addEventListener(MouseEvent.CLICK, onMouseClick);
		}
		
		private function init3d():void {
			camera.x = 400;
			camera.y = 100;
			camera.z = 0;
			camera.target = DisplayObject3D.ZERO;
		}
		
		private function initPysics():void {
			_physics = new Papervision3DPhysics(scene, 20);
			_physics.createGround(new WireframeMaterial(0xFFFFFF, 0), 100, 0);
		}

		private function onMouseClick(evt:Event):void {
			if (_diceList.length >= MAX) {
				for each (var d:RigidBody in _diceList) {
					scene.removeChild(_physics.getMesh(d));
					_physics.removeBody(d);
				}
				_diceList = new Vector.<RigidBody>();
			}
			
			//var dice:RigidBody = createDice();
			//dice.x = 400;
			//dice.y = 50;
			//dice.setAngVel(new Vector3D(Math.random()-.5, Math.random()-.5, Math.random()-.5));
			//dice.setVelocity(new Vector3D(-90, 50, 0));
			tvcollision.setVelocity(new Vector3D(0, 30, 0));
			standcollision.setVelocity(new Vector3D(0, 30, 0));
			//model.setVelocity(new Vector3D(0, 50, 0));
			//_diceList.push(dice);
		
		}
		
		private function createDice():RigidBody {
			var materials:MaterialsList = new MaterialsList({
				front: new BitmapMaterial(createFaceOfDice(1), true),
				back: new BitmapMaterial(createFaceOfDice(6), true),
				left: new BitmapMaterial(createFaceOfDice(2), true),
				right: new BitmapMaterial(createFaceOfDice(5), true),
				top: new BitmapMaterial(createFaceOfDice(3), true),
				bottom: new BitmapMaterial(createFaceOfDice(4), true)
			});
			
			return _physics.createCube(materials, 100, 100, 100);
		}
		
		private function createFaceOfDice(n:uint):BitmapData {
			var bmp:BitmapData = new BitmapData(100, 100, false, 0xffffff);
			var tmp:Shape = new Shape();
			with (tmp.graphics) {
				switch (n) {
					case 1:
						beginFill(0xff3333);
						drawCircle(50, 50, 15);
						break;
					case 2:
						beginFill(0x333333);
						drawCircle(33, 33, 11);
						drawCircle(66, 66, 11);
						break;
					case 3:
						beginFill(0x333333);
						drawCircle(25, 25, 11);
						drawCircle(50, 50, 11);
						drawCircle(75, 75, 11);
						break;
					case 4:
						beginFill(0x333333);
						drawCircle(25, 25, 11);
						drawCircle(25, 75, 11);
						drawCircle(75, 25, 11);
						drawCircle(75, 75, 11);
						break;
					case 5:
						beginFill(0x333333);
						drawCircle(25, 25, 11);
						drawCircle(25, 75, 11);
						drawCircle(75, 25, 11);
						drawCircle(75, 75, 11);
						drawCircle(50, 50, 11);
						break;
					case 6:
						beginFill(0x333333);
						drawCircle(25, 25, 11);
						drawCircle(25, 50, 11);
						drawCircle(25, 75, 11);
						drawCircle(75, 25, 11);
						drawCircle(75, 50, 11);
						drawCircle(75, 75, 11);
						break;
				}
				endFill();
				lineStyle(0, 0xcccccc);
				moveTo(0, 0);
				lineTo(99, 0);
				lineTo(99, 99);
				lineTo(0, 99);
				lineTo(0, 0);
			}
			bmp.draw(tmp);
			return bmp;
		}
		
		protected override function onRenderTick(event:Event=null):void {
			_physics.step();
			//body.rotationY += 1;
		//	model.rotationY += 1;
			var str:String = "";
			for each (var d:RigidBody in _diceList) {
				var n:uint = getUpside(_physics.getMesh(d) as Cube);
				if (n) {
					str += n + " ";
				} else {
					str += "? ";
				}
			}
			_tf.text = str;
			
			super.onRenderTick(event);
		}
		
		private function getUpside(cube:Cube):uint {
			var tmp:DisplayObject3D = new DisplayObject3D();
			var yAxis:Number3D = new Number3D(0, 1, 0);
			var zAxis:Number3D;
			var dot:Number;
			
			with (tmp.transform) {
				// 1 or 6
				tmp.copyTransform(cube);
				zAxis = new Number3D(n13, n23, n33);
				zAxis.normalize();
				dot = Number3D.dot(zAxis, yAxis);
				if (  0 < dot && 1 - dot < .1 ) {
					return 1;
				} else if ( dot < 0 && 1 + dot < .1 ) {
					return 6;
				}
				
	
				tmp.yaw(90);
				zAxis = new Number3D(n13, n23, n33);
				zAxis.normalize();
				dot = Number3D.dot(zAxis, yAxis);
				if (  0 < dot && 1 - dot < .1 ) {
					return 5;
				} else if ( dot < 0 && 1 + dot < .1 ) {
					return 2;
				}
				
				// 3 or 4
				tmp.copyTransform(cube);
				tmp.pitch(90);
				zAxis = new Number3D(n13, n23, n33);
				zAxis.normalize();
				dot = Number3D.dot(zAxis, yAxis);
				if (  0 < dot && 1 - dot < .1 ) {
					return 4;
				} else if ( dot < 0 && 1 + dot < .1 ) {
					return 3;
				}
			}
			
			return 0;
		}
	}
}