/**
 * Copyright mmlemon_ ( http://wonderfl.net/user/mmlemon_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zrhn
 */

package {
    import flash.display.BlendMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	
	import org.papervision3d.cameras.CameraType;
	import org.papervision3d.core.effects.BitmapLayerEffect;
	import org.papervision3d.core.effects.utils.BitmapClearMode;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	
	[SWF(backgroundColor=0x0,frameRate=60)]
    public class Main extends BasicView{
        private static const NUM:uint = 500;
		private var pxls:Pixels;
		private var rad:Number = 800;
		
		private function init():void
		{
			
			var layer:BitmapEffectLayer = new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight, true, 0, BitmapClearMode.CLEAR_POST, true);
			viewport.containerSprite.addLayer(layer);
			layer.addEffect(new BitmapLayerEffect(new BlurFilter(2, 2, 4), true));
			pxls = new Pixels(layer);
			scene.addChild(pxls);
			
			for(var i:uint = 0;i < NUM; i++)
			{
				var px:Pixel3D = new Pixel3D(
					0xff << 24 | 0xff << 16 | 0xff * Math.random() << 8 | 0xff,
					Math.random() * rad, Math.random() * rad, Math.random() * rad);
				
				pxls.addPixel3D(px);
			}
			pxls.z = 500;
			
			removeEventListener(Event.ENTER_FRAME, onRender, false);
			addEventListener(Event.ENTER_FRAME, onRender, false, 0, false);
		}
		private function onRender(event:Event):void
		{
			pxls.rotationY+=2;
			pxls.rotationX-=2;
			startRendering();
		}
		public function Main()
		{
			super(stage.stageWidth, stage.stageHeight, true, false, CameraType.DEBUG);
			init();
		}
    }
}