/**
 * Copyright naoto5959 ( http://wonderfl.net/user/naoto5959 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zgSG
 */

package  
{
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.net.URLRequest;
	import flash.events.DataEvent;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.events.TweenEvent;
	import org.libspark.betweenas3.tweens.IObjectTween;
	
	[SWF(width = "465", height = "465", backgroundColor = "0x111111", frameRate = "60")]
	/**
	 * wonderflに投稿したswfを別の投稿から使うテスト
	 * http://wonderfl.net/code/afe5412cf117b348681e9eb6e3595035cabd06e6
	 * で投稿したswfを読み込んで使ってみます。
	 * 
	 * とりあえず、矢印キーかマウスで移動します。
	 * 
	 * まだ作りかけです。
	 * @author naoto koshikawa
	 */
	public class Main extends Sprite
	{
		//----------------------------------------------------------------------
		//  static properties
		//----------------------------------------------------------------------
		//------------------------------
		//  private static properties
		//------------------------------
		/**
		 * avatar url
		 */
		private static const AVATAR_BODY_URL:String 
			= "http://swf.wonderfl.net/swf/usercode/a/af/afe5/"
			+ "afe5412cf117b348681e9eb6e3595035cabd06e6.swf?v=3";
		
		/**
		 * distance of inertia 
		 */
		private static const DISTANCE_OF_INERTIA:Number = 15;
		
		/**
		 * distance of movement per Event.EnterFrame
		 */
		private static const DISTANCE_OF_MOVEMENT:Number = 1;
		
		//----------------------------------------------------------------------
		//  properties
		//----------------------------------------------------------------------
		//------------------------------
		//  private properties
		//------------------------------
		/**
		 * avatar
		 */
		private var _avatar:Avatar;
		
		/**
		 * indicate key is down or not.
		 */
		private var _isKeyDown:Boolean;
		
		/**
		 * pressed keycode
		 */
		private var _keyCode:uint;
		
		/**
		 * tween
		 */
		private var _tween:IObjectTween;
		//----------------------------------------------------------------------
		//  methods
		//----------------------------------------------------------------------
		//------------------------------
		//  public methods
		//------------------------------
		/**
		 * constructor
		 */
		public function Main() 
		{
			stage.quality = StageQuality.BEST;
			
			_avatar = new Avatar();
			_avatar.addEventListener(Event.COMPLETE, _avatar_complete);
			_avatar.loadBody(AVATAR_BODY_URL);
		}
		
		//------------------------------
		//  private methods
		//------------------------------
		/**
		 * キー操作の受付を開始します。
		 * KeyboardEvent.KEY_DOWNイベント送出時にアバターの方向を変更します。
		 * KeyboardEvent.KEY_UPイベント送出時にアバターをトゥイーン効果で動かします。
		 * （物理トゥイーンに変えたほうがいいかも）
		 * KeyboardEvent.KEY_UPイベント送出時まで（矢印キーを押しっぱなしの間）
		 * は、Event.ENTER_FRAME送出時に、押された矢印キーに応じてアバターの座標を
		 * 更新します。
		 */
		private function activate():void
		{
			stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
		}
		
		private function deactivate():void
		{
			stage.removeEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
			stage.removeEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
		}
		
		//----------------------------------------------------------------------
		//  event handler
		//----------------------------------------------------------------------
		//------------------------------
		//  private event handler
		//------------------------------
		/**
		 * Event.COMPLETE
		 * @param	event
		 */
		private function _avatar_complete(event:DataEvent):void
		{
			addChild(_avatar);
			_avatar.y = 16;
			_avatar.right();
			_avatar.play();
			_avatar.color = 0x777777 + 0x888888 * Math.random();
			_tween = BetweenAS3.tween(
				_avatar,
				{x: 16 }, { x: -DISTANCE_OF_INERTIA },
				0.5, Sine.easeOut
			);
			_tween.addEventListener(TweenEvent.COMPLETE, _tween_compleHandler);
			_tween.play();
			activate();
		}
		
		/**
		 * KeyBoadEvent.KEY_DOWN
		 * @param	event
		 */
		private function keyDownHandler(event:KeyboardEvent):void
		{
			deactivate();
			if (_tween) 
			{
				_tween.removeEventListener(TweenEvent.COMPLETE, _tween_compleHandler);
				_tween.stop();
			}
			_isKeyDown = true;
			_keyCode = event.keyCode;

			switch (_keyCode)
			{
				case Keyboard.UP: {
					_avatar.back();
					break;
				}
				case Keyboard.RIGHT: {
					_avatar.right();
					break;
				}
				case Keyboard.DOWN: {
					_avatar.front();
					break;
				}
				case Keyboard.LEFT: {
					_avatar.left();
					break;
				}
			}
			_avatar.play();
			stage.addEventListener(KeyboardEvent.KEY_UP, keyUpHandler);
			stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		/**
		 * KeyboardEvent.KEY_UP
		 * @param	event
		 */
		private function keyUpHandler(event:KeyboardEvent):void
		{
			activate();
			_isKeyDown = false;
			stage.removeEventListener(KeyboardEvent.KEY_UP, keyUpHandler);
			stage.removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
			
			switch (_keyCode)
			{
				case Keyboard.UP:
				{
					_tween = BetweenAS3.tween(
						_avatar,
						{y: _avatar.y - DISTANCE_OF_INERTIA }, { y: _avatar.y },
						0.5, Sine.easeOut
					);
					break;
				}
				case Keyboard.RIGHT:
				{
					_tween = BetweenAS3.tween(
						_avatar, 
						{x: _avatar.x + DISTANCE_OF_INERTIA }, { x: _avatar.x }, 
						0.5, Sine.easeOut
					);
					break;
				}
				case Keyboard.DOWN:
				{
					_tween = BetweenAS3.tween(_avatar, 
						{y: _avatar.y + DISTANCE_OF_INERTIA }, { y: _avatar.y }, 
						0.5, Sine.easeOut
					);
					break;
				}
				case Keyboard.LEFT:
				{
					_tween = BetweenAS3.tween(_avatar,
						{x: _avatar.x - DISTANCE_OF_INERTIA }, { x: _avatar.x },
						0.5, Sine.easeOut
					);
					break;
				}
			}
			_tween.addEventListener(TweenEvent.COMPLETE, _tween_compleHandler);
			_tween.play();
		}
		
		/**
		 * Event.ENTER_FRAME
		 * @param	event
		 */
		private function enterFrameHandler(event:Event):void
		{
			if (!_isKeyDown) return;
			switch (_keyCode)
			{
				case Keyboard.UP:
				{
					_avatar.y -= DISTANCE_OF_MOVEMENT;
					break;
				}
				case Keyboard.RIGHT:
				{
					_avatar.x += DISTANCE_OF_MOVEMENT;
					break;
				}
				case Keyboard.DOWN:
				{
					_avatar.y += DISTANCE_OF_MOVEMENT;
					break;
				}
				case Keyboard.LEFT:
				{
					_avatar.x -= DISTANCE_OF_MOVEMENT;
					break;
				}
			}
			if (_avatar.x < 0 - _avatar.width/2) _avatar.x = stage.stageWidth + _avatar.width/2;
			if (_avatar.y < 0 - _avatar.height/2) _avatar.y = stage.stageHeight + _avatar.height/2;
			if (stage.stageWidth < _avatar.x - _avatar.width/2) _avatar.x = - _avatar.width/2;
			if (stage.stageHeight < _avatar.y - _avatar.height/2) _avatar.y = - _avatar.height/2;
		}
		
		/**
		 * MouseEvent.MOUSE_DOWN
		 * @param	event
		 */
		private function mouseDownHandler(event:MouseEvent):void
		{
			deactivate();
			if (_tween) 
			{
				_tween.removeEventListener(TweenEvent.COMPLETE, _tween_compleHandler);
				_tween.stop();
			}
			
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			var distanceX:Number = event.stageX - _avatar.x;
			var distanceY:Number = event.stageY - _avatar.y;
			
			var distance:Number = Math.sqrt(
				  Math.pow(distanceX, 2)
				+ Math.pow(distanceY, 2)
			);
			
			if (Math.abs(distanceX) <= Math.abs(distanceY))
			{
				if (distanceY < 0) _avatar.back();
				else _avatar.front();
			}
			else
			{
				if (distanceX < 0) _avatar.left();
				else _avatar.right();
			}
			_avatar.play();
			
			_tween = BetweenAS3.tween(
				_avatar,
				{x: event.stageX, y: event.stageY }, { x: _avatar.x, y:_avatar.y },
				distance * 0.005, Sine.easeOut
			);
			_tween.addEventListener(TweenEvent.COMPLETE, _tween_compleHandler);
			_tween.play();
		}
		
		/**
		 * MouseEvent.MOUSE_UP
		 * @param	event
		 */
		private function mouseUpHandler(event:MouseEvent):void
		{
			activate();
		}
		
		/**
		 * TweenEvent.COMPLETE
		 * @param	event
		 */
		private function _tween_compleHandler(event:TweenEvent):void
		{
			_tween.removeEventListener(TweenEvent.COMPLETE, _tween_compleHandler);
			_avatar.stopComplete();
		}
	}
}

import flash.display.Sprite;
import flash.display.Loader;
import flash.events.DataEvent;
import flash.events.Event;
import flash.net.URLRequest;

/**
 * Avatar
 */
class Avatar extends Sprite
{
	//--------------------------------------------------------------------------
	//  properties
	//--------------------------------------------------------------------------
	//----------------------------------
	//  public properties
	//----------------------------------
	private var _color:uint = 0x000000;
	/**
	 * color
	 */
	public function get color():uint
	{
		return _color;
	}
	/** @prviate */
	public function set color(value:uint):void
	{
		_color = value;
		if (_avatarBody) _avatarBody.color = _color;
	}
	
	//----------------------------------
	//  private properties
	//----------------------------------
	/**
	 * avatar body
	 */
	private var _avatarBody:*;
	
	//--------------------------------------------------------------------------
	//  methods
	//--------------------------------------------------------------------------
	//----------------------------------
	//  public methods
	//----------------------------------
	/**
	 * constructor
	 */
	public function Avatar():void
	{
		
	}
	
	/**
	 * load AvatarBody
	 * @param	url
	 */
	public function loadBody(url:String):void
	{
		var loader:Loader = new Loader();
		loader.contentLoaderInfo.addEventListener(
			Event.COMPLETE, loaderInfo_completeHandler
		);
		loader.load(new URLRequest(url));
	}
	
	public function front():void
	{
		if (_avatarBody) _avatarBody.front();
	}
	
	public function back():void
	{
		if (_avatarBody) _avatarBody.back();
	}
	
	public function right():void
	{
		if (_avatarBody) _avatarBody.right();
	}
	
	public function left():void
	{
		if (_avatarBody) _avatarBody.left();
	}
	
	public function play():void
	{
		if (_avatarBody) _avatarBody.play();
	}
	
	public function stop():void
	{
		if (_avatarBody) _avatarBody.stop();
	}
	
	public function stopComplete():void
	{
		if (_avatarBody) _avatarBody.stopComplete();
	}
	
	//--------------------------------------------------------------------------
	//  event handler
	//--------------------------------------------------------------------------
	//----------------------------------
	//  private event handler
	//----------------------------------
	/**
	 * 
	 * @param	event
	 */
	private function loaderInfo_completeHandler(event:Event):void
	{
		var loader:Loader = Loader(event.target.loader);
		loader.contentLoaderInfo.removeEventListener(
			Event.COMPLETE, loaderInfo_completeHandler
		);
		
		_avatarBody = loader.content;
		_avatarBody.x = - _avatarBody.width / 2;
		_avatarBody.y = - _avatarBody.height / 2;
		addChild(_avatarBody);
		dispatchEvent(new DataEvent(Event.COMPLETE, false, false, "body"));
	}
}
