/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ygFF
 */

// forked from WLAD's forked from: Ths Sum of all Possibilities - 2D
// forked from greentec's Ths Sum of all Possibilities - 2D
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import frocessing.color.ColorHSV;
    import flash.filters.BlurFilter;
    
    public class FlashTest extends Sprite {
        public var _bitmapData:BitmapData;
        public var _bitmap:Bitmap;
        
        public var circleArray:Array;
        public var velocityArray:Array;
        
        
        public var container:Sprite;
        
        public var count:int = 47;
        
        public function FlashTest() {
            // write as3 code here..
            
            stage.scaleMode = "noScale";
            
            _bitmapData = new BitmapData(465, 465, false, 0x000000);
            _bitmap = new Bitmap(_bitmapData);
            addChild(_bitmap);
            
            container = new Sprite();
            addChild( container );
            
            circleArray = [];
            velocityArray = [];
            var i:int;
            var shape:Shape;
            for (i = 0; i < count; i += 1)
            {
                shape = new Shape();
                
                shape.graphics.beginFill(0xdddddd);
                
                DrawSolidArc(shape.graphics, 0, 0, 465 / 2 - (i + 0.5) * 10, 465 / 2 - i * 10, 0 / 360, 90 / 360, 20);
                shape.x = 465 / 2;
                shape.y = 465 / 2;
                
                shape.alpha = 0.8;
                
                container.addChild(shape);
                
                circleArray.push(shape);
                
                
                
                velocityArray.push((i + 1) / ( count * 2 ));
            }
            
            addEventListener(Event.ENTER_FRAME, onLoop);
            stage.addEventListener('mouseMove', function(e:*):void{
                    mx = (( stage.mouseX - (stage.stageWidth >> 1) ) / (stage.stageWidth >> 1));
            });
            container.filters= [new BlurFilter(
                4   // blurX
                ,4    // blurY
                ,1    // quality
            )];
        }
        
        private var mx:Number = .1;
        
        private function onLoop(e:Event):void
        {
            var s:Number =  mx * 100;
            var i:int;
            var shape:Shape;
            for (i = 0; i < count; i += 1)
            {
                shape = circleArray[i];
                shape.rotation += velocityArray[i] * s;
                
                //http://wonderfl.net/c/jxd6
                
                shape.graphics.clear();
                shape.graphics.beginFill( new ColorHSV( shape.rotation + s , 1, 1).toRGB().value);
          
                DrawSolidArc(shape.graphics, 0, 0, 465 / 2 - (i + 0.5) * 10, 465 / 2 - i * 10, 0 / 360, 90 / 360, 20);
            }
        }
        
        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //
        // The DrawSolidArc function takes standard arc drawing
        // arguments but the "radius" has been split into 2 different
        // variables, "innerRadius" and "outerRadius".
        private function DrawSolidArc (g:Graphics, centerX:Number, centerY:Number, innerRadius:Number, outerRadius:Number, startAngle:Number, arcAngle:Number, steps:int):void
        {
            var twoPI:Number = 2 * Math.PI;
            //
            // How much to rotate for each point along the arc.
            var angleStep:Number = arcAngle/steps;
            //
            // Variables set later.
            var angle:Number, i:int, endAngle:Number;
            //
            // Find the coordinates of the first point on the inner arc.
            var xx:Number = centerX + Math.cos(startAngle * twoPI) * innerRadius;
            var yy:Number = centerY + Math.sin(startAngle * twoPI) * innerRadius;
            //
            // Store the coordiantes in an object.
            var startPoint:Object = {x:xx, y:yy};
            
            with (g)
            {
                // Used to convert angles to radians.
                
                //
                // Move to the first point on the inner arc.
                moveTo(xx, yy);
                //
                // Draw all of the other points along the inner arc.
                for(i=1; i<=steps; i++){
                    angle = (startAngle + i * angleStep) * twoPI;
                    xx = centerX + Math.cos(angle) * innerRadius;
                    yy = centerY + Math.sin(angle) * innerRadius;
                    lineTo(xx, yy);
                }
                //
                // Determine the ending angle of the arc so you can
                // rotate around the outer arc in the opposite direction.
                endAngle = startAngle + arcAngle;
                //
                // Start drawing all points on the outer arc.
                for(i=0; i<=steps; i++){
                    //
                    // To go the opposite direction, we subtract rather than add.
                    angle = (endAngle - i * angleStep) * twoPI;
                    xx = centerX + Math.cos(angle) * outerRadius;
                    yy = centerY + Math.sin(angle) * outerRadius;
                    lineTo(xx, yy);
                }
                //
                // Close the shape by drawing a straight
                // line back to the inner arc.
                lineTo(startPoint.x, startPoint.y);
            }
        }
    }
}