/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xMUz
 */

package 
{    
    import com.bit101.components.HUISlider;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    
    public class FlashTest extends Sprite 
    {
        private var p1:Point;
        private var p2:Point;
        private var p3:Point;
        
        private var angle:Number = 0;
        
        private var A:ColorBox;
        private var tA:Text;
        private var B:ColorBox;
        private var tB:Text;
        private var C:ColorBox;
        private var tC:Text;
        
        public function FlashTest() 
        {    
            A = new ColorBox( 1, 0x00FFFF );    addChild( A );
            B = new ColorBox( 1, 0xFFCC00 );    addChild( B );
            C = new ColorBox( 1, 0xFF00FF );    addChild( C );
            
            tA = new Text();        addChild(tA);         
            tB = new Text();        addChild(tB); 
            tC = new Text();        addChild(tC); 
            
            tA.filters = tB.filters = tC.filters = [new GlowFilter(0xFFFFFF, 1, 3,3,4,1)];
            
            // bottom left point
            p1 = new Point(SW * 0.35, SH * 0.65);
            // bottom right point
            p2 = new Point(SW * 0.65, SH * 0.65);
            // top right edge
            p3 = new Point(SW * 0.65, SH * 0.35);
            
            with(new HUISlider( this, SW / 2, 5, "A", function(e:*):void
            {
                var s:* = e.target;
                p2.x = p3.x = p1.x + s.value;
            })) {
                minimum = ColorBox.size * 2;
                maximum = ColorBox.size * 6;
            }
            
            with(new HUISlider( this, SW / 2, 25, "B", function(e:*):void
            {
                var s:* = e.target;
                p3.y = p1.y - s.value;
            })) {
                minimum = ColorBox.size * 2;
                maximum = ColorBox.size * 6;
            }
            
            addEventListener(Event.ENTER_FRAME, updateTriangle);
        }
        
        private function updateTriangle(e:Event):void 
        {
            tA.x = A.x = p1.x;
            tA.y = A.y = p1.y;
            
            var v:Number;
            
            v = ( p2.x - p1.x ) / ColorBox.size;
            if ( A.value != v ) A.value = v;
            tA.text = v.toFixed(4);
            
            tB.x = B.x = p2.x;
            tB.y = B.y = p3.y;
            
            v = ( p2.y - p3.y ) / ColorBox.size;
            if ( B.value != v ) B.value = v;
            tB.text = v.toFixed(4);
            
            C.x = p1.x;
            C.y = p1.y;
            
            C.scaleY = -1;
            
            v = Point.distance( p3, p1 ) / ColorBox.size;
            if ( C.value != v ) C.value = v;
            tC.text = v.toFixed(4);
            
            var p:Point = C.localToGlobal( new Point(0, C.value * ColorBox.size));
            
            tC.x = p.x;
            tC.y = p.y;
            
            angle = Math.atan2( p3.y - p1.y, p3.x - p1.x );
            
            C.rotation = angle * 180 / Math.PI;
            
            graphics.clear();
            
            graphics.beginFill( 0xE0DAAB );
            graphics.moveTo( p1.x, p1.y );
            graphics.lineTo( p2.x, p2.y );
            graphics.lineTo( p3.x, p3.y );
            graphics.lineTo( p1.x, p1.y );
            graphics.endFill();
        }
    }
}
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;

var SW:int = 465, SH:int = 465;

class ColorBox extends Sprite
{
    public var color:uint;
    private var _value:Number;
    
    public static const size:int = 25;
    
    public function ColorBox( value:Number, color:uint )
    {
        this.color = color;
        this.value = value;
        
    }
    
    public function get value():Number 
    {
        return _value;
    }
    
    
    public function set value(value:Number):void 
    {
        _value = value;
        
        graphics.clear();
        
        graphics.lineStyle(0.1, 0xFFFFFF);
        
        var vs:Number = value * size;
        
        // t.width = t.height = vs;
        
        var ls:Number = (size * (value % 1));
        
        var w:Number;
        var h:Number;
        
        for (var y:int = 0; y < vs; y += size)
        {
            for (var x:int = 0; x < vs; x += size)
            {
                graphics.beginFill(color);
                
                // x + size = vs
                // size = vs - x
                
                // w = x + size; w = w > vs ? x - vs : w;
                // h = y + size; h = h > vs ? y - vs : h;
                
                w = (x + size > vs) ? ls : size;
                h = (y + size > vs) ? ls : size;
                
                graphics.drawRect( x , y , w, h );
                graphics.endFill();
            }
        }
        
    }
}

class Text extends TextField
{
    public function Text( t:String  = "" )
    {
        super();
        mouseEnabled = false;
        cacheAsBitmap = true;
        wordWrap = multiline = false;
        autoSize = 'left';
        defaultTextFormat = new TextFormat("_sans", 14, 0x0, true); 
        text = t;
    }
}