/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xAli
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;

	[SWF(framerate="30",width="480",height="480",backgroundColor="0x000000")]
	public class Practice65 extends Sprite
	{
		private var val1:int = 0;
		private var radius:Number = 240;
		private var centerX:Number = 240;
		private var centerY:Number = 240;
		private var vec:Point = new Point(2,1.5);
		
		public function Practice65() {
			stage.addEventListener(MouseEvent.MOUSE_MOVE, move);
			stage.addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function move(e:MouseEvent):void {
			centerX = e.stageX;
			centerY = e.stageY;
		}
		
		private function update(e:Event):void {
			val1 += 10;
			updateImage(val1);
			centerX += vec.x;
			centerY += vec.y;
			if (centerX < 0||centerX>480) vec.x *= -1;
			if (centerY < 0||centerY>480) vec.y *= -1;
		}
		
		private function updateImage(val:Number):void {
			var rad:Number = Math.PI/180.0*(val % 360);
			var xx:Number = Math.cos(rad)*radius+radius;
			var yy:Number = Math.sin(rad)*radius+radius;
			addCircle(xx, yy);	
		}
		
		private function addCircle(cx:Number,cy:Number ):void {
			var r:int = Math.ceil(Math.random() * 20) + 10;
			var circle:Circle = new Circle(cx, cy, r, getColor(), centerX, centerY);
			this.addChild(circle);
		}
		
		private var id:int = 0;
		private function getColor():uint {
			var s:Number = 1.0;
			var h:Number = id / 60;
			id = (id + 5) % 360;
			var ii:Number = Math.floor(h);
			var ff:Number = h - ii;
			switch(ii) {
				case 0:
					return createColor(1.0, 1.0 - s * (1.0 - ff), 1.0 - s);
				case 1:
					return createColor(1.0 - s * ff, 1.0, 1.0 - s);
				case 2:
					return createColor(1.0 - s, 1.0, 1.0 - s * (1.0 - ff));
				case 3:
					return createColor(1.0 - s, 1.0 - s * ff, 1.0);
				case 4:
					return createColor(1.0 - s * (1.0 - ff), 1.0 - s, 1.0);
				default:
					return createColor(1.0, 1.0 - s, 1.0 - s * ff);
			}
		}
	
		private function createColor(rv:Number,gv:Number,bv:Number):uint {
			var rr:int = Math.max(0, Math.min(255, rv * 255));
			var gg:int = Math.max(0, Math.min(255, gv * 255));
			var bb:int = Math.max(0, Math.min(255, bv * 255));
			var color:uint = (rr << 16) + (gg << 8) + bb;
			return color;
		}
	}

}
import flash.display.MovieClip;
import caurina.transitions.Tweener;

class Circle extends MovieClip {
	
	public function Circle(x:int, y:int, r:int, c:int,cx:int,cy:int) {
		graphics.lineStyle(2, c) ;
		graphics.beginFill(c);
		graphics.drawCircle(x, y, r);
		graphics.endFill();
		Tweener.addTween( this, { x:cx, y:cy, scaleX:0.05, scaleY:0.05, time:320, useFrames:true, transition:"easeOutExpo",onComplete:complete});
	}
	
	private function complete():void {
		this.parent.removeChild(this);
	}
}