/**
 * Copyright tatsuhisa ( http://wonderfl.net/user/tatsuhisa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wQq0
 */

package {
    import flash.display.Sprite;
    import flash.display.BlendMode;
    import flash.events.Event;
    [SWF(backgroundColor="0x000000")]
    public class FlashTest extends Sprite {
        private var _awa:Array;
        private var _numAwa:int = 300;
        
        public function FlashTest() {
            _awa = [];
            
            for(var i:int = 0; i < _numAwa; i++)
            {
                var awa:Awa = new Awa(12 * Math.random(), 0xFFFFFF * Math.random());
                awa.blendMode = BlendMode.ADD;
                awa.centerX = Math.random() * stage.stageWidth;
                awa.centerY = stage.stageHeight + awa.height * 0.5;
                awa.update();
                awa.x = awa.px;
                awa.y = awa.py;
                addChild(awa);
                _awa.push(awa);
            }
            
            addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
        }
        
        private function _enterFrameHandler(event:Event = null):void
        {
            for(var i:int = 0; i < _numAwa; i++)
            {
                var awa:Awa = Awa(_awa[i]);
                awa.update();
                if(awa.y < -awa.height * 0.5 || awa.alpha <= 0)
                {
                    awa.reset();
                }
            }
        }
    }
}

import flash.display.Sprite;

class Awa extends Sprite
{
    public var color:uint;
    public var size:uint;
    public var v:Number = 0;
    public var angle:Number = 0;
    public var speed:Number;
    public var rangeX:Number;
    public var rangeY:Number;
    public var centerX:Number = 0;
    public var centerY:Number = 0;
    public var px:Number = 0;
    public var py:Number = 0;
    public function Awa(size:uint, color:uint)
    {
        this.color  = color;
        this.size = size;
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, size);
        graphics.endFill();
        v = Math.random() * 2;
        speed = Math.random() * 2 - 1;
        alpha = Math.random() * 0.7 + 0.2;
        rangeX = Math.random() * 10;
        rangeY = Math.random() * 20;
    }
    
    public function update():void
    {
        centerY -= v;
        angle += speed;
        px = Math.sin(angle*Math.PI/180) * rangeX + centerX;
        py = Math.cos(angle*Math.PI/180) * rangeY + centerY;
        alpha -= 0.001;
        x = px;
        y = py;
    }
    
    
    public function reset():void
    {
        v = Math.random() * 2;
        speed = Math.random() * 2 - 1;
        alpha = Math.random() * 0.7 + 0.2;
        rangeX = Math.random() * 10;
        rangeY = Math.random() * 20;
        centerX = Math.random() * stage.stageWidth;
        centerY = stage.stageHeight + height * 0.5;
        px = Math.sin(angle*Math.PI/180) * rangeX + centerX;
        py = Math.cos(angle*Math.PI/180) * rangeY + centerY;
        alpha = Math.random() * 0.7 + 0.2;
        x = px;
        y = py;
    }
    
    
}