/**
 * Copyright brendansean ( http://wonderfl.net/user/brendansean )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wQIs
 */

// forked from kazutoyo's TexTween
package {
	
	/**
    * 
    * @author kazutoyo@富山商船コンピュータ部
    * 株式会社ノデラのインターンシップ中に作ってみました。
    * 画面をクリックでリセットします。
    *
    */
	
    import flash.display.*;
    import flash.events.Event;
	import flash.events.MouseEvent;

    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.typography.Text3D;
    import org.papervision3d.typography.fonts.HelveticaBold;
    import org.papervision3d.view.Viewport3D;

	import caurina.transitions.Tweener;
	[SWF(width="800", height="600")]
    public class TexTween extends Sprite {
		private var w:Number = stage.stageWidth;
		private var h:Number = stage.stageHeight;
    	private var viewport:Viewport3D;
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var renderer:BasicRenderEngine;
		public var letterformat:Letter3DMaterial;
		public var textdata:Text3D;

		public function TexTween() {
			start();
			stage.addEventListener(MouseEvent.MOUSE_DOWN, reset);
		}
		
        public function start():void {
			var text:String = "COMRADE";
			viewport = new Viewport3D(w, h);
			addChild(viewport);//viewportを表示ツリーに追加

			renderer = new BasicRenderEngine();
			scene = new Scene3D();
			camera = new Camera3D();

			//文字の設定　引数は色コード・透過度
			letterformat = new Letter3DMaterial(Math.random()*0xffffff);
			letterformat.interactive;
			letterformat.doubleSided = true;
			
			//表示文字内容の設定
			//引数は表示文字・フォント・Letter3DMaterial
			textdata = new Text3D(text , new HelveticaBold() , letterformat);
			
			textdata.x = Math.random() * (w / 2) ;
			textdata.y = Math.random() * (h / 2);
			textdata.z = -150;
			
			scene.addChild(textdata);
			
			Tweener.addTween(textdata, {
				time:2,
				rotationX: 1440,
				rotationY: 720,
				rotationZ: -1080,
				x: 0,
				y: 0,
				z: Math.random()*150,
				scaleX: 3.5,
				scaleY: 3.5,
				transition: "easeInOutBack"
			});

			//ENTER_FRAMEイベント定義
			addEventListener(Event.ENTER_FRAME , onEnterFrame);

		}
		
		private function reset(event:MouseEvent):void {
			removeChild(viewport);
			scene.removeChild(textdata);
			removeEventListener(Event.ENTER_FRAME, onEnterFrame);
			start();
		}

        private function onEnterFrame(event:Event):void {
        	renderer.renderScene(scene,camera,viewport);
        }
	}
}