/**
 * Copyright yoshihiko ( http://wonderfl.net/user/yoshihiko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wFdL
 */

//1/fゆらぎを使って、点灯するライトを作成してみました。
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    
    [SWF(backgroundColor=0x000000, frameRate=60)]
    public class Light extends Sprite{
        
        private var _circle:Sprite;
        private var _oof:OneOverF;
        
        public function Light() {
            ready();
            start();
        }
        
        public function ready():void {
			_circle = new Sprite();
			_circle.graphics.beginFill(0xFFE16A);
			_circle.graphics.drawCircle(stage.stageWidth / 2, stage.stageHeight / 2, 40);
			_circle.graphics.endFill();
			_circle.alpha = 0.5;
			addChild(_circle);
			
			_oof = new OneOverF();
		}
		public function start():void{
		    this.addEventListener(Event.ENTER_FRAME,loop);
		}
		
		private function loop(e:Event):void
		{	
			var noise:Number = _oof.getNoise();
			var bSize:Number = noise * 4;
			var gSize:Number = noise * 8;
			
			var bFilter:BlurFilter=new BlurFilter();
			bFilter.blurX  = bSize + 10;
			bFilter.blurY  = bSize + 10;
			bFilter.quality = BitmapFilterQuality.HIGH;
			
			var gFilter:GlowFilter = new GlowFilter();
			gFilter.blurX = gSize+20;
			gFilter.blurY = gSize+20;
			gFilter.color  = 0xFF9933
			gFilter.quality = BitmapFilterQuality.HIGH;
			
			var myFilters:Array=new Array();
			myFilters.push(bFilter);
			myFilters.push(gFilter);
			
			_circle.filters = myFilters;
			
			_circle.alpha = noise*0.8 + 0.1;
		}
    }
}
 
/**
 * 1/f ゆらぎ
 */
class OneOverF{
    private var _t:Number, _tt:Number;
	
    public function OneOverF()
    {
    	_t = Math.random();
		_tt = 0;
    }
	
    //0 - 1のゆらぎを返す
    public function getNoise():Number
    {
		if (0 < _t && _t< 0.5) {
			_tt = _t + 2 * _t * _t;
		} else if (0.5 <= _t && _t< 1) {
			_tt = _t - 2 * (1 - _t)* (1 - _t);
		}
		_t = _tt;
		
		return _t;
    }
}
