/**
 * Copyright Nowloading_ ( http://wonderfl.net/user/Nowloading_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vXzG
 */

package {
    import flash.display.DisplayObject;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.*;
    import flash.events.*;
    [SWF(backgroundColor = 0x000000)]
    public class mf extends BasicView {
        //cube = Fieldの部品格納用オブジェクト
        private var field:DisplayObject3D;
        //地形参照用配列:Field[x軸の個数][z軸の個数]
        //0=green,1=brown, 2=blue
        //上部の迂路の指定
        private var uField:Array = [[0,0,0,1,1],
                                    [0,0,1,2,2],
                                    [0,1,2,2,2],
                                    [0,1,1,2,2],
                                    [0,0,1,2,2],
                                   ];
        //下部の色の指定
        private var dField:Array = [[1,1,1,1,1],
                                    [1,1,1,1,2],
                                    [1,1,1,2,2],
                                    [1,1,1,1,2],
                                    [1,1,1,2,2],
                                   ];
        //各cubeの高さ
        private var high:Array = [[3,2,1,1,2],
                                  [2,1,0,0,0],
                                  [1,0,0,0,0],
                                  [1,1,0,0,0],
                                  [2,1,1,0,0],
                                 ];
        //Cube用material,primitive
        private var gr:ColorMaterial = new ColorMaterial(0x60ff60);
        private var br:ColorMaterial = new ColorMaterial(0xd0a080);
        private var bl:ColorMaterial = new ColorMaterial(0xd0ddff);
        private var g:MaterialsList = new MaterialsList( { all:gr } );
        private var l:MaterialsList = new MaterialsList( { all:br } );
        private var b:MaterialsList = new MaterialsList( { all:bl } );
        //格納用
        private var materials:Array = [g,l,b];
        //表面用と下部用のcube
        private var ucube:Cube;
        private var dcube:Cube;
        //cube sizeと間隔;
        private var wide:int = 50;
        private var dx:int = 5;
        
        //palne = charaの部品格納用オブジェクト
        private var chara:DisplayObject3D;
        //Plane用
        private var material:WireframeMaterial = new WireframeMaterial(0xcc0000,3);
        private var material2:WireframeMaterial = new WireframeMaterial(0x0000cc,3);
        private var plane:Plane;
        private var haiti:Array = [[1,0,0,0,2],
                                   [0,1,0,0,0],
                                   [1,0,0,0,0],
                                   [0,0,0,0,2],
                                   [2,2,0,0,0],
                                  ];
                                   
        //radiun
        private var rad:int = 0;     

        public function mf() {
            init();
        }
        private function init():void{
            material.doubleSided = true;
            material2.doubleSided = true;
            field = new DisplayObject3D;
            chara = new DisplayObject3D;
            scene.addChild(field);
            scene.addChild(chara);
            //materialslistの作成
            for(var i:int = 0; i<uField.length; i++){
                for(var j:int = 0; j<uField[0].length; j++){
                    ucube = new Cube(materials[uField[i][j]],wide,wide,15);
                    dcube = new Cube(materials[dField[i][j]],wide,wide,35);
                    //位置設定(floorは切り捨て)
                    ucube.x = dcube.x = -((wide+dx)*Math.floor(uField.length/2)) + ((wide+dx)*i);
                    ucube.z = dcube.z = -((wide+dx)*Math.floor(uField[0].length/2)) + ((wide+dx)*j);
                    ucube.y = dcube.y = (high[i][j]*25);
                    ucube.y += 25;
                    field.addChild(ucube,"UCx_"+i+"z_"+j);
                    field.addChild(dcube,"DCx_"+i+"z_"+j);
                    //charaの追加
                    if(haiti[i][j] != 0){
                        if(haiti[i][j] == 1){
                            plane = new Plane(material,40,60,4,8);
                        }else if(haiti[i][j] == 2 ){
                            plane = new Plane(material2,40,60,4,8);
                        }
                        plane.x = -((wide+dx)*Math.floor(uField.length/2)) + ((wide+dx)*i);
                        plane.z = -((wide+dx)*Math.floor(uField[0].length/2)) + ((wide+dx)*j);
                        plane.y = ucube.y + 55;
                        chara.addChild(plane, "cx_"+i+"_z"+j);
                    }

                }
            }   
            camera.y = 250;
            camera.z = -200;
            startRendering();
            addEventListener(Event.ENTER_FRAME,oEF);
        }
        private function oEF(e:Event):void{
            camera.x = 250*Math.sin(rad*Math.PI/180);
            camera.z = -250*Math.cos(rad*Math.PI/180);
            rad += 2;
            if ( rad>=360){
                rad =0;
            }
        }
    }
}