/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/udQy
 */

package {
    
    import flash.geom.Matrix3D;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.display.Sprite;
    [SWF(width=465,height=465,frameRate=30)]
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            x = stage.stageWidth/2
            y = stage.stageHeight/2
            
            var length:Number = 100
            var points:Vector.<Vector3D> = new Vector.<Vector3D>()            
            points.push(new Vector3D(length,0,0))
            points.push(new Vector3D(-length,0,0))
            points.push(new Vector3D(0,length,0))
            points.push(new Vector3D(0,-length,0))
            points.push(new Vector3D(0,0,length))
            points.push(new Vector3D(0,0,-length))

            var container:Sprite= new Sprite()
            var shapes:Vector.<Shape> = new Vector.<Shape>()            
            var rect_size:int = 80
            for (var i:int; i<points.length; i++) {
                shapes.push(new Shape)
                shapes[i].graphics.beginFill(0xff0000 + Math.random()*0xff00)                
                shapes[i].graphics.drawRect(-rect_size/2, -rect_size/2,rect_size,rect_size)
                shapes[i].x = points[i].x
                shapes[i].y = points[i].y
                shapes[i].z = points[i].z
                shapes[i].rotationX = Math.atan2(points[i].y,points[i].z)* 180/Math.PI
                shapes[i].rotationY = Math.atan2(points[i].x,points[i].z)* 180/Math.PI
                container.addChild(shapes[i])
            }            
            addChild(container)           
                    
             var theta:int = 0
            addEventListener(Event.ENTER_FRAME, loop)                                      
            function loop(e:Event):void {
                theta += Math.sqrt(Math.pow(mouseX,2)+Math.pow(mouseY,2))/35
                theta %= 360
                var tilt:Number = 180-Math.atan2(mouseX,mouseY)*20*Math.PI
                var matrix:Matrix3D = new Matrix3D              
                matrix.appendRotation(theta,Vector3D.Y_AXIS)    
                matrix.appendRotation(tilt,Vector3D.Z_AXIS)                
                var sort_items:Array = new Array
                var i:int
                for (i=0; i<points.length; i++) {
                    var vector:Vector3D = matrix.transformVector(points[i])
                    vector.w = i
                    sort_items.push(vector)
                    container.removeChild(shapes[i])                    
                }
                sort_items.sortOn("z", Array.NUMERIC | Array.DESCENDING)
                for (i=0; i<points.length; i++) {
                    container.addChild(shapes[sort_items[i].w])
                }                                 
                container.rotationY = theta
                container.rotationZ = tilt        
            }  
        }
    }
}
