/**
 * Copyright megane_bomb1 ( http://wonderfl.net/user/megane_bomb1 )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/tMJd
 */

package {
    import flash.display.*;
    import flash.net.*;
    import flash.events.*;
    import flash.system.*;
    import flash.text.*; 
    import com.demonsters.debugger.MonsterDebugger;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.FilterShortcuts;   
    
    [SWF(backgroundColor="0",frameRate ="30")]
    public class Main extends Sprite {
        private var scale:Number;
        private var index:int = 0;
        private var msg:TextField = new TextField();        
        private var frame_count:int = 0;
        private var stage_size:int = 465;
                   
        //sprite
        private var navi:Sprite = new Sprite();
        private var container:Sprite = new Sprite(); 
        //class
        public var xml:XmlLoad = new XmlLoad();
        public var img:ImgView = new ImgView();
        public var btn:Button = new Button();

        //コンストラクタ         
        public function Main():void {
          addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event):void{
           removeEventListener(Event.ADDED_TO_STAGE, init);
            //フォーカスあたらんんんんんんんんn
            stage.focus = btn.search_text;
            
          stage.addEventListener( Event.RESIZE,  resizeH);
          MonsterDebugger.initialize(stage); 
          FilterShortcuts.init(); 
          xml.addEventListener("myEvent",loop);  
          xml.addEventListener("fall",fall);            
          btn.addEventListener("search",search);
          setStage();
          xml.url_str = "http://api.flickr.com/services/rest?api_key=d66685810fb12432a61842b076228d2e&method=flickr.photos.search&tags=flower&size=medium";
          xml.loadxml();
  
          //sprite 順番
          stage.addChild(container);         
          stage.addChild(navi);
          navi.addChild(btn);
        }
 
        private function setStage():void {
           stage.quality = "BEST";
           stage.scaleMode = StageScaleMode.NO_SCALE;
           stage.align = StageAlign.TOP_LEFT;
           CopyStage.stage = stage;
        }
        
        //100フレエームごとに呼び出す
        private function time(event:Event):void{
             frame_count +=1;
             var count:int = 100 * img.width_s * 0.8;
             if(frame_count % count == 0){
                 loop(event);
             }
        }
        
        //変更された比率を格納する(リサイズ時)  
        private function resizeH(event:Event):void{
             scale = stage.stageWidth / stage_size ;
             stage_size = stage.stageWidth;
             for(var i:int = container.numChildren; i > 0; i-- ){
                  var s:Sprite = new Sprite();
                  s = Sprite(container.getChildAt(i-1));
                  s.scaleX  = s.scaleY = s.scaleX * scale;       
             }
        }
            
        private function search(event:Event):void{
            xml.text = event.target.search_text.text;
            xml.url_str = "http://api.flickr.com/services/rest?api_key=d66685810fb12432a61842b076228d2e&method=flickr.photos.search&tags="+ event.target.search_text.text + "&size=medium";
            xml.loadxml();
        }
        private function fall(event:Event):void{
            var format:TextFormat = new TextFormat(); 
            format.color = 0xFFFFFF; 
            format.font = "Verdana"; 
            format.size = 20 * (stage.stageWidth/465); 
            format.align = TextFormatAlign.CENTER;
            msg.defaultTextFormat = format;
            msg.width = stage.stageWidth;
            msg.height = 25 + (20 * (stage.stageWidth/465));
            msg.y = -100;
            msg.text = xml.text;
            navi.addChild(msg);
            Tweener.addTween(msg,{y:stage.stageHeight,onComplete:remove_text,time:3,transition:"easeOutBounce"});     
        }
        
        private function remove_text():void{
            navi.removeChild(msg);
        }

        //画像まわす
        private function loop(event:Event):void{
           if( xml.imageUrl_arr.length == index){
                index = 0;
           }    
           img = new ImgView();
           img.addEventListener("sprite",addimg);  
           img.index = index;
           img.width_s = (stage.stageWidth/465) * 0.7;
           if(img.width_s < 1){
               img.width_s = 1;
           }
           img.imageUrl_arr =  xml.imageUrl_arr;                  
           img.img_addchild();
           index = index + 1;
        }
        
        private function addimg(event:Event):void{
            event.target.removeEventListener("sprite",addimg);
            container.addChild(event.target.sprite);
            change(event);
            event.target.sprite.addEventListener( Event.ENTER_FRAME, img_down );
            stage.addEventListener( Event.ENTER_FRAME, time );
        }
        
        private function change(event:Event):void{
              for(var i:int = container.numChildren; i > 0; i-- ){
                  var s:Sprite = new Sprite();
                  s = Sprite(container.getChildAt(i-1));
                  if(event.target.sprite.scaleY < s.scaleY){
                      container.setChildIndex(s,i);
                  }
             }
        }
        
        private function img_down(event:Event):void{
            event.target.y += event.target.id;
            if(event.target.y >= stage.stageHeight){
                 var sprite:Sprite = Sprite(event.target);
                 container.removeChild(sprite);
                 event.target.removeEventListener(Event.ENTER_FRAME, img_down );
            }
        }
        
    }
}












//----------------------------------------------------
// ImgView
//----------------------------------------------------
import flash.ui.ContextMenuItem;
import com.demonsters.debugger.MonsterDebugger;
import caurina.transitions.Tweener;
import caurina.transitions.properties.FilterShortcuts;
import flash.filters.BlurFilter;
import flash.events.*;
    
class ImgView extends EventDispatcher {  
        public var sprite:MovieClip;
        public var index:int;
        public var width_s:Number;
        
        public var imageUrl_arr:Array;   
        private var userID:String;
        private var ID:String;
        private var load_img:Loader;


        //画像loop
        public function img_addchild():void{
            var url_str:String;
            var url_img:URLRequest;
            url_str = imageUrl_arr[index].url;
            url_img = new URLRequest(url_str);
            var context:LoaderContext = new LoaderContext(true);  
            load_img = new Loader();  
            load_img.load(url_img,context);
            load_img.contentLoaderInfo.addEventListener( Event.COMPLETE , img_create ,false, 0, true);
            load_img.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIOError,false, 0, true);
        }
        
        //画像生成
        public function img_create(event:Event):void{
             var my_blur:BlurFilter = new BlurFilter();
             load_img.contentLoaderInfo.removeEventListener( Event.COMPLETE , img_create);
             userID = imageUrl_arr[index].userID;
             ID = imageUrl_arr[index].id;

             //bitmapをspriteに！(大切)
             sprite = new MovieClip();
             Bitmap(event.target.content).smoothing = true;
             sprite.addChild(event.target.content);
             
             //MouseEvent系
             sprite.addEventListener(MouseEvent.CLICK,jump);
             sprite.addEventListener(MouseEvent.ROLL_OVER,roll_over);
             sprite.addEventListener(MouseEvent.ROLL_OUT,roll_out);
             sprite.addEventListener(Event.REMOVED_FROM_STAGE,removeFunc);
             
             var it:int = CopyStage.stage.stageWidth - sprite.width;
             //ramdom
             sprite.scaleX = sprite.scaleY = ((3 + (Math.random() * 5)) / 10) * width_s;
             sprite.x = (Math.random()* (CopyStage.stage.stageWidth - sprite.width));
             sprite.y = 0 - sprite.height;
             var id:int;
             sprite.id = 1 + (Math.random() * 3);
             
             var blur:int = 10 - (sprite.scaleX * 10);               
             my_blur.blurX = my_blur.blurY = blur;    // 水平方向のぼかし量
             my_blur.quality = 1;    // ぼかしの実行回数
             sprite.filters = [my_blur];
             dispatchEvent(new Event("sprite"));
        }
        
        private function removeFunc(event:Event):void{
            var sprite:Sprite = Sprite(event.target);
            sprite.removeEventListener(MouseEvent.CLICK,jump);
            sprite.removeEventListener(MouseEvent.ROLL_OVER,roll_over);
            sprite.removeEventListener(MouseEvent.ROLL_OUT,roll_out);
            sprite.removeEventListener(Event.REMOVED_FROM_STAGE,removeFunc);
        }
        //マウスイベント系   
        public function jump(event:Event):void{
            var url:URLRequest = new URLRequest("http://www.flickr.com/photos/" + imageUrl_arr[index].userID + "/" + imageUrl_arr[index].id );
            navigateToURL (url);
        }
        public function roll_over(event:Event):void{
            event.target.alpha = 0.7;
        }
        public function roll_out(event:Event):void{
            event.target.alpha = 1;
        }
        //IOError
        private function onIOError(event:Event):void{
             load_img.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, onIOError);
        }

}


import flash.display.Stage;
class CopyStage {
    public static var stage:Stage;
}
    
    
    
    
    
    
    
    
    
//----------------------------------------------------
// XmlLoad
//----------------------------------------------------
import flash.display.*;
import flash.net.*;
import flash.events.*;
import flash.system.*;
import com.demonsters.debugger.MonsterDebugger;

//URL渡すだけで良いように変更する
class XmlLoad extends EventDispatcher {
    public var imageUrl_arr:Array = new Array();
    public var url_str:String;
    private var xmlloader:URLLoader = new URLLoader();  
    public var text:String = "";
    
    public function loadxml():void{
        var url:URLRequest = new URLRequest(url_str);
        xmlloader = new URLLoader(url);
        xmlloader.load(url);
        xmlloader.addEventListener (Event.COMPLETE,get_imgURL);
    }


    public function get_imgURL( event:Event ):void {
         xmlloader.removeEventListener (Event.COMPLETE,get_imgURL);
         var length:int = 0;
         //XMLDATA抽出
         var xml : XML =  XML(xmlloader.data);
         var xmlList:XMLList = xml.photos.photo;
         
         length = xmlList.length();

          if (length <= 1) {
                text = "no tag";
                dispatchEvent(new Event("fall"));   
          }else{
            dispatchEvent(new Event("fall"));
            imageUrl_arr = [];
            for(var i:int=0;i<length;i++){
                    var obj:Object = new Object();
                    var farm:String = xmlList[i].@farm;
                    var server:String = xmlList[i].@server;
                    var id:String = xmlList[i].@id;
                    var secret:String = xmlList[i].@secret;
                    var title:String = xmlList[i].@title;
                    var userID:String = xmlList[i].@owner;
    
                    var img_url:String = "http://farm" + farm + ".static.flickr.com/" + server + "/" + id + "_" + secret + "_m" +".jpg"; 
                    obj.url = img_url;
                    obj.title = title;
                    obj.userID = userID;
                    obj.id = id;
                               
                    imageUrl_arr.push(obj);
              }   
              dispatchEvent(new Event("myEvent"));         
          }
    }
}





//----------------------------------------------------
// Button
//----------------------------------------------------
import flash.text.*; 
import flash.events.*;
import com.demonsters.debugger.MonsterDebugger;

class Button extends Sprite{
       public var search_text:TextField = new TextField(); 
       public function Button():void {
            //text
            var format:TextFormat = new TextFormat(); 
            format.color = "0xFFFFFF"; 
            format.size = 10; 
            format.align = TextFormatAlign.LEFT;
            
            var tf:TextField =  new TextField();
            tf.defaultTextFormat = format;
            tf.x = 10;
            tf.y = 5;
            tf.width = 100;
            tf.text = "Please input tag name!";            
            tf.mouseEnabled = false; //これ大切！マウスイベントを受け取らないように設定  
            addChild(tf);
            
            //bottom
            var button : SimpleButton = new SimpleButton();        
            button.upState = makeRoundRect(0xffaa2b);
            button.overState = makeRoundRect(0xd58000);
            button.downState = makeRoundRect(0x553300);
            button.hitTestState = button.upState;
            button.addEventListener(MouseEvent.CLICK,search,false, 0, true);
            button.y = 25;
            button.x = 110;
            button.width = 40;
            addChild(button);
            
            //textfield
            search_text.addEventListener(KeyboardEvent.KEY_DOWN,push_enter,false, 0, true);
            search_text.background = true;
            search_text.width = 90;
            search_text.height = 20;
            search_text.y = 25;
            search_text.x = 10;
            search_text.type = "input";
            search_text.setSelection(0, 0);  
            addChild(search_text);
          }
          
        private function makeRoundRect(color:uint):Sprite{
            var s:Sprite = new Sprite();
            s.graphics.beginFill(color);
            s.graphics.drawRoundRect(0, 0, 100, 20, 15);
            s.graphics.endFill();
            s.alpha = 1;
            return s;
        }
        
        private function search(event:Event):void{
            if(search_text.text != ""){
                dispatchEvent(new Event("search"));     
            }
        }
        private function push_enter(event:KeyboardEvent):void{
             if(search_text.text != ""){
                 if(event.keyCode === 13){
                    dispatchEvent(new Event("search"));     
                }
             }
        }
}

    
    
    