/**
 * Copyright Jenya ( http://wonderfl.net/user/Jenya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/t7Sa
 */

// forked from shapevent's Ring
package {

    import flash.display.*;
    import flash.events.*;


    [SWF(width = 500, height=500)]

       public class Ring extends MovieClip {
        private var ring:MovieClip;


               public function Ring(){
                  // init
            ring = createRing();
            ring.x = stage.stageWidth / 2;
            ring.y = stage.stageHeight / 2;
            addChild(ring);
            
            
            

               }
               // private methods

        private function createRing(sectionNum:int = 30):MovieClip{
            var container:MovieClip = new MovieClip();
            container.circles = [];
            container.theta = 0;
            container.thetaDest = 0;
            var step:Number = (Math.PI * 2) / sectionNum;
            for (var i:int = 0; i<sectionNum; i++){
                var c:MovieClip = new MovieClip();
                with (c.graphics){
                    lineStyle(0,0x000000);
                    beginFill(0xCCCCCC);
                    drawCircle(0,0,20);
                }
                c.thetaOffset = step * i;
                container.addChild(c);
                container.circles.push(c);
            }
            container.addEventListener(Event.ENTER_FRAME, onRun);
            return container;
        }
        private function onRun(evt:Event):void {
            var container:MovieClip = MovieClip(evt.currentTarget);
            var num:int = container.circles.length;
            for (var i:int = 0; i<num; i++){
                var c:MovieClip = container.circles[i];
                var angle:Number = container.theta + c.thetaOffset;
                c.x = 200 * Math.cos(angle);
                c.y = 100 * Math.sin(angle);
                c.scaleX = (100 + c.y) / 120 + 0.2;
                c.scaleY = c.scaleX;
            }
            container.circles.sortOn("y", Array.NUMERIC);
            for (i = 0; i<num; i++){
                container.addChild(container.circles[i]);
            }
            if (container.mouseX < -100){
                container.thetaDest -= 0.05;
            }
            if (container.mouseX > 100){
                container.thetaDest += 0.05;
            }
            container.theta += (container.thetaDest  - container.theta) / 12;
            
        }
        

       }

}