/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/swbX
 */

// forked from TechnicalSamurai's forked from: Thurs grow 3D(伸びてゆく木 PV3D)
// forked from OKASUKE's Thurs grow 3D(伸びてゆく木 PV3D)
/**
 * Thurs grow 3D(伸びてゆく木 PV3Dバーション)
 * 枝の成長する順番もシンメトリーにするように考えんといかん・・・ぬぅ
 * 2010/06/29 OKASUKE 
 * 木が完成するまで約60秒、消えるまで約60秒かかります。
 * 
 */
package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;    
    
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.render.BasicRenderEngine;
    
    import org.papervision3d.materials.special.LineMaterial;
    import org.papervision3d.core.geom.Lines3D;
    import org.papervision3d.core.geom.renderables.Line3D;
    import org.papervision3d.core.utils.Mouse3D;
    
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;    
    import org.libspark.betweenas3.events.TweenEvent;    
    import net.hires.debug.Stats;
      
    public class WonTest extends BasicView
    {
        private var _lineMat:LineMaterial = new LineMaterial(0x000000, 1);    
        private var _line1:Lines3D = new Lines3D(_lineMat);    
        private var _baseline:Lines3D = new Lines3D(_lineMat);
    
        private var _N:uint = 6;
        private var _point1X:Number = 0;
        private var _point1Y:Number = -200;
        private var _point1Z:Number = 0;
    
        private var _leng:Number = 100;
        private var _angle:Number = 90;        
        private var _scale:Number = 1.2;
        private var _branch:Number = 20;
        private var _noise:Number = 90;
        
        private var _t:ITween;

private static const _PI:Number = Math.PI / 180;
        
        public function WonTest() 
        {            
            base();
            tree(_N, _point1X, _point1Y, _point1Z, _leng, _angle);
        
            var delay:Number = 0.0;            
            
            var num:uint = _line1.lines.length;
            var arrtweens:Array = new Array(num);
            var sx:Number = 0, sy:Number = 0, sz:Number = 0;
            var ex:Number = 0, ey:Number = 0, ez:Number = 0;
            for (var i:uint = 0; i < num; ++i) {
                var line:Line3D = _line1.lines[i];                
                sx = line.v0.x, sy = line.v0.y, sz = line.v0.z;
                //ex = line.v1.x, ey = line.v1.y, ez = line.v1.z;
                
                var lines1:Lines3D = new Lines3D();
                scene.addChild(lines1);                
                lines1.addLine(line);
                arrtweens[i] = BetweenAS3.delay(BetweenAS3.tween(lines1, null, { x:sx, y:sy, z:sz, scaleX:0, scaleY:0, scaleZ:0}, 0.1, Quint.easeInOut), 0.4 + 0.2 * i);
            }
            var it:ITween = BetweenAS3.parallelTweens(arrtweens);
                
            _t = BetweenAS3.serial(
                it,
                BetweenAS3.delay(BetweenAS3.reverse(it), 3)
            );
            
            _t.play();            
            //addChild(new Stats());

                            Wonderfl.capture_delay(62);
            addEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mdown);            
            startRendering();            
        }
            
        private function base():void {
            _baseline.addNewLine(1, 0, -200, 0, 100, -200,  0);    
            _baseline.addNewLine(1, 100, -200, 0, 100, -200, 100);
            _baseline.addNewLine(1, 100, -200, 100, 0, -200, 100);
            _baseline.addNewLine(1, 0, -200, 100, 0, -200, 0);
            _baseline.x -= 50;
            _baseline.z -= 50;        
            scene.addChild(_baseline);
        }
        
        private var _rot:Number = 0;
        private function loop(e:Event = null):void {            
            _rot += 1.2;            
            camera.x = 500 * Math.sin(_rot * Math.PI / 180);
            camera.z = 500 * Math.cos(_rot * Math.PI / 180);            
        }
        
        private function mdown(e:Event):void {
            removeEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(MouseEvent.MOUSE_UP, mup);
        }
        
        private function mup(e:Event):void {
            removeEventListener(MouseEvent.MOUSE_UP, mup);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function tree(n:Number, x0:Number, y0:Number, z0:Number, leng:Number, angle:Number):void {
            
            if (n <= 0)
                return;
                
            var noiseX:Number = angle-((_noise*0.5)+(Math.random() * _noise));
            var noiseY:Number = angle-((_noise*0.5)+(Math.random() * _noise));
            var noiseZ:Number = angle-((_noise*0.5)+(Math.random() * _noise));
            
            var x:Number = x0 + leng * (Math.cos(noiseX * _PI));
            var y:Number = y0 + leng * (Math.sin(noiseY * _PI));
            var z:Number = z0 + leng * (-Math.cos(noiseZ * _PI));                
            if (n == _N && n % 2 == 0) {                
                drawLine3D(1, x0, y0, z0, x, y, z);                
            } else {    
                            
                
                drawLine3D(1, x0, y0, z0, x, y, z);    
                //treeZ(n, x0, y0, z0, leng, angle);
                treeY(n, x0, y0, z0, leng, angle);    
            }
            
            n -= 1;
            
            tree(n, x, y, z, leng/_scale, angle - _branch);
            tree(n, x, y, z, leng/_scale, angle + _branch);            
        }    
        
        private function treeZ(n:Number, x0:Number, y0:Number, z0:Number, leng:Number, angle:Number):void {
            if (n <= 0)
                return;
            
            var x:Number = x0 + leng * (Math.cos(angle * _PI));
            var y:Number = y0 + leng * (Math.sin(angle * _PI));
            var z:Number = z0 + leng * (Math.cos(angle * _PI));            
            
            _line1.addNewLine(1, x0, y0, z0, x, y, z);
            n -= 1;
            treeZ(n, x, y, z, leng/_scale, angle-_branch);
            treeZ(n, x, y, z, leng/_scale, angle+_branch);            
        }
        
        private function treeY(n:Number, x0:Number, y0:Number, z0:Number, leng:Number, angle:Number):void {
            if (n <= 0)
                return;
            
            var x:Number = x0 - leng * (Math.cos(angle * _PI));
            var y:Number = y0 + leng * (Math.sin(angle * _PI));
            var z:Number = z0 - leng * (Math.cos(angle * _PI));            
            //Lineの太さは1とする
            _line1.addNewLine(1, x0, y0, z0, x, y, z);
            n -= 1;
            treeY(n, x, y, z, leng/_scale, angle-_branch);
            treeY(n, x, y, z, leng/_scale, angle+_branch);            
        }        
        
        private function drawLine3D(n:Number, x0:Number, y0:Number, z0:Number, x:Number, y:Number, z:Number):void {
            //Line太さは1としているn=1
            _line1.addNewLine(n, x0, y0, z0, x, y, z);            
        }
        
        override protected function onRenderTick(event:Event = null):void {                        
            super.onRenderTick(event);
        }        
    }    
}