/**
 * Copyright H.S ( http://wonderfl.net/user/H.S )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ss0J
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;

    public class Main extends Sprite {
        public var startNode:Node;
        public var goalNode:Node;
        public var nodes:Array = [];
        public function Main():void {
            /*graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);*/
            for (var i:int = 0; i < 5; i++ ) {
                for (var j:int = 0; j < 5; j++ ) {
                    nodes.push(new Node(this, 82.5 + 75 * j, 82.5 + 75 * i));
                }
            }
            for each(var node:Node in nodes) {
                var index:int = nodes.indexOf(node);
                if (index > 4) node.connectedNodes.push(nodes[index - 5]);
                if (index < 20) node.connectedNodes.push(nodes[index + 5]);
                if (index % 5 != 0) node.connectedNodes.push(nodes[index - 1]);
                if ((index + 1) % 5 != 0) node.connectedNodes.push(nodes[index + 1]);
            }
            startNode = nodes[0];
            goalNode = nodes[24];
            goalNode.drawStairs();
            routeSearch();
            var hamster:Hamster = new Hamster(this, startNode.x, startNode.y);
        }
        public function routeSearch():void {
            //Dijkstra's algorithm
            while(!goalNode.doneFlag){
                var node:Node;
                if (!startNode.doneFlag) {
                    node = startNode;
                    node.doneFlag = true;
                    node.cost = 0;
                }
                else {
                    nodes.sortOn("cost", Array.NUMERIC);
                    node = nodes.filter(callback)[0];
                    function callback(node:Node, index:int, array:Array):Boolean {
                        return (node.cost !=- 1 && !node.doneFlag);
                    }
                }
                for each(var connectedNode:Node in node.connectedNodes) {
                    var cost:Number = node.cost + Math.sqrt(Math.pow(connectedNode.x - node.x, 2) + Math.pow(connectedNode.y - node.y, 2));
                    if (connectedNode.cost == -1 || connectedNode.cost > cost) {
                        connectedNode.cost = cost;
                        connectedNode.fromNode = node;
                    }
                    node.doneFlag = true;
                }
            }
            while (node.fromNode != null) {
                node.fromNode.drawSquare();
                node.fromNode.toNode = node;
                node = node.fromNode;
            }
        }
        public function nodesReset():void {
            for each(var node:Node in nodes) {
                node.reset();
            }
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.utils.Timer;

class Node extends Sprite {
    public var connectedNodes:Array = [];
    public var fromNode:Node;
    public var toNode:Node;
    public var doneFlag:Boolean;
    public var cost:Number = -1;
    public function Node(parent:Main, xpos:Number, ypos:Number):void {
        parent.addChild(this);
        x = xpos;
        y = ypos;
    }
    public function drawStairs():void {
        graphics.beginFill(0x000000);
        graphics.drawRect( -38.5, -38.5, 77, 77);
        graphics.beginFill(0xBEBEBE);
        graphics.drawRect( -36.5, -36.5, 73, 73);
        graphics.beginFill(0x000000);
        graphics.drawRect( -28.5, -28.5, 57, 57);
        graphics.beginFill(0xBEBEBE);
        graphics.drawRect( -25.5, -1.5, 15, 27);
        graphics.drawRect( -7.5, -10.5, 15, 36);
        graphics.drawRect( 10.5, -22.5, 15, 48);
        graphics.endFill();
    }
    public function drawSquare():void {
        graphics.lineStyle(2, 0x000000);
        graphics.beginFill(0xFFFFFF);
        graphics.drawRect( -75 / 2, -75 / 2, 75, 75);
    }
    public function reset():void {
        graphics.clear();
        doneFlag = false;
        fromNode = null;
        toNode = null;
        cost = -1;
    }
}

class Hamster extends Sprite {
    private var currentNode:Node;
    private var nextNode:Node;
    private var speed:Number = 3;
    private var count:int;
    private var step:int;
    private var loader:Loader
    private var bitmap:Bitmap;
    private var timer:Timer;
    public function Hamster(parent:Main, xpos:Number, ypos:Number ):void {
        parent.addChild(this);
        x = xpos;
        y = ypos;
        mouseEnabled = false;
        currentNode = parent.startNode;
        nextNode = currentNode.toNode;
        var bitmapData:BitmapData = new BitmapData(75, 75, true, 0x00000000);
        bitmap  = new Bitmap(bitmapData)
        addChild(bitmap);
        bitmap.x = -bitmap.width / 2;
        bitmap.y = -bitmap.height / 2;
        timer = new Timer(1000, 3);
        timer.addEventListener(TimerEvent.TIMER, timerHandler);
        loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
        loader.load(new URLRequest("http://chococornet.sakura.ne.jp/img/hamster.png"), new LoaderContext(true));
    }
    private function completeHandler(event:Event):void {
        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
    }
    private function enterFrameHandler(event:Event):void {
        bitmap.bitmapData.copyPixels(Bitmap(loader.content).bitmapData, new Rectangle(step * bitmap.width, 0, bitmap.width, bitmap.height), new Point(0, 0));
        if (count % 4 == 0) step++;
        if (step == 4) step = 0;
        count++;
        if (count == 16) count =0;
        if (currentNode == nextNode) {
            if (currentNode == Main(parent).goalNode) {
                with (Main(parent)) {
                    startNode = currentNode;
                    while(startNode == goalNode){
                        goalNode = nodes[Math.floor(Math.random() * 25)];
                    }
                     nodesReset();
                }
                timer.start();
            }
            else if(!timer.running) nextNode = currentNode.toNode;
        }
        var rad:Number = Math.atan2(nextNode.y - y, nextNode.x - x);
        if (currentNode != Main(parent).goalNode && Math.abs(rad) != Math.PI / 2 && !timer.running) {
            if (rad < Math.PI / 2 && rad > -Math.PI / 2) {
                bitmap.scaleX = 1;
                bitmap.x = -bitmap.width / 2;
            }
            else {
                bitmap.scaleX = -1;
                bitmap.x = bitmap.width / 2;
            }
        }
        if (Math.abs(nextNode.x - x) > Math.abs(speed * Math.cos(rad))) {
            x += speed * Math.cos(rad);
        }
        else x = nextNode.x;
        if (Math.abs(nextNode.y - y) > Math.abs(speed * Math.sin(rad))) {
            y += speed * Math.sin(rad);
        }
        else y = nextNode.y;
        if (x == nextNode.x && y == nextNode.y) {
            currentNode = nextNode;
        }
    }
    private function timerHandler(event:TimerEvent):void {
        if (event.target.currentCount == 1) {
            Main(parent).goalNode.drawStairs();
        }
        else if(event.target.currentCount == 2) {
            Main(parent).routeSearch();
        }
        else {
            event.target.reset();
        }
    }
}