/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sdkz
 */

package  
{
    import com.bit101.components.NumericStepper;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    public class Polygon extends Sprite
    {
        private var sprite:Sprite;
        private var sidesAmount:Number;
        private var delta:Number;
        private var spriteRotation:int;
        
        public function Polygon() 
        {
            new NumericStepper(this, 0, 0, sidesAmountHandle).value =sidesAmount = 5;
            init();
            addEventListener(Event.ENTER_FRAME,loop ,false,0,true );
        }
        
        private function init():void 
        {
            sprite = Sprite(addChild(new Sprite));
            sprite.x = stage.stageWidth >> 1;
            sprite.y = stage.stageHeight >> 1;
            var g:Graphics = sprite.graphics;
            g.lineStyle(0);
            var angle:Number = 0;
            var radius:Number = 100;
            g.moveTo(radius * Math.cos(angle), radius * Math.sin(angle));
            delta = Math.PI * 2 / sidesAmount;
            
            for (var i:int = 0; i < sidesAmount; i++) 
            {
                angle += delta;
                g.lineTo(radius * Math.cos(angle), radius * Math.sin(angle));
                
            }
            g.lineStyle(0,0xff);
            angle = 0.5 * delta;
            radius *= Math.cos(delta * 0.5); 
            g.moveTo(radius * Math.cos(angle), radius * Math.sin(angle));
            for (i= 0; i < sidesAmount; i++) 
            {
                angle += delta;
                g.lineTo(radius * Math.cos(angle), radius * Math.sin(angle));
                
            }
            
        }
        private function loop(e:Event):void
        { 
            sprite.rotation = (spriteRotation > 360)?0:++spriteRotation; 
            spriteRotation= sprite.rotation;
            //trace(spriteRotation);
        }
        
        private function sidesAmountHandle(e:Event):void 
        {
            
            removeChild(sprite);
            sprite = null;
            sidesAmount = NumericStepper(e.target).value;
            init();
            
        }
        
    }

}